<?php
/*---------------------------------------------------------
* File:webPartsFactory.php
* Author:Tomix
* Description: WebParts 工廠類
* Created:2009-7-9
* -------------------------------------------------------
* Modified history:
* -------------------------------------------------------
* Copyright:
* -------------------------------------------------------
*/
	require_once dirname(__FILE__)."/webPartBase.php";
	class webPartsFactory{
		//創建webpart實例入口
		static public function create($webPartName){
			$instance = null;
			$fileName = dirname(__FILE__)."/".$webPartName.".php";
			if(self::requireFile($fileName)){
				switch($webPartName){
					case "header":
						if(class_exists("_header"))
							$instance = new _header();
						break;
					case "banner":
						if(class_exists("_banner"))
							$instance = new _banner();
						break;
					case "footer":
						if(class_exists("_footer"))
							$instance = new _footer();
						break;
					case "sidePage":
						if(class_exists("_sidePage"))
							$instance = new _sidePage();
						break;
					case "sidePage2":
						if(class_exists("_sidePage2"))
							$instance = new _sidePage2();
						break;
					default:
						break;
				}//end switch
			}//end if
			return $instance;
		}

		static private function requireFile($fileName){
			if(!file_exists($fileName))
				return false;
			require_once $fileName;
			return true;
		}
	}
?>