<?php
	require_once dirname(__FILE__)."/../bin/web/repeater.php";
	require_once dirname(__FILE__)."/../dal/pictureDAL.php";
	require_once dirname(__FILE__)."/../dal/productDAL.php";
	require_once dirname(__FILE__)."/../dal/categoryDAL.php";
	require_once dirname(__FILE__)."/../dal/newsDAL.php";

	class _sidePage extends webPartBase{
		public $picturetype;
		public $htLink4,$htLink2;
		public function load(){
			$this->loadData();
			parent::loadTemplateFile(dirname(__FILE__)."/../templates/webParts/".$this->registry->webTemplates."/sidePage.html");
			parent::load();
		}

		public function loadData(){
			//商品分類列表
			$aryCSPS = explode(",",$this->registry->categorySidePageShow);
			if(in_array($this->picturetype,$aryCSPS)){
				parent::addParameter("sideCategoryStyle","");
			}else{
				parent::addParameter("sideCategoryStyle"," style='display:none;'");
			}
			$dalC = new categoryDAL();
			$dataC = $dalC->executeRecordset("a.`ParentID`='0' AND a.`Visible`='1'");
			for($i=0;$i<count($dataC);$i++){
				$dataC[$i]["htLink"] = $this->htLink4;
				$dataSC = $dalC->executeRecordset("a.`ParentID`='".$dataC[$i]["CategoryID"]."' AND a.`Visible`='1'");
				if(count($dataSC) > 0){
					$dataC[$i]["SubList"] = "<ul class='sub-category'>";
					for($j=0;$j<count($dataSC);$j++){
						$dataC[$i]["SubList"] .= "<li><a href='".$this->htLink4.$dataSC[$j]["CategoryID"].".html'>".$dataSC[$j]["CategoryName"]."</a></li>";
					}
					$dataC[$i]["SubList"] .= "</ul>";
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);
			
			parent::addParameter("webH1",$this->registry->webH1);
			parent::addParameter("webTitle",$this->registry->webTitle);
			parent::addParameter("webKeyword",$this->registry->webKeyword);
			parent::addParameter("lineQRCode",$this->registry->lineQRCode);
			parent::addParameter("lineTitle",$this->registry->lineTitle);
			parent::addParameter("webMarquee",$this->registry->webMarquee);
			if($this->registry->lineQRCode == ""){
				parent::addParameter("QRstyle","display:none;");
			}
			$aryPS = explode(",",$this->registry->fbFansSidePageShow);
			if(in_array($this->picturetype,$aryPS)){
				if(trim($this->registry->fbFansURL) != ''){
					switch($this->registry->fbFansSidePageType){
						case "1":
							$fbFans = "<div class='fb-fans'><a href='".$this->registry->fbFansURL."' target='_blank'><img src='/images/fb-fans.jpg' style='width:100%;'></a></div>";
							break;
						case "2":
							$fbFans = "<div class='fb-fans'><a href='".$this->registry->fbFansURL."' target='_blank'><img src='";
							if(trim($this->registry->fbFansLOGO) == ''){
								$fbFans .= '/images/fb-fans.jpg';
							}else{
								if(file_exists(".".$this->registry->fbFansLOGO)){
									$fbFans .= $this->registry->fbFansLOGO;
								}else{
									$fbFans .= '/images/fb-fans.jpg';
								}
							}
							$fbFans .= "'></a></div>";
							break;
						case "3":
							if($this->registry->fbFansFriendFace == '0'){
								$facepile = 'false';
							}else{
								$facepile = 'true';
							}
							if($this->registry->fbFansCoverPhoto == '1'){
								$hidecover = 'false';
							}else{
								$hidecover = 'true';
							}
							if($this->registry->fbFansPagePost == '0'){
								$showpost = 'false';
							}else{
								$showpost = 'true';
							}
							$fbFans = '<div class="fb-page" data-href="'.$this->registry->fbFansURL.'" data-hide-cover="'.$hidecover.'" data-show-facepile="'.$facepile.'" data-show-posts="'.$showpost.'"><div class="fb-xfbml-parse-ignore"><blockquote cite="'.$this->registry->fbFansURL.'"><a href="'.$this->registry->fbFansURL.'">Facebook</a></blockquote></div></div>';
							break;
						default:
							$fbFans = '';
							break;
					}
				}else{
					$fbFans = '';
				}
			}else{
				$fbFans = '';
			}
			parent::addParameter("fbFans",$fbFans);
			
			$aryGMSPS = explode(",",$this->registry->googlemapSidePageShow);
			if(in_array($this->picturetype,$aryGMSPS)){
				if(trim($this->registry->googlemapAddress) != ''){
					parent::addParameter("googlemapStyle","");
					parent::addParameter("googlemapAddress",urlencode($this->registry->googlemapAddress));
				}else{
					parent::addParameter("googlemapStyle"," style='display:none;'");
					parent::addParameter("googlemapAddress","");
				}
			}else{
				parent::addParameter("googlemapStyle"," style='display:none;'");
				parent::addParameter("googlemapAddress","");
			}
			
			$aryYSPS = explode(",",$this->registry->youtubeSidePageShow);
			if(in_array($this->picturetype,$aryYSPS)){
				if(trim($this->registry->youtubeURL) != ''){
					parent::addParameter("youtubeStyle","");
					$youtubeURL = str_replace("//youtu.be/","//www.youtube.com/embed/",$this->registry->youtubeURL);
					parent::addParameter("youtubeURL",$youtubeURL);
				}else{
					parent::addParameter("youtubeStyle"," style='display:none;'");
					parent::addParameter("youtubeURL","");
				}
			}else{
				parent::addParameter("youtubeStyle"," style='display:none;'");
				parent::addParameter("youtubeURL","");
			}
			
			//網站資訊
			$isShow = 0;

			//客服信箱是否顯示
			if($this->registry->webEmail == ""){
				parent::addParameter("webEmail","");
				parent::addParameter("webEmailStyle"," style='display:none;'");
			}else{
				if($this->registry->webEmailisShow == "1"){
					$isShow = 1;
					parent::addParameter("webEmail",$this->registry->webEmail);
					parent::addParameter("webEmailStyle","");
				}else{
					parent::addParameter("webEmail","");
					parent::addParameter("webEmailStyle"," style='display:none;'");
				}
			}
			
			//聯絡地址是否顯示
			if($this->registry->webAddress == ""){
				parent::addParameter("webAddress","");
				parent::addParameter("webAddressStyle"," style='display:none;'");
				parent::addParameter("webAddressLink","javascript:void(0);");
			}else{
				if($this->registry->webAddressisShow == "1"){
					$isShow = 1;
					parent::addParameter("webAddress",$this->registry->webAddress);
					parent::addParameter("webAddressStyle","");
					if(trim($this->registry->webAddress) != ''){
						$webAddressLink = "http://maps.google.com/maps?ll=23.016519,120.21529&z=15&t=m&hl=zh-TW&gl=US&mapclient=embed&q=".urlencode(trim($this->registry->webAddress));
					}else{
						$webAddressLink = "javascript:void(0);";
					}
					parent::addParameter("webAddressLink",$webAddressLink);
				}else{
					parent::addParameter("webAddress","");
					parent::addParameter("webAddressStyle"," style='display:none;'");
					parent::addParameter("webAddressLink","javascript:void(0);");
				}
			}
			
			//聯絡電話是否顯示
			if($this->registry->webPhone == ""){
				parent::addParameter("webPhone","");
				parent::addParameter("webPhoneStyle"," style='display:none;'");
			}else{
				if($this->registry->webPhoneisShow == "1"){
					$isShow = 1;
					parent::addParameter("webPhone",$this->registry->webPhone);
					parent::addParameter("webPhoneStyle","");
				}else{
					parent::addParameter("webPhone","");
					parent::addParameter("webPhoneStyle"," style='display:none;'");
				}
			}
			
			//聯絡傳真是否顯示
			if($this->registry->webFax == ""){
				parent::addParameter("webFax","");
				parent::addParameter("webFaxStyle"," style='display:none;'");
			}else{
				if($this->registry->webFaxisShow == "1"){
					$isShow = 1;
					parent::addParameter("webFax",$this->registry->webFax);
					parent::addParameter("webFaxStyle","");
				}else{
					parent::addParameter("webFax","");
					parent::addParameter("webFaxStyle"," style='display:none;'");
				}
			}
			if($isShow == 1){
				parent::addParameter("webInfoStyle","");
			}else{
				parent::addParameter("webInfoStyle"," style='display:none;'");
			}
			
			//網站資訊是否顯示
			$arySN = explode(",",$this->registry->sideNavShow);
			if(in_array($this->picturetype,$arySN)){
				parent::addParameter("sideNavStyle","");
			}else{
				parent::addParameter("sideNavStyle"," style='display:none;'");
			}
			
			//小廣告設置
			$arySP = explode(",",$this->registry->smallPictureShow);
			if(in_array($this->picturetype,$arySP)){
				parent::addParameter("smallPictureStyle","");
			}else{
				parent::addParameter("smallPictureStyle"," style='display:none;'");
			}
			
			//Google MAP
			if($this->registry->googlemapIndex == "1" && trim($this->registry->googlemapAddress) != ""){
				parent::addParameter("googlemapStyle","");
				parent::addParameter("googlemapAddress",urlencode($this->registry->googlemapAddress));
			}else{
				parent::addParameter("googlemapStyle"," style='display:none;'");
				parent::addParameter("googlemapAddress","");
			}
			
			//相關產品
			$aryOP = array();
			$dalOP = new productDAL();
			$dataOP = $dalOP->executeRecordset($filter,"RAND()",0,4);
			for($i=0;$i<count($dataOP);$i++){
				$dataOP[$i]["htLink"] = $this->htLink4;
				if(trim($dataOP[$i]["IconImage"]) == "" || !file_exists(".".$dataOP[$i]["IconImage"])){
					$dataOP[$i]["IconImage"] = "/images/no-pic.jpg";
					$dataOP[$i]["imageStyle"] = " style='display:none;'";
				}else{
					$dataOP[$i]["imageStyle"] = "";
				}
			}
			$listOP = new repeater();
			$listOP->id = "listOP";
			$listOP->dataSource = $dataOP;
			parent::addControl($listOP);

			//Photo
			$aryP = array();
			$dalP = new pictureDAL();
			$dataP = $dalP->executeRecordset("a.`PictureType`='120'","a.`TypeOrderNO`");
			for($i=0;$i<count($dataP);$i++){
				if(trim($dataP[$i]["Image"]) != "" && file_exists(".".$dataP[$i]["Image"])){
					$ary = array();
					$ary["Image"] = $dataP[$i]["Image"];
					$ary["Title"] = $dataP[$i]["Title"];
					if(trim($dataP[$i]["Link"]) == ""){
						$ary["Link"] = "javascript:void(0);";
					}else{
						$ary["Link"] = $dataP[$i]["Link"];
					}
					$aryP[] = $ary;
				}
			}
			$listP = new repeater();
			$listP->id = "listP";
			$listP->dataSource = $aryP;
			parent::addControl($listP);
			
			//最新消息
			$dalN = new newsDAL();
			$dataN = $dalN->executeRecordset("a.`Visible`='1' AND a.`OnlineTime`<='".date("Y-m-d H:i:s")."'","",0,20);
			for($i=0;$i<count($dataN);$i++){
				if(trim($dataN[$i]["Image"]) == "" || !file_exists(".".$dataN[$i]["Image"])){
					$dataN[$i]["Image"] = $this->NoPicImage;
				}else{
					$dataN[$i]["imageStyle"] = "";
				}
				$dataN[$i]["sTitle"] = string::cut_str($dataN[$i]["Title"],"15");
				$dataN[$i]["sIntroduction"] = string::cut_str($dataN[$i]["Introduction"],"50");
				$dataN[$i]["OnlineDate"] = date("Y-m-d",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["OnlineDY"] = date("Y",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["OnlineDM"] = date("m",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["OnlineDD"] = date("d",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["OnlineDM2"] = date("M",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["htLink"] = $this->htLink2;
			}
			$listN = new repeater();
			$listN->id = "listN";
			$listN->dataSource = $dataN;
			parent::addControl($listN);
		}
	}
?>