<?php
	require_once "registry.php";
	require_once "dal/articleDAL.php";
	require_once "dal/bookDAL.php";
	require_once "dal/book_categoryDAL.php";
	require_once "dal/categoryDAL.php";
	require_once "dal/faq_categoryDAL.php";
	require_once "dal/htaccessDAL.php";
	require_once "dal/newsDAL.php";
	require_once "dal/news_categoryDAL.php";
	require_once "dal/productDAL.php";

	ob_start();
	header('Content-Type: text/xml');

	$registry = registry::createInstance();
	$indexTitle = str_replace("\r\n","",trim($registry->webTitle));
	$indexDescription = str_replace("\r\n","",trim($registry->webDescription));
	$modifiedTime = strtotime($registry->ModifiedTime);

	$dalH = new htaccessDAL();
	$dalH->ID = "1";
	$dalH->loadRecord();
	$htLink1 = $dalH->HtmlName;
	$htVisible1 = $dalH->Visible;
	$dalH->ID = "2";
	$dalH->loadRecord();
	$htLink2 = $dalH->HtmlName;
	$htVisible2 = $dalH->Visible;
	$dalH->ID = "3";
	$dalH->loadRecord();
	$htLink3 = $dalH->HtmlName;
	$htVisible3 = $dalH->Visible;
	$dalH->ID = "4";
	$dalH->loadRecord();
	$htLink4 = $dalH->HtmlName;
	$htVisible4 = $dalH->Visible;
	$dalH->ID = "5";
	$dalH->loadRecord();
	$htLink5 = $dalH->HtmlName;
	$htVisible5 = $dalH->Visible;
	$dalH->ID = "6";
	$dalH->loadRecord();
	$htLink6 = $dalH->HtmlName;
	$htVisible6 = $dalH->Visible;

	$dom = new DomDocument("1.0","UTF-8");
	$dom->formatOutput = true;
	$rss = $dom->createElement("rss");
	$dom->appendChild($rss);

	$rssVersion = $dom->createAttribute("version");
	$rssVersion->value = "2.0";
	$rss->appendChild($rssVersion);

	$rssAtom = $dom->createAttribute("xmlns:atom");
	$rssAtom->value = "https://www.w3.org/2005/Atom";
	$rss->appendChild($rssAtom);

	$channel = $dom->createElement("channel");
	$rss->appendChild($channel);

	$channelTitle = $dom->createElement("title",$indexTitle);
	$channel->appendChild($channelTitle);

	$channelLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/");
	$channel->appendChild($channelLink);

	$channelDescription = $dom->createElement("description",$indexDescription);
	$channel->appendChild($channelDescription);

	$channelAtom = $dom->createElement("atom:link");
	$channel->appendChild($channelAtom);
	$atomhref = $dom->createAttribute("href");
	$atomhref->value = "https://".$_SERVER['HTTP_HOST']."/rss.xml";
	$channelAtom->appendChild($atomhref);
	$atomrel = $dom->createAttribute("rel");
	$atomrel->value = "self";
	$channelAtom->appendChild($atomrel);
	$atomtype = $dom->createAttribute("type");
	$atomtype->value = "application/rss+xml";
	$channelAtom->appendChild($atomtype);

	$item = $dom->createElement("item");
	$channel->appendChild($item);

	$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/");
	$item->appendChild($itemLink);
	$itemTitle = $dom->createElement("title",$indexTitle);
	$item->appendChild($itemTitle);
	$itemDescription = $dom->createElement("description",$indexDescription);
	$item->appendChild($itemDescription);
	$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O"));
	$item->appendChild($updatePeriod);
	$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/");
	$item->appendChild($sortOrder);
	$resourceOf = $dom->createAttribute("isPermaLink");
	$resourceOf->value = "false";
	$sortOrder->appendChild($resourceOf);

	if($htVisible1 == "1"){
		$dalA = new articleDAL();
		$dataA = $dalA->executeRecordset("a.`Visible`='1'","b.`OrderNO`,b.`CategoryID`,a.`OrderNO`,a.`ArticleID`");
		for($i=0;$i<count($dataA);$i++){
			$item = $dom->createElement("item");
			$channel->appendChild($item);

			$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink1."-".$dataA[$i]["PathName"].".html");
			$item->appendChild($itemLink);

			if(trim($dataA[$i]["WebTitle"]) == ""){
				$dataA[$i]["WebTitle"] = $indexTitle;
			}
			$itemTitle = $dom->createElement("title",str_replace("\r\n","",trim($dataA[$i]["WebTitle"])));
			$item->appendChild($itemTitle);

			if(trim($dataA[$i]["WebDescription"]) == ""){
				$dataA[$i]["WebDescription"] = $indexDescription;
			}
			$itemDescription = $dom->createElement("description",str_replace("\r\n","",trim($dataA[$i]["WebDescription"])));
			$item->appendChild($itemDescription);

			$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O",strtotime($dataA[$i]["ModifiedTime"])));
			$item->appendChild($updatePeriod);
			$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink1."-".$dataA[$i]["PathName"].".html");
			$item->appendChild($sortOrder);
			$resourceOf = $dom->createAttribute("isPermaLink");
			$resourceOf->value = "false";
			$sortOrder->appendChild($resourceOf);
		}
	}

	if($htVisible2 == "1"){
		$item = $dom->createElement("item");
		$channel->appendChild($item);

		$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink2.".html");
		$item->appendChild($itemLink);
		$itemTitle = $dom->createElement("title",$indexTitle);
		$item->appendChild($itemTitle);
		$itemDescription = $dom->createElement("description",$indexDescription);
		$item->appendChild($itemDescription);
		$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O"));
		$item->appendChild($updatePeriod);
		$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink2.".html");
		$item->appendChild($sortOrder);
		$resourceOf = $dom->createAttribute("isPermaLink");
		$resourceOf->value = "false";
		$sortOrder->appendChild($resourceOf);

		$dalN = new newsDAL();
		$dalNC = new news_categoryDAL();
		$dataNC = $dalNC->executeRecordset("a.`Visible`='1'");
		for($i=0;$i<count($dataNC);$i++){
			$item = $dom->createElement("item");
			$channel->appendChild($item);

			$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink2.$dataNC[$i]["CategoryID"].".html");
			$item->appendChild($itemLink);

			if(trim($dataNC[$i]["WebTitle"]) == ""){
				$dataNC[$i]["WebTitle"] = $indexTitle;
			}
			$itemTitle = $dom->createElement("title",str_replace("\r\n","",trim($dataNC[$i]["WebTitle"])));
			$item->appendChild($itemTitle);

			if(trim($dataNC[$i]["WebDescription"]) == ""){
				$dataNC[$i]["WebDescription"] = $indexDescription;
			}
			$itemDescription = $dom->createElement("description",str_replace("\r\n","",trim($dataNC[$i]["WebDescription"])));
			$item->appendChild($itemDescription);

			$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O"));
			$item->appendChild($updatePeriod);
			$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink2.$dataNC[$i]["CategoryID"].".html");
			$item->appendChild($sortOrder);
			$resourceOf = $dom->createAttribute("isPermaLink");
			$resourceOf->value = "false";
			$sortOrder->appendChild($resourceOf);

			$dataN = $dalN->executeRecordset("a.`CategoryID`='".$dataNC[$i]["CategoryID"]."' AND a.`Visible`='1' AND a.`OnlineTime`<='".date("Y-m-d H:i:s")."'","a.`OrderNO`,a.`OnlineTime` DESC");
			for($j=0;$j<count($dataN);$j++){
				$item = $dom->createElement("item");
				$channel->appendChild($item);

				$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink2."-".$dataN[$j]["NewsID"].".html");
				$item->appendChild($itemLink);

				if(trim($dataN[$j]["WebTitle"]) == ""){
					$dataN[$j]["WebTitle"] = $indexTitle;
				}
				$itemTitle = $dom->createElement("title",str_replace("\r\n","",trim($dataN[$j]["WebTitle"])));
				$item->appendChild($itemTitle);

				if(trim($dataN[$j]["WebDescription"]) == ""){
					$dataN[$j]["WebDescription"] = $indexDescription;
				}
				$itemDescription = $dom->createElement("description",str_replace("\r\n","",trim($dataN[$j]["WebDescription"])));
				$item->appendChild($itemDescription);

				$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O",strtotime($dataN[$j]["OnlineTime"])));
				$item->appendChild($updatePeriod);
				$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink2."-".$dataN[$j]["NewsID"].".html");
				$item->appendChild($sortOrder);
				$resourceOf = $dom->createAttribute("isPermaLink");
				$resourceOf->value = "false";
				$sortOrder->appendChild($resourceOf);
			}
		}
	}

	if($htVisible3 == "1"){
		$item = $dom->createElement("item");
		$channel->appendChild($item);

		$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink3.".html");
		$item->appendChild($itemLink);
		$itemTitle = $dom->createElement("title",$indexTitle);
		$item->appendChild($itemTitle);
		$itemDescription = $dom->createElement("description",$indexDescription);
		$item->appendChild($itemDescription);
		$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O"));
		$item->appendChild($updatePeriod);
		$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink3.".html");
		$item->appendChild($sortOrder);
		$resourceOf = $dom->createAttribute("isPermaLink");
		$resourceOf->value = "false";
		$sortOrder->appendChild($resourceOf);

		$dalFC = new faq_categoryDAL();
		$dataFC = $dalFC->executeRecordset("a.`Visible`='1'");
		for($i=0;$i<count($dataFC);$i++){
			$item = $dom->createElement("item");
			$channel->appendChild($item);

			$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink3.$dataFC[$i]["CategoryID"].".html");
			$item->appendChild($itemLink);

			if(trim($dataFC[$i]["WebTitle"]) == ""){
				$dataFC[$i]["WebTitle"] = $indexTitle;
			}
			$itemTitle = $dom->createElement("title",str_replace("\r\n","",trim($dataFC[$i]["WebTitle"])));
			$item->appendChild($itemTitle);

			if(trim($dataFC[$i]["WebDescription"]) == ""){
				$dataFC[$i]["WebDescription"] = $indexDescription;
			}
			$itemDescription = $dom->createElement("description",str_replace("\r\n","",trim($dataFC[$i]["WebDescription"])));
			$item->appendChild($itemDescription);

			$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O"));
			$item->appendChild($updatePeriod);
			$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink3.$dataFC[$i]["CategoryID"].".html");
			$item->appendChild($sortOrder);
			$resourceOf = $dom->createAttribute("isPermaLink");
			$resourceOf->value = "false";
			$sortOrder->appendChild($resourceOf);
		}
	}

	if($htVisible4 == "1"){
		$item = $dom->createElement("item");
		$channel->appendChild($item);

		$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink4.".html");
		$item->appendChild($itemLink);
		$itemTitle = $dom->createElement("title",$indexTitle);
		$item->appendChild($itemTitle);
		$itemDescription = $dom->createElement("description",$indexDescription);
		$item->appendChild($itemDescription);
		$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O"));
		$item->appendChild($updatePeriod);
		$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink4.".html");
		$item->appendChild($sortOrder);
		$resourceOf = $dom->createAttribute("isPermaLink");
		$resourceOf->value = "false";
		$sortOrder->appendChild($resourceOf);

		$dalC = new categoryDAL();
		$dalP = new productDAL();
		$dataC = $dalC->executeRecordset("a.`Visible`='1' AND (a.`ParentID`='0' OR b.`Visible`='1')","b.`OrderNO`,a.`OrderNO`");
		for($i=0;$i<count($dataC);$i++){
			$item = $dom->createElement("item");
			$channel->appendChild($item);

			$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink4.$dataC[$i]["CategoryID"].".html");
			$item->appendChild($itemLink);

			if(trim($dataC[$i]["WebTitle"]) == ""){
				$dataC[$i]["WebTitle"] = $indexTitle;
			}
			$itemTitle = $dom->createElement("title",str_replace("\r\n","",trim($dataC[$i]["WebTitle"])));
			$item->appendChild($itemTitle);

			if(trim($dataC[$i]["WebDescription"]) == ""){
				$dataC[$i]["WebDescription"] = $indexDescription;
			}
			$itemDescription = $dom->createElement("description",str_replace("\r\n","",trim($dataC[$i]["WebDescription"])));
			$item->appendChild($itemDescription);

			$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O",strtotime($dataC[$i]["ModifiedTime"])));
			$item->appendChild($updatePeriod);
			$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink4.$dataC[$i]["CategoryID"].".html");
			$item->appendChild($sortOrder);
			$resourceOf = $dom->createAttribute("isPermaLink");
			$resourceOf->value = "false";
			$sortOrder->appendChild($resourceOf);

			$dataP = $dalP->executeRecordset("a.`CategoryID`='".$dataC[$i]["CategoryID"]."' AND a.`Visible`='1'","a.`OrderNO`,a.`ModifiedTime` DESC");
			for($j=0;$j<count($dataP);$j++){
				$item = $dom->createElement("item");
				$channel->appendChild($item);

				$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink4."-".$dataP[$j]["ProductID"].".html");
				$item->appendChild($itemLink);

				if(trim($dataP[$j]["WebTitle"]) == ""){
					$dataP[$j]["WebTitle"] = $indexTitle;
				}
				$itemTitle = $dom->createElement("title",str_replace("\r\n","",trim($dataP[$j]["WebTitle"])));
				$item->appendChild($itemTitle);

				if(trim($dataP[$j]["WebDescription"]) == ""){
					$dataP[$j]["WebDescription"] = $indexDescription;
				}
				$itemDescription = $dom->createElement("description",str_replace("\r\n","",trim($dataP[$j]["WebDescription"])));
				$item->appendChild($itemDescription);

				$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O",strtotime($dataP[$j]["ModifiedTime"])));
				$item->appendChild($updatePeriod);
				$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink4."-".$dataP[$j]["ProductID"].".html");
				$item->appendChild($sortOrder);
				$resourceOf = $dom->createAttribute("isPermaLink");
				$resourceOf->value = "false";
				$sortOrder->appendChild($resourceOf);
			}
		}
	}

	if($htVisible5 == "1"){
		$item = $dom->createElement("item");
		$channel->appendChild($item);

		$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink5.".html");
		$item->appendChild($itemLink);
		$itemTitle = $dom->createElement("title",$indexTitle);
		$item->appendChild($itemTitle);
		$itemDescription = $dom->createElement("description",$indexDescription);
		$item->appendChild($itemDescription);
		$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O"));
		$item->appendChild($updatePeriod);
		$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink5.".html");
		$item->appendChild($sortOrder);
		$resourceOf = $dom->createAttribute("isPermaLink");
		$resourceOf->value = "false";
		$sortOrder->appendChild($resourceOf);

		$dalB = new bookDAL();
		$dalBC = new book_categoryDAL();
		$dataBC = $dalBC->executeRecordset("a.`Visible`='1'");
		for($i=0;$i<count($dataBC);$i++){
			$item = $dom->createElement("item");
			$channel->appendChild($item);

			$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink5.$dataBC[$i]["CategoryID"].".html");
			$item->appendChild($itemLink);

			if(trim($dataBC[$i]["WebTitle"]) == ""){
				$dataBC[$i]["WebTitle"] = $indexTitle;
			}
			$itemTitle = $dom->createElement("title",str_replace("\r\n","",trim($dataBC[$i]["WebTitle"])));
			$item->appendChild($itemTitle);

			if(trim($dataBC[$i]["WebDescription"]) == ""){
				$dataBC[$i]["WebDescription"] = $indexDescription;
			}
			$itemDescription = $dom->createElement("description",str_replace("\r\n","",trim($dataBC[$i]["WebDescription"])));
			$item->appendChild($itemDescription);

			$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O"));
			$item->appendChild($updatePeriod);
			$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink5.$dataBC[$i]["CategoryID"].".html");
			$item->appendChild($sortOrder);
			$resourceOf = $dom->createAttribute("isPermaLink");
			$resourceOf->value = "false";
			$sortOrder->appendChild($resourceOf);

			$dataB = $dalB->executeRecordset("a.`CategoryID`='".$dataBC[$i]["CategoryID"]."' AND a.`Visible`='1'","a.`OrderNO`,a.`BookID` DESC");
			for($j=0;$j<count($dataB);$j++){
				$item = $dom->createElement("item");
				$channel->appendChild($item);

				$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink5."-".$dataB[$j]["BookID"].".html");
				$item->appendChild($itemLink);

				if(trim($dataB[$j]["WebTitle"]) == ""){
					$dataB[$j]["WebTitle"] = $indexTitle;
				}
				$itemTitle = $dom->createElement("title",str_replace("\r\n","",trim($dataB[$j]["WebTitle"])));
				$item->appendChild($itemTitle);

				if(trim($dataB[$j]["WebDescription"]) == ""){
					$dataB[$j]["WebDescription"] = $indexDescription;
				}
				$itemDescription = $dom->createElement("description",str_replace("\r\n","",trim($dataB[$j]["WebDescription"])));
				$item->appendChild($itemDescription);

				$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O"));
				$item->appendChild($updatePeriod);
				$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink5."-".$dataB[$j]["BookID"].".html");
				$item->appendChild($sortOrder);
				$resourceOf = $dom->createAttribute("isPermaLink");
				$resourceOf->value = "false";
				$sortOrder->appendChild($resourceOf);
			}
		}
	}

	if($htVisible6 == "1"){
		$item = $dom->createElement("item");
		$channel->appendChild($item);

		$itemLink = $dom->createElement("link","https://".$_SERVER['HTTP_HOST']."/".$htLink6.".html");
		$item->appendChild($itemLink);
		$itemTitle = $dom->createElement("title",$indexTitle);
		$item->appendChild($itemTitle);
		$itemDescription = $dom->createElement("description",$indexDescription);
		$item->appendChild($itemDescription);
		$updatePeriod = $dom->createElement("pubDate",date("D, d M Y H:i:s O",$modifiedTime));
		$item->appendChild($updatePeriod);
		$sortOrder = $dom->createElement("guid","https://".$_SERVER['HTTP_HOST']."/".$htLink6.".html");
		$item->appendChild($sortOrder);
		$resourceOf = $dom->createAttribute("isPermaLink");
		$resourceOf->value = "false";
		$sortOrder->appendChild($resourceOf);
	}

	$xmlCode = $dom->saveXML();
	echo $xmlCode;
?>