<?php
	require_once "pageBase.php";
	require_once "bin/web/repeater.php";
	require_once "dal/categoryDAL.php";
	require_once "dal/productDAL.php";

	class _product extends pageBase{
		public function load(){
			$this->loadData();
			parent::load();
		}

		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/product.html");
			
			//橫幅廣告
			$this->picturetype = "50";

			//宣告
			$dal = new productDAL();
			$dalC = new categoryDAL();
			$id = parent::getPageParameter("id","");
			$kw = parent::getPageParameter("kw","");
			$this->pwk = $kw;
			$pageIndex = (int)parent::getPageParameter("p","1");
			if(isset($this->registry->productPageSize) && $this->registry->productPageSize != "" && $this->registry->productPageSize != "0"){
				$pageSize = (int)$this->registry->productPageSize;
			}else{
				$pageSize = 20;
			}
			$start = ($pageIndex - 1) * $pageSize;
			parent::addParameter("htLink",$this->htLink4);

			//條件式
			$filter = "a.`Visible`='1' AND b.`Visible`='1' AND (c.`Visible`='1' OR b.`ParentID`='0')";
			if($kw != ""){
				$filter .= " AND a.`ProductName` LIKE '%".$kw."%'";
			}
			$orderExp = "a.`OrderNO` DESC,d.AverageStar DESC,c.`OrderNO`,b.`OrderNO`,a.`CreatedTime` DESC";

			//產品分類資訊
			if($id != "" && $id != "0"){
				$dalC->CategoryID = $id;
				$dalC->loadRecord();
				if($dalC->Visible != "1"){
					parent::alert2("頁面不存在!!",$this->htLink4.".html");
					exit;
				}else{
					if($dalC->ParentID == "0"){						//有指定分類ID時補充條件式
						$filter .= " AND (b.`ParentID`='".$id."' OR a.`CategoryID`='".$id."')";
					}else{
						$filter .= " AND a.`CategoryID`='".$id."'";
					}
				}
				parent::addParameter("CategoryName",$dalC->CategoryName);
				parent::addParameter("CategoryID",$dalC->CategoryID);
				if(trim($dalC->WebTitle) != ""){
					parent::addParameter("webTitle",$dalC->WebTitle);
				}
				if(trim($dalC->WebKeyword) != ""){
					parent::addParameter("webKeyword",$dalC->WebKeyword);
				}
				if(trim($dalC->WebDescription) != ""){
					parent::addParameter("webDescription",$dalC->WebDescription);
				}
			}else{
				parent::addParameter("CategoryName","Top nhà cái");
				parent::addParameter("className"," class='action'");
			}

			//最新消息分類列表
			$dataC = $dalC->executeRecordset("a.`ParentID`='0' AND a.`Visible`='1'");
			for($i=0;$i<count($dataC);$i++){
				$dataC[$i]["htLink"] = $this->htLink4;
				if($dataC[$i]["CategoryID"] == $id || $dataC[$i]["CategoryID"] == $dalC->ParentID){
					$dataC[$i]["className"] = " class='action'";
				}
				$dataSC = $dalC->executeRecordset("a.`ParentID`='".$dataC[$i]["CategoryID"]."' AND a.`Visible`='1'");
				if(count($dataSC) > 0){
					$dataC[$i]["SubList"] = "<ul class='sub-category'>";
					for($j=0;$j<count($dataSC);$j++){
						$dataC[$i]["SubList"] .= "<li";
						if($dataSC[$j]["CategoryID"] == $id){
							$dataC[$i]["SubList"] .= " class='action'";
						}
						$dataC[$i]["SubList"] .= "><a href='".$this->htLink4.$dataSC[$j]["CategoryID"].".html'>".$dataSC[$j]["CategoryName"]."</a></li>";
					}
					$dataC[$i]["SubList"] .= "</ul>";
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			//產品列表
			$data = $dal->executeRecordset($filter,$orderExp,$start,$pageSize);
			for($i=0;$i<count($data);$i++){
				$data[$i]["htLink"] = $this->htLink4;
				$data[$i]["Introduction"] = str_replace("\r\n","<br />",$data[$i]["Introduction"]);
				$data[$i]["sIntroduction"] = string::cut_str(str_replace("\r\n","<br />",$data[$i]["Introduction"]),50);
				if(trim($data[$i]["IconImage"]) == "" || !file_exists(".".$data[$i]["IconImage"])){
					$data[$i]["IconImage"] = "/images/no-pic.jpg";
					$data[$i]["imageStyle"] = " style='display:none;'";
				}else{
					$data[$i]["imageStyle"] = "";
				}
				if($this->registry->webType == "20"){
					$data[$i]["sellStyle"] = "";
					$data[$i]["nosellStyle"] = "";
				}else{
					$data[$i]["sellStyle"] = " style='display:none;'";
					$data[$i]["nosellStyle"] = " style='display:none;'";
				}
				if($data[$i]["Price"] == "0" || $data[$i]["Price"] == ""){
					$data[$i]["priceStyle"] = " style='display:none;'";
				}
				if($data[$i]["OldPrice"] == "0" || $data[$i]["OldPrice"] == ""){
					$data[$i]["oldPriceStyle"] = " style='display:none;'";
				}
				if($data[$i]["ProductNO"] == ""){
					$data[$i]["NoStyle"] = " style='display:none;'";
				}else {
					parent::addParameter("NoStyle","");
				}
				$data[$i]["AverageStar"] = round($data[$i]["AverageStar"]);
				$data[$i]["averageStarIcon"] = "";
				for($j=0;$j<$data[$i]["AverageStar"];$j++){
					$data[$i]["averageStarIcon"] .= "<i class='fa fa-star light'></i>";
				}
				$data[$i]["averageStar2"] = 5 - (int)$data[$i]["AverageStar"];
				for($k=0;$k<$data[$i]["averageStar2"];$k++){
					$data[$i]["averageStarIcon"] .= "<i class='fa fa-star'></i>";
				}
				if($data[$i]["AverageStar"] <= 0){
					$data[$i]["AverageStar"] = "0";
				}
				
			}
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			//分頁
			$pageRange = 10;							//分頁範圍
			$rowCount = $dal->countRecordset($filter);
			$nm1 = $rowCount % $pageSize;				//取得不滿一頁的資料筆數
			$nm2 = ($rowCount - $nm1) / $pageSize;		//取得總頁數(目前是滿頁的頁數)
			if($nm1 > 0){								//如果有不滿一頁的資料，總頁數加一
				$nm2 = $nm2 + 1;
			}
			$nm3 = $pageIndex % $pageRange;				//取得頁數在分頁範圍的位置
			$nm4 = ($pageIndex - $nm3) / $pageRange;	//取得頁數在第幾個分頁範圍
			if($nm3 == 0){								//頁數在分頁範圍最後時，第幾個分頁範圍需要減一
				$nm4 = $nm4 - 1;
			}
			////檢查是否超過範圍
			if($rowCount > 0){
				if($pageIndex > $nm2 || $pageIndex < 1){
					parent::alert2("頁面不存在!", $this->htLink4.$id.".html");
					exit;
				}
			}else{
				if($pageIndex != 1){
					parent::alert2("頁面不存在!", $this->htLink4.$id.".html");
					exit;
				}
			}
			////上一頁////
			$pagtxt = "<a class='prev' href='".$this->htLink4.$id."_";
			if($pageIndex == 1){
				$pagtxt .= "1";
			}else{
				$pagtxt .= ($pageIndex - 1);
			}
			$pagtxt .= ".html'><i class=\"fa fa-angle-double-left\"></i></a>";
			////分頁範圍////
			for($i=1;$i<=$pageRange;$i++){
				if($nm4 * $pageRange + $i == $pageIndex){
					$pagtxt .= "<strong>".($nm4 * $pageRange + $i)."</strong>";
				}else{
					$pagtxt .= "<a href='".$this->htLink4.$id."_".($nm4 * $pageRange + $i).".html'>".($nm4 * $pageRange + $i)."</a>";
				}
				if($nm4 * $pageRange + $i == $nm2){
					$i = $pageRange + 1;
				}
			}
			////下一頁////
			$pagtxt .= "<a class='next' href='".$this->htLink4.$id."_";
			if($pageIndex == $nm2){
				$pagtxt .= $pageIndex;
			}else{
				$pagtxt .= ($pageIndex + 1);
			}
			$pagtxt .= ".html'><i class=\"fa fa-angle-double-right\"></i></a>";
			if($rowCount == 0){							////如果沒有任何資料時
				$pagtxt = "Không có dữ liệu!!";
			}
			parent::addParameter("pagtxt",$pagtxt);

			parent::loadData();
		}
	}

	$page=new _product();
	$page->load();
	$page->render();
?>