<?php
	require_once "pageBase.php";
	require_once "bin/web/repeater.php";
	require_once "dal/categoryDAL.php";
	require_once "dal/productDAL.php";
	require_once "dal/commentDAL.php";

	class _productdetail extends pageBase{
		public function load(){
			$this->loadData();
			parent::load();
		}

		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/product-detail.html");

			//橫幅廣告
			$this->picturetype = "50";

			//宣告
			$dal = new productDAL();
			$dalC = new categoryDAL();
			$dalM = new commentDAL();
			$id = parent::getPageParameter("id","0");
			parent::addParameter("htLink",$this->htLink4);
			if($this->registry->webType == "20"){
				parent::addParameter("orderStyle","");
				parent::addParameter("askStyle"," style='display:none;'");
			}else{
				parent::addParameter("orderStyle"," style='display:none;'");
				parent::addParameter("askStyle","");
			}

			//產品資訊
			$aryI = array();
			$aryT = array();
			$aryD = array();
			$pid = 0;
			$cid = 0;
			if($id == "0"){
				parent::alert2("頁面不存在!!",$this->htLink4.".html");
				exit;
			}else{
				$dal->ProductID = $id;
				$dal->loadRecord();
				if($dal->Visible != "1"){
					parent::alert2("頁面不存在!!",$this->htLink4.".html");
					exit;
				}else{
					$dalC->CategoryID = $dal->CategoryID;
					$dalC->loadRecord();
					if($dalC->Visible != "1"){
						parent::alert2("頁面不存在!!",$this->htLink4.".html");
						exit;
					}else{
						if($dalC->ParentID != "0"){
							$dalC->CategoryID = $dalC->ParentID;
							$dalC->loadRecord();
							if($dalC->Visible != "1"){
								parent::alert2("頁面不存在!!",$this->htLink4.".html");
								exit;
							}
						}
						$dal->click();
						$pid = $dal->ParentID;
						$cid = $dal->CategoryID;
						parent::addParameter("ProductID",$dal->ProductID);
						parent::addParameter("ParentID",$dal->ParentID);
						parent::addParameter("ParentName",$dal->ParentName);
						parent::addParameter("CategoryID",$dal->CategoryID);
						parent::addParameter("ProductID",$dal->ProductID);
						parent::addParameter("CategoryName",$dal->CategoryName);
						parent::addParameter("ProductName",$dal->ProductName);
						parent::addParameter("ProductNO",$dal->ProductNO);
						if($dal->ProductNO == ""){
							parent::addParameter("NoStyle"," style='display:none;'");
						}else{
							parent::addParameter("NoStyle","");
						}
						parent::addParameter("OldPrice",$dal->OldPrice);
						parent::addParameter("Price",$dal->Price);
						if($this->registry->webType == "20"){
							if($dal->OldPrice == "0" || $dal->OldPrice == ""){
								parent::addParameter("oldPriceStyle"," style='display:none;'");
							}else{
								parent::addParameter("oldPriceStyle","");
							}
							if($dal->Price == "0" || $dal->Price == ""){
								parent::addParameter("priceStyle"," style='display:none;'");
							}else{
								parent::addParameter("priceStyle","");
							}
						}else{
							parent::addParameter("oldPriceStyle"," style='display:none;'");
							parent::addParameter("priceStyle"," style='display:none;'");
						}
						if(trim($dal->IconImage) != "" && file_exists(".".$dal->IconImage)) $aryI[]["Image"] = $dal->IconImage;
						if(trim($dal->Image1) != "" && file_exists(".".$dal->Image1)) $aryI[]["Image"] = $dal->Image1;
						if(trim($dal->Image2) != "" && file_exists(".".$dal->Image2)) $aryI[]["Image"] = $dal->Image2;
						if(trim($dal->Image3) != "" && file_exists(".".$dal->Image3)) $aryI[]["Image"] = $dal->Image3;
						if(trim($dal->Image4) != "" && file_exists(".".$dal->Image4)) $aryI[]["Image"] = $dal->Image4;
						if(count($aryI) > 0){
							$aryI[0]["className"] = " class='action'";
							parent::addParameter("Image",$aryI[0]["Image"]);
							parent::addParameter("imageStyle","");
						}else{
							parent::addParameter("Image","/images/no-pic.jpg");
							parent::addParameter("imageStyle"," style='display:none;'");
						}
						for($i=0;$i<count($aryI);$i++){
							$aryI[$i]["ProductNO"] = $dal->ProductNO;
						}
						$introduction = str_replace("\r\n","<br />",$dal->Introduction);
						parent::addParameter("Introduction",$introduction);
						parent::addParameter("Description1",$dal->Description1);
						if(trim($dal->Title1) != ""){
							$no = count($aryT);
							$aryT[$no]["Title"] = $dal->Title1;
							$aryT[$no]["NO"] = $no + 1;
							$aryD[$no]["Description"] = $dal->Description1;
							$aryD[$no]["NO"] = $no + 1;
						}
						if(trim($dal->Title2) != ""){
							$no = count($aryT);
							$aryT[$no]["Title"] = $dal->Title2;
							$aryT[$no]["NO"] = $no + 1;
							$aryD[$no]["Description"] = $dal->Description2;
							$aryD[$no]["NO"] = $no + 1;
						}
						if(trim($dal->Title3) != ""){
							$no = count($aryT);
							$aryT[$no]["Title"] = $dal->Title3;
							$aryT[$no]["NO"] = $no + 1;
							$aryD[$no]["Description"] = $dal->Description3;
							$aryD[$no]["NO"] = $no + 1;
						}
						if(trim($dal->WebTitle) != ""){
							parent::addParameter("webTitle",$dal->WebTitle);
						}
						if(trim($dal->WebKeyword) != ""){
							parent::addParameter("webKeyword",$dal->WebKeyword);
						}
						if(trim($dal->WebDescription) != ""){
							parent::addParameter("webDescription",$dal->WebDescription);
						}
						
						//計算分數
						$averageStar = round($dal->AverageStar);
						$averageStarIcon = "<p class='star'>";
						for($i=0;$i<$averageStar;$i++){
							$averageStarIcon .= "<i class='fa fa-star light'></i>";
						}
						$averageStar2 = 5 - (int)$averageStar;
						for($i=0;$i<$averageStar2;$i++){
							$averageStarIcon .= "<i class='fa fa-star'></i>";
						}
						$averageStarIcon .= "</p>";
						if($dal->AverageStar > 0){
							parent::addParameter("commentC"," class='commentList'");
							parent::addParameter("commentText","");
							parent::addParameter("averageStar",$averageStar);
							parent::addParameter("totalNO",$dal->TotalNO);
						}else{
							parent::addParameter("commentC","");
							parent::addParameter("commentText","<p style='text-align:center;'>目前暫無評論!!</p>");
							parent::addParameter("averageStar","0");
							parent::addParameter("totalNO","0");
						}
						parent::addParameter("averageStarIcon",$averageStarIcon);
					}
				}
			}
			$listI = new repeater();
			$listI->id = "listI";
			$listI->dataSource = $aryI;
			parent::addControl($listI);
			$listT = new repeater();
			$listT->id = "listT";
			$listT->dataSource = $aryT;
			parent::addControl($listT);
			$listD = new repeater();
			$listD->id = "listD";
			$listD->dataSource = $aryD;
			parent::addControl($listD);

			//產品分類列表
			$dataC = $dalC->executeRecordset("a.`ParentID`='0' AND a.`Visible`='1'");
			for($i=0;$i<count($dataC);$i++){
				$dataC[$i]["htLink"] = $this->htLink4;
				if($dataC[$i]["CategoryID"] == $cid || $dataC[$i]["CategoryID"] == $pid) $dataC[$i]["className"] = " class='action'";
				$dataSC = $dalC->executeRecordset("a.`ParentID`='".$dataC[$i]["CategoryID"]."' AND a.`Visible`='1'");
				if(count($dataSC) > 0){
					$dataC[$i]["SubList"] = "<ul class='sub-category'>";
					for($j=0;$j<count($dataSC);$j++){
						$dataC[$i]["SubList"] .= "<li";
						if($dataSC[$j]["CategoryID"] == $cid) $dataC[$i]["SubList"] .= " class='action'";
						$dataC[$i]["SubList"] .= "><a href='".$this->htLink4.$dataSC[$j]["CategoryID"].".html'>".$dataSC[$j]["CategoryName"]."</a></li>";
					}
					$dataC[$i]["SubList"] .= "</ul>";
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			//上下頁
			$filter = "a.`CategoryID`='".$cid."' AND a.`Visible`='1' AND b.`Visible`='1' AND (c.`Visible`='1' OR b.`ParentID`='0')";
			$orderExp = "a.`OrderNO`,a.`CreatedTime` DESC";
			$data = $dal->executeRecordset($filter,$orderExp);
			$flagA = 0;													//判斷是否找到目前的最新消息
			for($i=0;$i<count($data);$i++){
				if($flagA == 0){
					if($data[$i]["ProductID"] == $id){
						$flagA = 1;
					}else{
						$pagUID = $data[$i]["ProductID"];				//上一筆產品的ID
						$pagUName = $data[$i]["ProductName"];			//上一筆產品的名稱
					}
				}else{
					$pagDID = $data[$i]["ProductID"];					//下一筆產品的ID
					$pagDName = $data[$i]["ProductName"];				//下一筆產品的名稱
					$i = count($data) + 1;
				}
			}
			if($pagUID != ""){
				parent::addParameter("pageUpLink",$this->htLink4."-".$pagUID.".html");
				parent::addParameter("pageUpName",$pagUName);
				parent::addParameter("pageUpStyle","");
			}else{
				parent::addParameter("pageUpLink","javascript:void(0);");
				parent::addParameter("pageUpName","-");
				parent::addParameter("pageUpStyle"," style='display:none;'");
			}
			if($pagDID != ""){
				parent::addParameter("pageDownLink",$this->htLink4."-".$pagDID.".html");
				parent::addParameter("pageDownName",$pagDName);
				parent::addParameter("pageDownStyle","");
			}else{
				parent::addParameter("pageDownLink","javascript:void(0);");
				parent::addParameter("pageDownName","-");
				parent::addParameter("pageDownStyle"," style='display:none;'");
			}
			
			//相關產品
			$dataP = $dal->executeRecordset($filter." AND a.`ProductID`!='".$id."'","RAND()",0,4);
			for($i=0;$i<count($dataP);$i++){
				$dataP[$i]["htLink"] = $this->htLink4;
				if(trim($dataP[$i]["IconImage"]) == "" || !file_exists(".".$dataP[$i]["IconImage"])){
					$dataP[$i]["IconImage"] = "/images/no-pic.jpg";
					$dataP[$i]["imageStyle"] = " style='display:none;'";
				}else{
					$dataP[$i]["imageStyle"] = "";
				}
				$dataP[$i]["Introduction"] = str_replace("\r\n","<br />",$dataP[$i]["Introduction"]);
				
				$dataP[$i]["AverageStar"] = round($dataP[$i]["AverageStar"]);
				$dataP[$i]["AverageStar2"] = 5 - (int)$dataP[$i]["AverageStar"];
				$dataP[$i]["averageStarIcon"] = "";
				for($j=0;$j<$dataP[$i]["AverageStar"];$j++){
					$dataP[$i]["averageStarIcon"] .= "<i class='fa fa-star light'></i>";
				}
				for($k=0;$k<$dataP[$i]["AverageStar2"];$k++){
					$dataP[$i]["averageStarIcon"] .= "<i class='fa fa-star'></i>";
				}
				$dataP[$i]["Star"] = ($dataP[$i]["AverageStar"] > 0) ?$dataP[$i]["AverageStar"]:"0";
			}
			$listP = new repeater();
			$listP->id = "listP";
			$listP->dataSource = $dataP;
			parent::addControl($listP);
			
			//評論
			$dataM = $dalM->executeRecordset("a.`ProductID`='".$id."' AND a.`Visible`='1' AND a.`CreatedTime`<='".date("Y-m-d H:i:s")."'","a.`CreatedTime`DESC",0,-1);
			for($i=0;$i<count($dataM);$i++){
				$dataM[$i]["Stars"] = round($dataM[$i]["Stars"]);
				$dataM[$i]["Stars2"] = 5 - (int)$dataM[$i]["Stars"];
				$dataM[$i]["StarsIcon"] = "";
				for($j=0;$j<$dataM[$i]["Stars"];$j++){
					$dataM[$i]["StarsIcon"] .= "<i class='fa fa-star light'></i>";
				}
				for($k=0;$k<$dataM[$i]["Stars2"];$k++){
					$dataM[$i]["StarsIcon"] .= "<i class='fa fa-star'></i>";
				}
				$dataM[$i]["CreatedTime"] = date("Y-m-d",strtotime($dataM[$i]["CreatedTime"]));
				
				$dataM[$i]["Image"] = (trim($dataM[$i]["Image"]) != "" && file_exists(".".$dataM[$i]["Image"])) ?"<p class=\"img\"><a class=\"photo fancybox\" href=\"".$dataM[$i]["Image"]."\" style=\"background-image: url(".$dataM[$i]["Image"].")\"><img src=\"/images/32/main/img-gamesPhoto.png\" /></a></p>":"";
			}
			$listM = new repeater();
			$listM->id = "listM";
			$listM->dataSource = $dataM;
			parent::addControl($listM);
			
			//
			parent::addParameter("CustomerName",$_SESSION["CustomerName"]);

			//父類方法
			parent::loadData();
		}
	}

	$page = new _productdetail();
	$page->load();
	$page->render();
?>