<?php
	date_default_timezone_set("Asia/Taipei");
	session_start();
	require_once "registry.php";
	require_once "bin/web/page.php";
	require_once "bin/web/repeater.php";
	require_once "dal/htaccessDAL.php";
	require_once "dal/pictureDAL.php";
	require_once "webParts/webPartsFactory.php";

	class pageBase extends page{
		public $htLink1,$htLink2,$htLink3,$htLink4,$htLink5,$htLink6,$htLink7;
		public $registry;
		public $is_index;
		public $picturetype;
		public $NoPicImage;
		public $pwk;

		public function pageBase(){
			//網頁網址設定
			$dalHT = new htaccessDAL();
			$dalHT->ID = "1";
			$dalHT->loadRecord();
			$this->htLink1 = $dalHT->HtmlName;
			$dalHT->ID = "2";
			$dalHT->loadRecord();
			$this->htLink2 = $dalHT->HtmlName;
			$dalHT->ID = "3";
			$dalHT->loadRecord();
			$this->htLink3 = $dalHT->HtmlName;
			$dalHT->ID = "4";
			$dalHT->loadRecord();
			$this->htLink4 = $dalHT->HtmlName;
			$dalHT->ID = "5";
			$dalHT->loadRecord();
			$this->htLink5 = $dalHT->HtmlName;
			$dalHT->ID = "6";
			$dalHT->loadRecord();
			$this->htLink6 = $dalHT->HtmlName;
			$dalHT->ID = "7";
			$dalHT->loadRecord();
			$this->htLink7 = $dalHT->HtmlName;
			
			//NoPicImage
			$dalP = new pictureDAL();
			$dalP->PictureType = "15";
			$dalP->TypeOrderNO = "0";
			$dalP->loadRecord();
			if(trim($dalP->Image) == ''){
				$this->NoPicImage = "images/no-pic.jpg";
			}else{
				if(file_exists(".".$dalP->Image)){
					$this->NoPicImage = $dalP->Image;
				}else{
					$this->NoPicImage = "images/no-pic.jpg";
				}
			}

			$this->registry = registry::createInstance();
			parent::__construct();
		}

		public function loadData(){
			if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on") {
                $protocol = 'https';
            }else{
                header("Location: https://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);   
            }
			//網路資源設置
			////Google Analytics 原始碼
			parent::addParameter("headHTML",$this->registry->headHTML);
			parent::addParameter("bodyTopHTML",$this->registry->bodyTopHTML);
			//網站設定
			////網站標題
			parent::addParameter("webTitle",$this->registry->webTitle);
			////網站關鍵字
			parent::addParameter("webKeyword",$this->registry->webKeyword);
			////網站描述
			parent::addParameter("webDescription",$this->registry->webDescription);
			////網站H1
			parent::addParameter("webH1",$this->registry->webH1);
			////網站名稱
			parent::addParameter("webName",$this->registry->webName);
			////網站版型
			parent::addParameter("webTemplates",$this->registry->webTemplates);
			////彈跳視窗
			parent::addParameter("webPopUpBox",$this->registry->webPopUpBox);
			$showpopup = ($this->registry->webPopUpBox != "") ?1:0;
			parent::addParameter("showpopup",$showpopup);
			
			parent::addParameter("webPhone",$this->registry->webPhone);
			parent::addParameter("webEmail",$this->registry->webEmail);
			parent::addParameter("webMobile",$this->registry->webMobile);
			
			parent::addParameter("lineTitle",$this->registry->lineTitle);
			if(trim($this->registry->lineQRCode) == "" || !file_exists(".".$this->registry->lineQRCode)){
				parent::addParameter("QRstyle","display:none;");
				parent::addParameter("lineQRCode","/images/no-pic.jpg");
			}else{
				parent::addParameter("QRstyle","");
				parent::addParameter("lineQRCode",$this->registry->lineQRCode);
			}
			if(trim($this->registry->googlemapAddress) == ''){
				parent::addParameter("googlemapStyle"," style='display:none;'");
				parent::addParameter("googlemapAddress","");
			}else{
				parent::addParameter("googlemapStyle","");
				parent::addParameter("googlemapAddress",urlencode($this->registry->googlemapAddress));
			}
			if($this->registry->webPhone == ''){
				parent::addParameter("webPhoneStyle"," style='display:none;'");
			}else{
				parent::addParameter("webPhoneStyle","");
			}
			if($this->registry->webMobile == ''){
				parent::addParameter("webMobileStyle"," style='display:none;'");
			}else{
				parent::addParameter("webMobileStyle","");
			}
			if($this->registry->webEmail == ''){
				parent::addParameter("webEmailStyle"," style='display:none;'");
			}else{
				parent::addParameter("webEmailStyle","");
			}
			if($this->registry->webAddress == ''){
				parent::addParameter("webAddressStyle"," style='display:none;'");
			}else{
				parent::addParameter("webAddressStyle","");
			}
			if($this->registry->webFax == ''){
				parent::addParameter("webFaxStyle"," style='display:none;'");
			}else{
				parent::addParameter("webFaxStyle","");
			}
			if($this->registry->lineTitle == ''){
				parent::addParameter("lineTitleStyle"," style='display:none;'");
			}else{
				parent::addParameter("lineTitleStyle","");
			}
			
			//台灣IP檢查
			if($this->registry->TIPClose == '1'){
				$aryTI = array();
				$aryTI[0]["ip"] = "1";
				$aryTI[0]["first"] = array();
				$aryTI[0]["first"][0]["ip"] = "34";
				$aryTI[0]["first"][1]["ip"] = "35";
				for($i=160;$i<201;$i++){
					$aryTI[0]["first"][]["ip"] = "".$i;
				}
				$aryTI[1]["ip"] = "27";
				$aryTI[1]["first"] = array();
				$aryTI[1]["first"][0]["ip"] = "0";
				$aryTI[1]["first"][0]["second"] = array();
				for($i=152;$i<156;$i++){
					$aryTI[1]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				for($i=51;$i<54;$i++){
					$aryTI[1]["first"][]["ip"] = "".$i;
				}
				$aryTI[1]["first"][4]["ip"] = "96";
				$aryTI[1]["first"][4]["second"] = array();
				for($i=224;$i<256;$i++){
					$aryTI[1]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				$aryTI[1]["first"][5]["ip"] = "100";
				$aryTI[1]["first"][5]["second"] = array();
				for($i=64;$i<128;$i++){
					$aryTI[1]["fisrt"][5]["second"][]["ip"] = "".$i;
				}
				$aryTI[1]["first"][6]["ip"] = "105";
				$aryTI[1]["first"][7]["ip"] = "147";
				$aryTI[1]["first"][7]["second"] = array();
				for($i=0;$i<64;$i++){
					$aryTI[1]["fisrt"][7]["second"][]["ip"] = "".$i;
				}
				for($i=240;$i<248;$i++){
					$aryTI[1]["first"][]["ip"] = "".$i;
				}
				$aryTI[2]["ip"] = "36";
				$aryTI[2]["first"] = array();
				for($i=224;$i<240;$i++){
					$aryTI[2]["first"][]["ip"] = "".$i;
				}
				$aryTI[3]["ip"] = "39";
				$aryTI[3]["first"] = array();
				$aryTI[3]["first"][0]["ip"] = "1";
				for($i=8;$i<16;$i++){
					$aryTI[3]["first"][]["ip"] = "".$i;
				}
				$aryTI[4]["ip"] = "42";
				$aryTI[4]["first"] = array();
				$aryTI[4]["first"][0]["ip"] = "0";
				$aryTI[4]["first"][0]["second"] = array();
				for($i=64;$i<128;$i++){
					$aryTI[4]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				for($i=64;$i<80;$i++){
					$aryTI[4]["first"][]["ip"] = "".$i;
				}
				$aryTI[5]["ip"] = "43";
				$aryTI[5]["first"] = array();
				$aryTI[5]["first"][0]["ip"] = "224";
				$aryTI[5]["first"][0]["second"] = array();
				for($i=20;$i<24;$i++){
					$aryTI[5]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[5]["first"][1]["ip"] = "227";
				$aryTI[5]["first"][1]["second"] = array();
				for($i=24;$i<28;$i++){
					$aryTI[5]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[5]["first"][2]["ip"] = "240";
				$aryTI[5]["first"][2]["second"] = array();
				for($i=24;$i<28;$i++){
					$aryTI[5]["fisrt"][2]["second"][]["ip"] = "".$i;
				}
				for($i=44;$i<48;$i++){
					$aryTI[5]["fisrt"][2]["second"][]["ip"] = "".$i;
				}
				for($i=104;$i<112;$i++){
					$aryTI[5]["fisrt"][2]["second"][]["ip"] = "".$i;
				}
				$aryTI[5]["first"][3]["ip"] = "241";
				$aryTI[5]["first"][3]["second"] = array();
				for($i=32;$i<36;$i++){
					$aryTI[5]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[5]["first"][4]["ip"] = "246";
				$aryTI[5]["first"][4]["second"] = array();
				for($i=188;$i<192;$i++){
					$aryTI[5]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				$aryTI[5]["first"][5]["ip"] = "248";
				$aryTI[5]["first"][5]["second"] = array();
				for($i=16;$i<20;$i++){
					$aryTI[5]["fisrt"][5]["second"][]["ip"] = "".$i;
				}
				$aryTI[5]["first"][6]["ip"] = "250";
				$aryTI[5]["first"][6]["second"] = array();
				for($i=44;$i<48;$i++){
					$aryTI[5]["fisrt"][6]["second"][]["ip"] = "".$i;
				}
				$aryTI[5]["first"][7]["ip"] = "251";
				$aryTI[5]["first"][7]["second"] = array();
				for($i=56;$i<64;$i++){
					$aryTI[5]["fisrt"][7]["second"][]["ip"] = "".$i;
				}
				$aryTI[5]["first"][8]["ip"] = "254";
				$aryTI[5]["first"][8]["second"] = array();
				for($i=16;$i<20;$i++){
					$aryTI[5]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				$aryTI[5]["first"][9]["ip"] = "255";
				$aryTI[5]["first"][9]["second"] = array();
				for($i=12;$i<16;$i++){
					$aryTI[5]["fisrt"][9]["second"][]["ip"] = "".$i;
				}
				for($i=88;$i<96;$i++){
					$aryTI[5]["fisrt"][9]["second"][]["ip"] = "".$i;
				}
				for($i=180;$i<184;$i++){
					$aryTI[5]["fisrt"][9]["second"][]["ip"] = "".$i;
				}
				$aryTI[6]["ip"] = "45";
				$aryTI[6]["first"] = array();
				$aryTI[6]["first"][0]["ip"] = "64";
				$aryTI[6]["first"][0]["second"] = array();
				for($i=28;$i<35;$i++){
					$aryTI[6]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				for($i=228;$i<236;$i++){
					$aryTI[6]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[6]["first"][1]["ip"] = "113";
				$aryTI[6]["first"][1]["second"] = array();
				for($i=156;$i<160;$i++){
					$aryTI[6]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[7]["ip"] = "49";
				$aryTI[7]["first"] = array();
				$aryTI[7]["first"][0]["ip"] = "128";
				$aryTI[7]["first"][0]["second"] = array();
				for($i=112;$i<128;$i++){
					$aryTI[7]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[7]["first"][1]["ip"] = "158";
				$aryTI[7]["first"][2]["ip"] = "159";
				$aryTI[7]["first"][3]["ip"] = "213";
				$aryTI[7]["first"][3]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[7]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				for($i=214;$i<220;$i++){
					$aryTI[7]["first"][]["ip"] = "".$i;
				}
				$aryTI[8]["ip"] = "58";
				$aryTI[8]["first"] = array();
				$aryTI[8]["first"][0]["ip"] = "86";
				$aryTI[8]["first"][1]["ip"] = "99";
				$aryTI[8]["first"][1]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[8]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[9]["ip"] = "59";
				$aryTI[9]["first"] = array();
				$aryTI[9]["first"][0]["ip"] = "102";
				$aryTI[9]["first"][0]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[9]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[9]["first"][1]["ip"] = "104";
				$aryTI[9]["first"][2]["ip"] = "105";
				for($i=112;$i<128;$i++){
					$aryTI[9]["first"][]["ip"] = "".$i;
				}
				$aryTI[10]["ip"] = "60";
				$aryTI[10]["first"] = array();
				$aryTI[10]["first"][0]["ip"] = "198";
				$aryTI[10]["first"][1]["ip"] = "199";
				$aryTI[10]["first"][2]["ip"] = "244";
				$aryTI[10]["first"][3]["ip"] = "245";
				$aryTI[10]["first"][3]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[10]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				for($i=248;$i<252;$i++){
					$aryTI[10]["first"][]["ip"] = "".$i;
				}
				$aryTI[11]["ip"] = "61";
				$aryTI[11]["first"] = array();
				$aryTI[11]["first"][0]["ip"] = "20";
				$aryTI[11]["first"][1]["ip"] = "30";
				$aryTI[11]["first"][2]["ip"] = "31";
				$aryTI[11]["first"][3]["ip"] = "56";
				$aryTI[11]["first"][3]["second"] = array();
				for($i=0;$i<32;$i++){
					$aryTI[11]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				for($i=64;$i<112;$i++){
					$aryTI[11]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				for($i=128;$i<256;$i++){
					$aryTI[11]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[11]["first"][4]["ip"] = "57";
				$aryTI[11]["first"][4]["second"] = array();
				for($i=0;$i<192;$i++){
					$aryTI[11]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				for($i=208;$i<256;$i++){
					$aryTI[11]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				$aryTI[11]["first"][5]["ip"] = "58";
				$aryTI[11]["first"][5]["second"] = array();
				for($i=16;$i<256;$i++){
					$aryTI[11]["fisrt"][5]["second"][]["ip"] = "".$i;
				}
				$aryTI[11]["first"][6]["ip"] = "59";
				$aryTI[11]["first"][7]["ip"] = "60";
				$aryTI[11]["first"][8]["ip"] = "61";
				$aryTI[11]["first"][8]["second"] = array();
				for($i=0;$i<192;$i++){
					$aryTI[11]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				for($i=208;$i<256;$i++){
					$aryTI[11]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				$aryTI[11]["first"][9]["ip"] = "62";
				$aryTI[11]["first"][10]["ip"] = "63";
				$aryTI[11]["first"][11]["ip"] = "64";
				$aryTI[11]["first"][11]["second"] = array();
				for($i=0;$i<32;$i++){
					$aryTI[11]["fisrt"][11]["second"][]["ip"] = "".$i;
				}
				for($i=48;$i<256;$i++){
					$aryTI[11]["fisrt"][11]["second"][]["ip"] = "".$i;
				}
				$aryTI[11]["first"][12]["ip"] = "65";
				$aryTI[11]["first"][13]["ip"] = "66";
				$aryTI[11]["first"][14]["ip"] = "67";
				$aryTI[11]["first"][14]["second"] = array();
				for($i=0;$i<96;$i++){
					$aryTI[11]["fisrt"][14]["second"][]["ip"] = "".$i;
				}
				for($i=112;$i<256;$i++){
					$aryTI[11]["fisrt"][14]["second"][]["ip"] = "".$i;
				}
				$aryTI[11]["first"][15]["ip"] = "216";
				$aryTI[11]["first"][16]["ip"] = "217";
				$aryTI[11]["first"][17]["ip"] = "218";
				$aryTI[11]["first"][18]["ip"] = "219";
				$aryTI[11]["first"][19]["ip"] = "220";
				$aryTI[11]["first"][20]["ip"] = "221";
				$aryTI[11]["first"][21]["ip"] = "222";
				$aryTI[11]["first"][22]["ip"] = "223";
				$aryTI[11]["first"][23]["ip"] = "224";
				$aryTI[11]["first"][24]["ip"] = "225";
				$aryTI[11]["first"][25]["ip"] = "226";
				$aryTI[11]["first"][26]["ip"] = "227";
				$aryTI[11]["first"][27]["ip"] = "228";
				$aryTI[11]["first"][28]["ip"] = "229";
				$aryTI[11]["first"][29]["ip"] = "230";
				$aryTI[11]["first"][30]["ip"] = "231";
				$aryTI[11]["first"][31]["ip"] = "247";
				$aryTI[11]["first"][31]["second"] = array();
				for($i=160;$i<176;$i++){
					$aryTI[11]["fisrt"][31]["second"][]["ip"] = "".$i;
				}
				$aryTI[12]["ip"] = "101";
				$aryTI[12]["first"] = array();
				$aryTI[12]["first"][0]["ip"] = "0";
				$aryTI[12]["first"][0]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[12]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[12]["first"][1]["ip"] = "3";
				for($i=8;$i<16;$i++){
					$aryTI[12]["first"][]["ip"] = "".$i;
				}
				for($i=136;$i<140;$i++){
					$aryTI[12]["first"][]["ip"] = "".$i;
				}
				$aryTI[13]["ip"] = "103";
				$aryTI[13]["first"] = array();
				$aryTI[13]["first"][0]["ip"] = "2";
				$aryTI[13]["first"][0]["second"] = array();
				for($i=216;$i<220;$i++){
					$aryTI[13]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][1]["ip"] = "5";
				$aryTI[13]["first"][1]["second"] = array();
				for($i=32;$i<36;$i++){
					$aryTI[13]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][2]["ip"] = "8";
				$aryTI[13]["first"][2]["second"] = array();
				for($i=104;$i<108;$i++){
					$aryTI[13]["fisrt"][2]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][3]["ip"] = "10";
				$aryTI[13]["first"][3]["second"] = array();
				for($i=4;$i<8;$i++){
					$aryTI[13]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][4]["ip"] = "16";
				$aryTI[13]["first"][4]["second"] = array();
				for($i=240;$i<248;$i++){
					$aryTI[13]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][5]["ip"] = "17";
				$aryTI[13]["first"][5]["second"] = array();
				for($i=8;$i<12;$i++){
					$aryTI[13]["fisrt"][5]["second"][]["ip"] = "".$i;
				}
				for($i=240;$i<244;$i++){
					$aryTI[13]["fisrt"][5]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][6]["ip"] = "18";
				$aryTI[13]["first"][6]["second"] = array();
				for($i=128;$i<132;$i++){
					$aryTI[13]["fisrt"][6]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][7]["ip"] = "20";
				$aryTI[13]["first"][7]["second"] = array();
				for($i=40;$i<44;$i++){
					$aryTI[13]["fisrt"][7]["second"][]["ip"] = "".$i;
				}
				for($i=176;$i<180;$i++){
					$aryTI[13]["fisrt"][7]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][8]["ip"] = "21";
				$aryTI[13]["first"][8]["second"] = array();
				for($i=60;$i<64;$i++){
					$aryTI[13]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				for($i=196;$i<200;$i++){
					$aryTI[13]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][9]["ip"] = "23";
				$aryTI[13]["first"][9]["second"] = array();
				for($i=108;$i<112;$i++){
					$aryTI[13]["fisrt"][9]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][10]["ip"] = "24";
				$aryTI[13]["first"][10]["second"] = array();
				for($i=100;$i<103;$i++){
					$aryTI[13]["fisrt"][10]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][11]["ip"] = "25";
				$aryTI[13]["first"][11]["second"] = array();
				for($i=232;$i<239;$i++){
					$aryTI[13]["fisrt"][11]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][12]["ip"] = "30";
				$aryTI[13]["first"][12]["second"] = array();
				for($i=44;$i<48;$i++){
					$aryTI[13]["fisrt"][12]["second"][]["ip"] = "".$i;
				}
				for($i=128;$i<136;$i++){
					$aryTI[13]["fisrt"][12]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][13]["ip"] = "31";
				$aryTI[13]["first"][13]["second"] = array();
				for($i=196;$i<200;$i++){
					$aryTI[13]["fisrt"][13]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][14]["ip"] = "36";
				$aryTI[13]["first"][14]["second"] = array();
				for($i=116;$i<120;$i++){
					$aryTI[13]["fisrt"][14]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][15]["ip"] = "37";
				$aryTI[13]["first"][15]["second"] = array();
				for($i=36;$i<40;$i++){
					$aryTI[13]["fisrt"][15]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][16]["ip"] = "42";
				$aryTI[13]["first"][16]["second"] = array();
				for($i=144;$i<152;$i++){
					$aryTI[13]["fisrt"][16]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][17]["ip"] = "43";
				$aryTI[13]["first"][17]["second"] = array();
				for($i=48;$i<52;$i++){
					$aryTI[13]["fisrt"][17]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][18]["ip"] = "46";
				$aryTI[13]["first"][18]["second"] = array();
				for($i=188;$i<192;$i++){
					$aryTI[13]["fisrt"][18]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][19]["ip"] = "59";
				$aryTI[13]["first"][19]["second"] = array();
				for($i=220;$i<224;$i++){
					$aryTI[13]["fisrt"][19]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][20]["ip"] = "196";
				$aryTI[13]["first"][20]["second"] = array();
				for($i=172;$i<176;$i++){
					$aryTI[13]["fisrt"][20]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][21]["ip"] = "197";
				$aryTI[13]["first"][21]["second"] = array();
				for($i=172;$i<176;$i++){
					$aryTI[13]["fisrt"][21]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][22]["ip"] = "200";
				$aryTI[13]["first"][22]["second"] = array();
				for($i=0;$i<4;$i++){
					$aryTI[13]["fisrt"][22]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][23]["ip"] = "207";
				$aryTI[13]["first"][23]["second"] = array();
				for($i=252;$i<256;$i++){
					$aryTI[13]["fisrt"][23]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][24]["ip"] = "224";
				$aryTI[13]["first"][24]["second"] = array();
				for($i=132;$i<136;$i++){
					$aryTI[13]["fisrt"][24]["second"][]["ip"] = "".$i;
				}
				for($i=192;$i<196;$i++){
					$aryTI[13]["fisrt"][24]["second"][]["ip"] = "".$i;
				}
				for($i=200;$i<208;$i++){
					$aryTI[13]["fisrt"][24]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][25]["ip"] = "225";
				$aryTI[13]["first"][25]["second"] = array();
				for($i=0;$i<4;$i++){
					$aryTI[13]["fisrt"][25]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][26]["ip"] = "227";
				$aryTI[13]["first"][26]["second"] = array();
				for($i=32;$i<36;$i++){
					$aryTI[13]["fisrt"][26]["second"][]["ip"] = "".$i;
				}
				for($i=224;$i<228;$i++){
					$aryTI[13]["fisrt"][26]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][27]["ip"] = "228";
				$aryTI[13]["first"][27]["second"] = array();
				for($i=216;$i<220;$i++){
					$aryTI[13]["fisrt"][27]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][28]["ip"] = "229";
				$aryTI[13]["first"][28]["second"] = array();
				for($i=100;$i<104;$i++){
					$aryTI[13]["fisrt"][28]["second"][]["ip"] = "".$i;
				}
				for($i=132;$i<136;$i++){
					$aryTI[13]["fisrt"][28]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][29]["ip"] = "231";
				$aryTI[13]["first"][29]["second"] = array();
				for($i=48;$i<52;$i++){
					$aryTI[13]["fisrt"][29]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][30]["ip"] = "233";
				$aryTI[13]["first"][30]["second"] = array();
				for($i=68;$i<72;$i++){
					$aryTI[13]["fisrt"][30]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][31]["ip"] = "234";
				$aryTI[13]["first"][31]["second"] = array();
				for($i=40;$i<44;$i++){
					$aryTI[13]["fisrt"][31]["second"][]["ip"] = "".$i;
				}
				for($i=76;$i<84;$i++){
					$aryTI[13]["fisrt"][31]["second"][]["ip"] = "".$i;
				}
				for($i=224;$i<232;$i++){
					$aryTI[13]["fisrt"][31]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][32]["ip"] = "235";
				$aryTI[13]["first"][32]["second"] = array();
				for($i=88;$i<92;$i++){
					$aryTI[13]["fisrt"][32]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][33]["ip"] = "239";
				$aryTI[13]["first"][33]["second"] = array();
				for($i=60;$i<64;$i++){
					$aryTI[13]["fisrt"][33]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][34]["ip"] = "241";
				$aryTI[13]["first"][34]["second"] = array();
				for($i=68;$i<72;$i++){
					$aryTI[13]["fisrt"][34]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][35]["ip"] = "243";
				$aryTI[13]["first"][35]["second"] = array();
				for($i=248;$i<252;$i++){
					$aryTI[13]["fisrt"][35]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][36]["ip"] = "247";
				$aryTI[13]["first"][36]["second"] = array();
				for($i=112;$i<116;$i++){
					$aryTI[13]["fisrt"][36]["second"][]["ip"] = "".$i;
				}
				$aryTI[13]["first"][37]["ip"] = "252";
				$aryTI[13]["first"][37]["second"] = array();
				for($i=68;$i<72;$i++){
					$aryTI[13]["fisrt"][37]["second"][]["ip"] = "".$i;
				}
				for($i=128;$i<132;$i++){
					$aryTI[13]["fisrt"][37]["second"][]["ip"] = "".$i;
				}
				for($i=196;$i<200;$i++){
					$aryTI[13]["fisrt"][37]["second"][]["ip"] = "".$i;
				}
				$aryTI[14]["ip"] = "106";
				$aryTI[14]["first"] = array();
				$aryTI[14]["first"][0]["ip"] = "1";
				$aryTI[14]["first"][1]["ip"] = "64";
				$aryTI[14]["first"][2]["ip"] = "65";
				for($i=104;$i<108;$i++){
					$aryTI[14]["first"][]["ip"] = "".$i;
				}
				$aryTI[15]["ip"] = "110";
				$aryTI[15]["first"] = array();
				$aryTI[15]["first"][0]["ip"] = "24";
				$aryTI[15]["first"][1]["ip"] = "25";
				$aryTI[15]["first"][2]["ip"] = "26";
				$aryTI[15]["first"][3]["ip"] = "27";
				$aryTI[15]["first"][4]["ip"] = "28";
				$aryTI[15]["first"][5]["ip"] = "29";
				$aryTI[15]["first"][6]["ip"] = "30";
				$aryTI[15]["first"][7]["ip"] = "31";
				$aryTI[15]["first"][8]["ip"] = "50";
				$aryTI[15]["first"][8]["second"] = array();
				for($i=128;$i<192;$i++){
					$aryTI[15]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				$aryTI[16]["ip"] = "111";
				$aryTI[16]["first"] = array();
				$aryTI[16]["first"][0]["ip"] = "67";
				$aryTI[16]["first"][0]["second"] = array();
				for($i=48;$i<64;$i++){
					$aryTI[16]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[16]["first"][1]["ip"] = "70";
				$aryTI[16]["first"][2]["ip"] = "71";
				$aryTI[16]["first"][3]["ip"] = "80";
				$aryTI[16]["first"][4]["ip"] = "81";
				$aryTI[16]["first"][5]["ip"] = "82";
				$aryTI[16]["first"][6]["ip"] = "83";
				$aryTI[16]["first"][7]["ip"] = "125";
				$aryTI[16]["first"][7]["second"] = array();
				for($i=128;$i<136;$i++){
					$aryTI[16]["fisrt"][7]["second"][]["ip"] = "".$i;
				}
				$aryTI[16]["first"][8]["ip"] = "235";
				$aryTI[16]["first"][8]["second"] = array();
				for($i=192;$i<256;$i++){
					$aryTI[16]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				for($i=240;$i<256;$i++){
					$aryTI[16]["first"][]["ip"] = "".$i;
				}
				$aryTI[17]["ip"] = "112";
				$aryTI[17]["first"] = array();
				$aryTI[17]["first"][0]["ip"] = "78";
				$aryTI[17]["first"][0]["second"] = array();
				for($i=64;$i<96;$i++){
					$aryTI[17]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[17]["first"][1]["ip"] = "104";
				$aryTI[17]["first"][2]["ip"] = "105";
				$aryTI[17]["first"][3]["ip"] = "213";
				$aryTI[17]["first"][3]["second"] = array();
				for($i=48;$i<64;$i++){
					$aryTI[17]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[18]["ip"] = "113";
				$aryTI[18]["first"] = array();
				$aryTI[18]["first"][0]["ip"] = "21";
				$aryTI[18]["first"][0]["second"] = array();
				for($i=80;$i<96;$i++){
					$aryTI[18]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				for($i=160;$i<192;$i++){
					$aryTI[18]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[18]["first"][1]["ip"] = "61";
				$aryTI[18]["first"][1]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[18]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[18]["first"][2]["ip"] = "196";
				$aryTI[19]["ip"] = "114";
				$aryTI[19]["first"] = array();
				$aryTI[19]["first"][0]["ip"] = "24";
				$aryTI[19]["first"][1]["ip"] = "25";
				$aryTI[19]["first"][2]["ip"] = "26";
				$aryTI[19]["first"][3]["ip"] = "27";
				$aryTI[19]["first"][4]["ip"] = "29";
				$aryTI[19]["first"][4]["second"] = array();
				for($i=240;$i<248;$i++){
					$aryTI[19]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				$aryTI[19]["first"][5]["ip"] = "30";
				$aryTI[19]["first"][5]["second"] = array();
				for($i=32;$i<48;$i++){
					$aryTI[19]["fisrt"][5]["second"][]["ip"] = "".$i;
				}
				$aryTI[19]["first"][6]["ip"] = "32";
				$aryTI[19]["first"][7]["ip"] = "33";
				$aryTI[19]["first"][8]["ip"] = "34";
				$aryTI[19]["first"][9]["ip"] = "35";
				$aryTI[19]["first"][10]["ip"] = "36";
				$aryTI[19]["first"][11]["ip"] = "37";
				$aryTI[19]["first"][12]["ip"] = "38";
				$aryTI[19]["first"][13]["ip"] = "39";
				$aryTI[19]["first"][14]["ip"] = "40";
				$aryTI[19]["first"][15]["ip"] = "41";
				$aryTI[19]["first"][16]["ip"] = "42";
				$aryTI[19]["first"][17]["ip"] = "43";
				$aryTI[19]["first"][18]["ip"] = "44";
				$aryTI[19]["first"][19]["ip"] = "45";
				$aryTI[19]["first"][20]["ip"] = "46";
				$aryTI[19]["first"][21]["ip"] = "47";
				$aryTI[19]["first"][22]["ip"] = "136";
				$aryTI[19]["first"][23]["ip"] = "137";
				$aryTI[19]["first"][24]["ip"] = "140";
				$aryTI[19]["first"][25]["ip"] = "198";
				$aryTI[19]["first"][25]["second"] = array();
				for($i=160;$i<192;$i++){
					$aryTI[19]["fisrt"][25]["second"][]["ip"] = "".$i;
				}
				$aryTI[20]["ip"] = "115";
				$aryTI[20]["first"] = array();
				$aryTI[20]["first"][0]["ip"] = "30";
				$aryTI[20]["first"][0]["second"] = array();
				for($i=64;$i<128;$i++){
					$aryTI[20]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[20]["first"][1]["ip"] = "42";
				$aryTI[20]["first"][1]["second"] = array();
				for($i=80;$i<96;$i++){
					$aryTI[20]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				for($i=112;$i<120;$i++){
					$aryTI[20]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[20]["first"][2]["ip"] = "43";
				$aryTI[20]["first"][3]["ip"] = "80";
				$aryTI[20]["first"][4]["ip"] = "81";
				$aryTI[20]["first"][5]["ip"] = "82";
				$aryTI[20]["first"][6]["ip"] = "83";
				$aryTI[20]["first"][7]["ip"] = "85";
				$aryTI[20]["first"][7]["second"] = array();
				for($i=144;$i<160;$i++){
					$aryTI[20]["fisrt"][7]["second"][]["ip"] = "".$i;
				}
				$aryTI[20]["first"][8]["ip"] = "165";
				$aryTI[20]["first"][8]["second"] = array();
				for($i=192;$i<256;$i++){
					$aryTI[20]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				$aryTI[21]["ip"] = "116";
				$aryTI[21]["first"] = array();
				$aryTI[21]["first"][0]["ip"] = "50";
				$aryTI[21]["first"][0]["second"] = array();
				for($i=32;$i<48;$i++){
					$aryTI[21]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[21]["first"][1]["ip"] = "59";
				$aryTI[21]["first"][2]["ip"] = "89";
				$aryTI[21]["first"][2]["second"] = array();
				for($i=128;$i<144;$i++){
					$aryTI[21]["fisrt"][2]["second"][]["ip"] = "".$i;
				}
				$aryTI[21]["first"][3]["ip"] = "118";
				$aryTI[21]["first"][3]["second"] = array();
				for($i=128;$i<192;$i++){
					$aryTI[21]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[21]["first"][4]["ip"] = "212";
				$aryTI[21]["first"][4]["second"] = array();
				for($i=80;$i<96;$i++){
					$aryTI[21]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				$aryTI[21]["first"][5]["ip"] = "241";
				$aryTI[22]["ip"] = "117";
				$aryTI[22]["first"] = array();
				$aryTI[22]["first"][0]["ip"] = "19";
				$aryTI[22]["first"][1]["ip"] = "56";
				$aryTI[22]["first"][2]["ip"] = "103";
				$aryTI[22]["first"][2]["second"] = array();
				for($i=96;$i<112;$i++){
					$aryTI[22]["fisrt"][2]["second"][]["ip"] = "".$i;
				}
				$aryTI[23]["ip"] = "118";
				$aryTI[23]["first"] = array();
				$aryTI[23]["first"][0]["ip"] = "99";
				$aryTI[23]["first"][0]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[23]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[23]["first"][1]["ip"] = "150";
				for($i=160;$i<172;$i++){
					$aryTI[23]["first"][]["ip"] = "".$i;
				}
				for($i=231;$i<234;$i++){
					$aryTI[23]["first"][]["ip"] = "".$i;
				}
				$aryTI[24]["ip"] = "119";
				$aryTI[24]["first"] = array();
				$aryTI[24]["first"][0]["ip"] = "14";
				$aryTI[24]["first"][1]["ip"] = "15";
				$aryTI[24]["first"][1]["second"] = array();
				for($i=192;$i<256;$i++){
					$aryTI[24]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[24]["first"][2]["ip"] = "30";
				$aryTI[24]["first"][2]["second"] = array();
				for($i=16;$i<32;$i++){
					$aryTI[24]["fisrt"][2]["second"][]["ip"] = "".$i;
				}
				$aryTI[24]["first"][3]["ip"] = "31";
				$aryTI[24]["first"][3]["second"] = array();
				for($i=176;$i<192;$i++){
					$aryTI[24]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[24]["first"][4]["ip"] = "77";
				$aryTI[24]["first"][4]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[24]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				$aryTI[25]["ip"] = "120";
				$aryTI[25]["first"] = array();
				for($i=96;$i<128;$i++){
					$aryTI[25]["first"][]["ip"] = "".$i;
				}
				$aryTI[26]["ip"] = "121";
				$aryTI[26]["first"] = array();
				$aryTI[26]["first"][0]["ip"] = "50";
				$aryTI[26]["first"][0]["second"] = array();
				for($i=144;$i<152;$i++){
					$aryTI[26]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				for($i=176;$i<192;$i++){
					$aryTI[26]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[27]["ip"] = "122";
				$aryTI[27]["first"] = array();
				$aryTI[27]["first"][0]["ip"] = "99";
				$aryTI[27]["first"][0]["second"] = array();
				for($i=0;$i<64;$i++){
					$aryTI[27]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[27]["first"][1]["ip"] = "100";
				$aryTI[27]["first"][1]["second"] = array();
				for($i=64;$i<128;$i++){
					$aryTI[27]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[27]["first"][2]["ip"] = "116";
				$aryTI[27]["first"][3]["ip"] = "117";
				$aryTI[27]["first"][4]["ip"] = "118";
				$aryTI[27]["first"][5]["ip"] = "120";
				$aryTI[27]["first"][6]["ip"] = "121";
				$aryTI[27]["first"][7]["ip"] = "122";
				$aryTI[27]["first"][8]["ip"] = "123";
				$aryTI[27]["first"][9]["ip"] = "124";
				$aryTI[27]["first"][10]["ip"] = "125";
				$aryTI[27]["first"][11]["ip"] = "126";
				$aryTI[27]["first"][12]["ip"] = "127";
				$aryTI[27]["first"][13]["ip"] = "146";
				$aryTI[27]["first"][14]["ip"] = "147";
				$aryTI[27]["first"][15]["ip"] = "200";
				$aryTI[27]["first"][15]["second"] = array();
				for($i=152;$i<160;$i++){
					$aryTI[27]["fisrt"][15]["second"][]["ip"] = "".$i;
				}
				$aryTI[27]["first"][16]["ip"] = "201";
				$aryTI[27]["first"][16]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[27]["fisrt"][16]["second"][]["ip"] = "".$i;
				}
				$aryTI[27]["first"][17]["ip"] = "254";
				$aryTI[27]["first"][17]["second"] = array();
				for($i=0;$i<64;$i++){
					$aryTI[27]["fisrt"][17]["second"][]["ip"] = "".$i;
				}
				$aryTI[27]["first"][18]["ip"] = "255";
				$aryTI[27]["first"][18]["second"] = array();
				for($i=80;$i<96;$i++){
					$aryTI[27]["fisrt"][18]["second"][]["ip"] = "".$i;
				}
				$aryTI[28]["ip"] = "123";
				$aryTI[28]["first"] = array();
				$aryTI[28]["first"][0]["ip"] = "0";
				$aryTI[28]["first"][0]["second"] = array();
				for($i=32;$i<64;$i++){
					$aryTI[28]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				for($i=192;$i<256;$i++){
					$aryTI[28]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[28]["first"][1]["ip"] = "50";
				$aryTI[28]["first"][1]["second"] = array();
				for($i=32;$i<64;$i++){
					$aryTI[28]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[28]["first"][2]["ip"] = "51";
				$aryTI[28]["first"][2]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[28]["fisrt"][2]["second"][]["ip"] = "".$i;
				}
				$aryTI[28]["first"][3]["ip"] = "99";
				$aryTI[28]["first"][3]["second"] = array();
				for($i=0;$i<64;$i++){
					$aryTI[28]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[28]["first"][4]["ip"] = "110";
				$aryTI[28]["first"][5]["ip"] = "192";
				$aryTI[28]["first"][6]["ip"] = "193";
				$aryTI[28]["first"][7]["ip"] = "194";
				$aryTI[28]["first"][8]["ip"] = "195";
				$aryTI[28]["first"][9]["ip"] = "204";
				$aryTI[28]["first"][10]["ip"] = "205";
				$aryTI[28]["first"][11]["ip"] = "240";
				$aryTI[28]["first"][12]["ip"] = "241";
				$aryTI[28]["first"][13]["ip"] = "252";
				$aryTI[28]["first"][13]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[28]["fisrt"][13]["second"][]["ip"] = "".$i;
				}
				$aryTI[29]["ip"] = "124";
				$aryTI[29]["first"] = array();
				$aryTI[29]["first"][0]["ip"] = "6";
				$aryTI[29]["first"][0]["second"] = array();
				for($i=0;$i<32;$i++){
					$aryTI[29]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[29]["first"][1]["ip"] = "8";
				$aryTI[29]["first"][2]["ip"] = "9";
				$aryTI[29]["first"][3]["ip"] = "10";
				$aryTI[29]["first"][4]["ip"] = "11";
				$aryTI[29]["first"][5]["ip"] = "12";
				$aryTI[29]["first"][6]["ip"] = "29";
				$aryTI[29]["first"][6]["second"] = array();
				for($i=128;$i<192;$i++){
					$aryTI[29]["fisrt"][6]["second"][]["ip"] = "".$i;
				}
				$aryTI[29]["first"][7]["ip"] = "108";
				$aryTI[29]["first"][7]["second"] = array();
				for($i=128;$i<192;$i++){
					$aryTI[29]["fisrt"][7]["second"][]["ip"] = "".$i;
				}
				$aryTI[29]["first"][8]["ip"] = "109";
				$aryTI[29]["first"][8]["second"] = array();
				for($i=112;$i<128;$i++){
					$aryTI[29]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				$aryTI[29]["first"][9]["ip"] = "150";
				$aryTI[29]["first"][9]["second"] = array();
				for($i=128;$i<136;$i++){
					$aryTI[29]["fisrt"][9]["second"][]["ip"] = "".$i;
				}
				$aryTI[29]["first"][10]["ip"] = "155";
				$aryTI[29]["first"][10]["second"] = array();
				for($i=128;$i<192;$i++){
					$aryTI[29]["fisrt"][10]["second"][]["ip"] = "".$i;
				}
				$aryTI[29]["first"][11]["ip"] = "199";
				$aryTI[29]["first"][11]["second"] = array();
				for($i=64;$i<112;$i++){
					$aryTI[29]["fisrt"][11]["second"][]["ip"] = "".$i;
				}
				$aryTI[29]["first"][12]["ip"] = "218";
				$aryTI[29]["first"][13]["ip"] = "219";
				$aryTI[29]["first"][13]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[29]["fisrt"][13]["second"][]["ip"] = "".$i;
				}
				$aryTI[30]["ip"] = "125";
				$aryTI[30]["first"] = array();
				for($i=224;$i<234;$i++){
					$aryTI[30]["first"][]["ip"] = "".$i;
				}
				$aryTI[31]["ip"] = "139";
				$aryTI[31]["first"] = array();
				$aryTI[31]["first"][0]["ip"] = "175";
				$aryTI[32]["ip"] = "140";
				$aryTI[32]["first"] = array();
				for($i=109;$i<139;$i++){
					$aryTI[32]["first"][]["ip"] = "".$i;
				}
				$aryTI[33]["ip"] = "150";
				$aryTI[33]["first"] = array();
				$aryTI[33]["first"][0]["ip"] = "107";
				$aryTI[33]["first"][0]["second"] = array();
				for($i=56;$i<68;$i++){
					$aryTI[33]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[33]["first"][1]["ip"] = "116";
				$aryTI[33]["first"][2]["ip"] = "117";
				$aryTI[33]["first"][3]["ip"] = "129";
				$aryTI[33]["first"][3]["second"] = array();
				for($i=36;$i<40;$i++){
					$aryTI[33]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				for($i=72;$i<76;$i++){
					$aryTI[33]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				for($i=96;$i<100;$i++){
					$aryTI[33]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[33]["first"][4]["ip"] = "242";
				$aryTI[33]["first"][4]["second"] = array();
				for($i=100;$i<104;$i++){
					$aryTI[33]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				$aryTI[34]["ip"] = "163";
				$aryTI[34]["first"] = array();
				for($i=13;$i<33;$i++){
					$aryTI[34]["first"][]["ip"] = "".$i;
				}
				$aryTI[35]["ip"] = "168";
				$aryTI[35]["first"] = array();
				$aryTI[35]["first"][0]["ip"] = "95";
				$aryTI[36]["ip"] = "175";
				$aryTI[36]["first"] = array();
				$aryTI[36]["first"][0]["ip"] = "41";
				$aryTI[36]["first"][0]["second"] = array();
				for($i=48;$i<64;$i++){
					$aryTI[36]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[36]["first"][1]["ip"] = "96";
				$aryTI[36]["first"][2]["ip"] = "97";
				$aryTI[36]["first"][3]["ip"] = "98";
				$aryTI[36]["first"][4]["ip"] = "99";
				$aryTI[36]["first"][5]["ip"] = "111";
				$aryTI[36]["first"][5]["second"] = array();
				for($i=192;$i<256;$i++){
					$aryTI[36]["fisrt"][5]["second"][]["ip"] = "".$i;
				}
				$aryTI[36]["first"][6]["ip"] = "180";
				$aryTI[36]["first"][7]["ip"] = "181";
				$aryTI[36]["first"][8]["ip"] = "182";
				$aryTI[36]["first"][9]["ip"] = "183";
				$aryTI[36]["first"][10]["ip"] = "184";
				$aryTI[36]["first"][10]["second"] = array();
				for($i=240;$i<248;$i++){
					$aryTI[36]["fisrt"][10]["second"][]["ip"] = "".$i;
				}
				$aryTI[37]["ip"] = "180";
				$aryTI[37]["first"] = array();
				$aryTI[37]["first"][0]["ip"] = "92";
				$aryTI[37]["first"][0]["second"] = array();
				for($i=0;$i<16;$i++){
					$aryTI[37]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[37]["first"][1]["ip"] = "176";
				$aryTI[37]["first"][2]["ip"] = "177";
				$aryTI[37]["first"][3]["ip"] = "204";
				$aryTI[37]["first"][4]["ip"] = "205";
				$aryTI[37]["first"][5]["ip"] = "206";
				$aryTI[37]["first"][6]["ip"] = "207";
				$aryTI[37]["first"][7]["ip"] = "214";
				$aryTI[37]["first"][7]["second"] = array();
				for($i=176;$i<192;$i++){
					$aryTI[37]["fisrt"][7]["second"][]["ip"] = "".$i;
				}
				$aryTI[37]["first"][7]["ip"] = "217";
				$aryTI[37]["first"][7]["ip"] = "218";
				$aryTI[38]["ip"] = "182";
				$aryTI[38]["first"] = array();
				$aryTI[38]["first"][0]["ip"] = "155";
				$aryTI[39]["ip"] = "192";
				$aryTI[39]["first"] = array();
				$aryTI[39]["first"][0]["ip"] = "72";
				$aryTI[39]["first"][0]["second"] = array();
				for($i=3;$i<253;$i++){
					$aryTI[39]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[39]["first"][1]["ip"] = "83";
				$aryTI[39]["first"][1]["second"] = array();
				for($i=166;$i<172;$i++){
					$aryTI[39]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				for($i=173;$i<197;$i++){
					$aryTI[39]["fisrt"][1]["second"][]["ip"] = "".$i;
				}
				$aryTI[39]["first"][2]["ip"] = "192";
				$aryTI[40]["ip"] = "202";
				$aryTI[40]["first"] = array();
				$aryTI[40]["first"][0]["ip"] = "5";
				$aryTI[40]["first"][0]["second"] = array();
				$aryTI[40]["fisrt"][0]["second"][0]["ip"] = "4";
				$aryTI[40]["fisrt"][0]["second"][1]["ip"] = "5";
				for($i=8;$i<16;$i++){
					$aryTI[40]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][1]["ip"] = "6";
				$aryTI[40]["first"][1]["second"] = array();
				$aryTI[40]["fisrt"][1]["second"][0]["ip"] = "104";
				$aryTI[40]["fisrt"][1]["second"][1]["ip"] = "105";
				$aryTI[40]["first"][2]["ip"] = "8";
				$aryTI[40]["first"][2]["second"] = array();
				$aryTI[40]["fisrt"][2]["second"][0]["ip"] = "14";
				$aryTI[40]["fisrt"][2]["second"][1]["ip"] = "15";
				$aryTI[40]["first"][3]["ip"] = "39";
				$aryTI[40]["first"][3]["second"] = array();
				for($i=0;$i<112;$i++){
					$aryTI[40]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				for($i=128;$i<256;$i++){
					$aryTI[40]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][4]["ip"] = "123";
				$aryTI[40]["first"][4]["second"] = array();
				for($i=124;$i<128;$i++){
					$aryTI[40]["fisrt"][4]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][5]["ip"] = "132";
				$aryTI[40]["first"][6]["ip"] = "140";
				$aryTI[40]["first"][6]["second"] = array();
				for($i=160;$i<192;$i++){
					$aryTI[40]["fisrt"][6]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][7]["ip"] = "144";
				$aryTI[40]["first"][7]["second"] = array();
				for($i=208;$i<224;$i++){
					$aryTI[40]["fisrt"][7]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][8]["ip"] = "145";
				$aryTI[40]["first"][8]["second"] = array();
				for($i=32;$i<256;$i++){
					$aryTI[40]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][9]["ip"] = "148";
				$aryTI[40]["first"][9]["second"] = array();
				for($i=208;$i<224;$i++){
					$aryTI[40]["fisrt"][9]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][10]["ip"] = "151";
				$aryTI[40]["first"][10]["second"] = array();
				for($i=48;$i<64;$i++){
					$aryTI[40]["fisrt"][10]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][11]["ip"] = "160";
				$aryTI[40]["first"][11]["second"] = array();
				for($i=64;$i<96;$i++){
					$aryTI[40]["fisrt"][11]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][12]["ip"] = "168";
				$aryTI[40]["first"][12]["second"] = array();
				for($i=192;$i<208;$i++){
					$aryTI[40]["fisrt"][12]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][13]["ip"] = "169";
				$aryTI[40]["first"][13]["second"] = array();
				for($i=160;$i<176;$i++){
					$aryTI[40]["fisrt"][13]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][14]["ip"] = "174";
				$aryTI[40]["first"][14]["second"] = array();
				for($i=16;$i<32;$i++){
					$aryTI[40]["fisrt"][14]["second"][]["ip"] = "".$i;
				}
				$aryTI[40]["first"][15]["ip"] = "178";
				$aryTI[40]["first"][15]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[40]["fisrt"][15]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["ip"] = "203";
				$aryTI[41]["first"] = array();
				$aryTI[41]["first"][0]["ip"] = "64";
				$aryTI[41]["first"][1]["ip"] = "65";
				$aryTI[41]["first"][2]["ip"] = "66";
				$aryTI[41]["first"][3]["ip"] = "67";
				$aryTI[41]["first"][4]["ip"] = "68";
				$aryTI[41]["first"][5]["ip"] = "69";
				$aryTI[41]["first"][6]["ip"] = "70";
				$aryTI[41]["first"][7]["ip"] = "71";
				$aryTI[41]["first"][8]["ip"] = "72";
				$aryTI[41]["first"][9]["ip"] = "73";
				$aryTI[41]["first"][10]["ip"] = "74";
				$aryTI[41]["first"][11]["ip"] = "75";
				$aryTI[41]["first"][12]["ip"] = "77";
				$aryTI[41]["first"][12]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[41]["fisrt"][12]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][13]["ip"] = "78";
				$aryTI[41]["first"][13]["second"] = array();
				for($i=176;$i<192;$i++){
					$aryTI[41]["fisrt"][13]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][14]["ip"] = "79";
				$aryTI[41]["first"][14]["second"] = array();
				for($i=128;$i<256;$i++){
					$aryTI[41]["fisrt"][14]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][15]["ip"] = "84";
				$aryTI[41]["first"][15]["second"] = array();
				for($i=144;$i<152;$i++){
					$aryTI[41]["fisrt"][15]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][16]["ip"] = "105";
				$aryTI[41]["first"][16]["second"] = array();
				for($i=224;$i<256;$i++){
					$aryTI[41]["fisrt"][16]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][17]["ip"] = "111";
				$aryTI[41]["first"][17]["second"] = array();
				for($i=208;$i<224;$i++){
					$aryTI[41]["fisrt"][17]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][18]["ip"] = "118";
				$aryTI[41]["first"][18]["second"] = array();
				for($i=224;$i<240;$i++){
					$aryTI[41]["fisrt"][18]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][19]["ip"] = "119";
				$aryTI[41]["first"][19]["second"] = array();
				$aryTI[41]["fisrt"][19]["second"][0]["ip"] = "3";
				$aryTI[41]["fisrt"][19]["second"][1]["ip"] = "94";
				$aryTI[41]["first"][20]["ip"] = "121";
				$aryTI[41]["first"][20]["second"] = array();
				for($i=224;$i<256;$i++){
					$aryTI[41]["fisrt"][20]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][21]["ip"] = "145";
				$aryTI[41]["first"][21]["second"] = array();
				for($i=192;$i<224;$i++){
					$aryTI[41]["fisrt"][21]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][22]["ip"] = "160";
				$aryTI[41]["first"][22]["second"] = array();
				for($i=144;$i<160;$i++){
					$aryTI[41]["fisrt"][22]["second"][]["ip"] = "".$i;
				}
				for($i=224;$i<256;$i++){
					$aryTI[41]["fisrt"][22]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][23]["ip"] = "190";
				$aryTI[41]["first"][23]["second"] = array();
				for($i=16;$i<24;$i++){
					$aryTI[41]["fisrt"][23]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][24]["ip"] = "201";
				$aryTI[41]["first"][24]["second"] = array();
				for($i=32;$i<48;$i++){
					$aryTI[41]["fisrt"][24]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][25]["ip"] = "207";
				$aryTI[41]["first"][25]["second"] = array();
				for($i=32;$i<48;$i++){
					$aryTI[41]["fisrt"][25]["second"][]["ip"] = "".$i;
				}
				$aryTI[41]["first"][26]["ip"] = "211";
				$aryTI[41]["first"][26]["second"] = array();
				for($i=0;$i<32;$i++){
					$aryTI[41]["fisrt"][26]["second"][]["ip"] = "".$i;
				}
				$aryTI[42]["ip"] = "210";
				$aryTI[42]["first"] = array();
				$aryTI[42]["first"][0]["ip"] = "17";
				$aryTI[42]["first"][0]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[42]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[42]["first"][1]["ip"] = "58";
				$aryTI[42]["first"][2]["ip"] = "59";
				$aryTI[42]["first"][3]["ip"] = "60";
				$aryTI[42]["first"][4]["ip"] = "61";
				$aryTI[42]["first"][5]["ip"] = "62";
				$aryTI[42]["first"][5]["second"] = array();
				for($i=0;$i<95;$i++){
					$aryTI[42]["fisrt"][5]["second"][]["ip"] = "".$i;
				}
				for($i=160;$i<256;$i++){
					$aryTI[42]["fisrt"][5]["second"][]["ip"] = "".$i;
				}
				$aryTI[42]["first"][6]["ip"] = "63";
				$aryTI[42]["first"][7]["ip"] = "64";
				$aryTI[42]["first"][8]["ip"] = "65";
				$aryTI[42]["first"][9]["ip"] = "66";
				$aryTI[42]["first"][10]["ip"] = "67";
				$aryTI[42]["first"][10]["second"] = array();
				for($i=0;$i<224;$i++){
					$aryTI[42]["fisrt"][10]["second"][]["ip"] = "".$i;
				}
				for($i=248;$i<256;$i++){
					$aryTI[42]["fisrt"][10]["second"][]["ip"] = "".$i;
				}
				$aryTI[42]["first"][11]["ip"] = "68";
				$aryTI[42]["first"][12]["ip"] = "69";
				$aryTI[42]["first"][13]["ip"] = "70";
				$aryTI[42]["first"][14]["ip"] = "71";
				$aryTI[42]["first"][15]["ip"] = "85";
				$aryTI[42]["first"][16]["ip"] = "192";
				$aryTI[42]["first"][16]["second"] = array();
				for($i=0;$i<64;$i++){
					$aryTI[42]["fisrt"][16]["second"][]["ip"] = "".$i;
				}
				for($i=128;$i<256;$i++){
					$aryTI[42]["fisrt"][16]["second"][]["ip"] = "".$i;
				}
				$aryTI[42]["first"][17]["ip"] = "200";
				$aryTI[42]["first"][18]["ip"] = "201";
				$aryTI[42]["first"][19]["ip"] = "202";
				$aryTI[42]["first"][20]["ip"] = "203";
				$aryTI[42]["first"][20]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[42]["fisrt"][20]["second"][]["ip"] = "".$i;
				}
				$aryTI[42]["first"][21]["ip"] = "208";
				$aryTI[42]["first"][21]["second"] = array();
				for($i=96;$i<128;$i++){
					$aryTI[42]["fisrt"][21]["second"][]["ip"] = "".$i;
				}
				for($i=192;$i<256;$i++){
					$aryTI[42]["fisrt"][21]["second"][]["ip"] = "".$i;
				}
				$aryTI[42]["first"][22]["ip"] = "240";
				$aryTI[42]["first"][23]["ip"] = "241";
				$aryTI[42]["first"][24]["ip"] = "242";
				$aryTI[42]["first"][25]["ip"] = "243";
				$aryTI[42]["first"][26]["ip"] = "244";
				$aryTI[42]["first"][26]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[42]["fisrt"][26]["second"][]["ip"] = "".$i;
				}
				for($i=192;$i<256;$i++){
					$aryTI[42]["fisrt"][26]["second"][]["ip"] = "".$i;
				}
				$aryTI[43]["ip"] = "211";
				$aryTI[43]["first"] = array();
				$aryTI[43]["first"][0]["ip"] = "20";
				$aryTI[43]["first"][1]["ip"] = "21";
				$aryTI[43]["first"][2]["ip"] = "22";
				$aryTI[43]["first"][3]["ip"] = "23";
				$aryTI[43]["first"][4]["ip"] = "72";
				$aryTI[43]["first"][5]["ip"] = "73";
				$aryTI[43]["first"][6]["ip"] = "74";
				$aryTI[43]["first"][7]["ip"] = "75";
				$aryTI[43]["first"][8]["ip"] = "76";
				$aryTI[43]["first"][8]["second"] = array();
				for($i=0;$i<224;$i++){
					$aryTI[43]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				for($i=240;$i<256;$i++){
					$aryTI[43]["fisrt"][8]["second"][]["ip"] = "".$i;
				}
				$aryTI[43]["first"][9]["ip"] = "77";
				$aryTI[43]["first"][10]["ip"] = "78";
				$aryTI[43]["first"][10]["second"] = array();
				for($i=0;$i<192;$i++){
					$aryTI[43]["fisrt"][10]["second"][]["ip"] = "".$i;
				}
				for($i=208;$i<224;$i++){
					$aryTI[43]["fisrt"][10]["second"][]["ip"] = "".$i;
				}
				for($i=240;$i<256;$i++){
					$aryTI[43]["fisrt"][10]["second"][]["ip"] = "".$i;
				}
				$aryTI[43]["first"][11]["ip"] = "79";
				$aryTI[43]["first"][11]["second"] = array();
				for($i=0;$i<224;$i++){
					$aryTI[43]["fisrt"][11]["second"][]["ip"] = "".$i;
				}
				$aryTI[44]["ip"] = "218";
				$aryTI[44]["first"] = array();
				$aryTI[44]["first"][0]["ip"] = "32";
				$aryTI[44]["first"][1]["ip"] = "34";
				$aryTI[44]["first"][2]["ip"] = "35";
				for($i=160;$i<176;$i++){
					$aryTI[44]["first"][]["ip"] = "".$i;
				}
				$aryTI[44]["first"][]["ip"] = "184";
				$aryTI[44]["first"][]["ip"] = "187";
				$aryTI[44]["first"][]["ip"] = "210";
				$aryTI[44]["first"][]["ip"] = "211";
				$aryTI[45]["ip"] = "219";
				$aryTI[45]["first"] = array();
				$aryTI[45]["first"][0]["ip"] = "80";
				$aryTI[45]["first"][1]["ip"] = "81";
				$aryTI[45]["first"][2]["ip"] = "84";
				$aryTI[45]["first"][3]["ip"] = "85";
				$aryTI[45]["first"][4]["ip"] = "86";
				$aryTI[45]["first"][5]["ip"] = "87";
				$aryTI[45]["first"][6]["ip"] = "91";
				$aryTI[45]["first"][6]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[45]["fisrt"][6]["second"][]["ip"] = "".$i;
				}
				$aryTI[46]["ip"] = "220";
				$aryTI[46]["first"] = array();
				$aryTI[46]["first"][0]["ip"] = "128";
				$aryTI[46]["first"][1]["ip"] = "129";
				$aryTI[46]["first"][2]["ip"] = "130";
				$aryTI[46]["first"][3]["ip"] = "131";
				$aryTI[46]["first"][4]["ip"] = "132";
				$aryTI[46]["first"][5]["ip"] = "133";
				$aryTI[46]["first"][6]["ip"] = "134";
				$aryTI[46]["first"][7]["ip"] = "135";
				$aryTI[46]["first"][8]["ip"] = "136";
				$aryTI[46]["first"][9]["ip"] = "137";
				$aryTI[46]["first"][10]["ip"] = "138";
				$aryTI[46]["first"][11]["ip"] = "139";
				$aryTI[46]["first"][12]["ip"] = "140";
				$aryTI[46]["first"][13]["ip"] = "141";
				$aryTI[46]["first"][14]["ip"] = "142";
				$aryTI[46]["first"][15]["ip"] = "143";
				$aryTI[46]["first"][16]["ip"] = "157";
				$aryTI[46]["first"][16]["second"] = array();
				for($i=112;$i<128;$i++){
					$aryTI[46]["fisrt"][16]["second"][]["ip"] = "".$i;
				}
				$aryTI[46]["first"][17]["ip"] = "158";
				$aryTI[46]["first"][17]["second"] = array();
				for($i=228;$i<232;$i++){
					$aryTI[46]["fisrt"][17]["second"][]["ip"] = "".$i;
				}
				$aryTI[46]["first"][18]["ip"] = "228";
				$aryTI[46]["first"][19]["ip"] = "229";
				$aryTI[47]["ip"] = "221";
				$aryTI[47]["first"] = array();
				$aryTI[47]["first"][0]["ip"] = "120";
				$aryTI[47]["first"][0]["second"] = array();
				for($i=0;$i<96;$i++){
					$aryTI[47]["fisrt"][0]["second"][]["ip"] = "".$i;
				}
				$aryTI[47]["first"][1]["ip"] = "169";
				$aryTI[48]["ip"] = "222";
				$aryTI[48]["first"] = array();
				$aryTI[48]["first"][0]["ip"] = "156";
				$aryTI[48]["first"][1]["ip"] = "157";
				$aryTI[48]["first"][2]["ip"] = "250";
				$aryTI[48]["first"][3]["ip"] = "251";
				$aryTI[48]["first"][3]["second"] = array();
				for($i=0;$i<128;$i++){
					$aryTI[48]["fisrt"][3]["second"][]["ip"] = "".$i;
				}
				$aryTI[49]["ip"] = "223";
				$aryTI[49]["first"] = array();
				$aryTI[49]["first"][0]["ip"] = "22";
				$aryTI[49]["first"][1]["ip"] = "23";
				$aryTI[49]["first"][2]["ip"] = "27";
				$aryTI[49]["first"][2]["second"] = array();
				for($i=32;$i<64;$i++){
					$aryTI[49]["fisrt"][2]["second"][]["ip"] = "".$i;
				}
				$aryTI[49]["first"][3]["ip"] = "136";
				$aryTI[49]["first"][4]["ip"] = "137";
				$aryTI[49]["first"][5]["ip"] = "138";
				$aryTI[49]["first"][6]["ip"] = "139";
				$aryTI[49]["first"][7]["ip"] = "140";
				$aryTI[49]["first"][8]["ip"] = "141";
				$aryTI[49]["first"][9]["ip"] = "142";
				$aryTI[49]["first"][10]["ip"] = "143";
				$aryTI[49]["first"][11]["ip"] = "165";
				$aryTI[49]["first"][11]["second"] = array();
				for($i=8;$i<16;$i++){
					$aryTI[49]["fisrt"][11]["second"][]["ip"] = "".$i;
				}
				$aryTI[49]["first"][12]["ip"] = "200";

				if(!empty($_SERVER['HTTP_CLIENT_IP'])){
					$myip = $_SERVER['HTTP_CLIENT_IP'];
				}else if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
					$myip = $_SERVER['HTTP_X_FORWARDED_FOR'];
				}else{
					$myip= $_SERVER['REMOTE_ADDR'];
				}
				$aryMI = explode(".", $myip);

				$flag = 0;
				foreach($aryTI as $rows){
					if($aryMI[0] == $rows["ip"]){
						if(isset($rows["first"]) && is_array($rows["first"]) && count($rows["first"]) > 0){
							foreach($rows["first"] as $rows2){
								if($aryMI[1] == $rows2["ip"]){
									if(isset($rows2["second"]) && is_array($rows2["second"]) && count($rows2["second"]) > 0){
										foreach($rows2["second"] as $rows3){
											if($aryMI[2] == $rows3["ip"]){
												$flag = 1;
												break;
											}else if((int)$aryMI[2] < (int)$rows3["ip"]){
												break;
											}
										}
									}else{
										$flag = 1;
									}
									break;
								}else if((int)$aryMI[1] < (int)$rows2["ip"]){
									break;
								}
							}
						}else{
							$flag = 1;
						}
						break;
					}else if((int)$aryMI[0] < (int)$rows["ip"]){
						break;
					}
				}
				if($flag == 1){
					header("Location: home.html");
				}
			}

			//跳轉
			$webJumpType = $this->registry->webJumpType;
			$webJumpImage = $this->registry->webJumpImage;
			$webJumpLink = $this->registry->webJumpLink;
			$JumpHTML = "<div id=\"jumpDiv\" style=\"width:100%; background-color:#FFF; height:8000px; text-align:center;\">";
			if($webJumpLink != "")
				$JumpHTML .= "<a href=\"".$webJumpLink."\" target=\"_blank\">";
			$JumpHTML .= "<img src=\"".$webJumpImage."\" border=\"0\" />";
			if($webJumpLink != "")
				$JumpHTML .= "</a>";
			$JumpHTML .= "</div>";
			if($webJumpType == "10"){
				parent::addParameter("JumpHTML",$JumpHTML);
				parent::addParameter("JumpBody","");
				parent::addParameter("JumpScript","");
			}else if($webJumpType == "20"){
				$JumpHTML = "<div id=\"jumpDiv\" style=\"width:100%; background-color:#FFF; height:8000px; text-align:center;\" onmouseover=\"chgp();\">";
				$JumpHTML .= "<img src=\"".$webJumpImage."\" border=\"0\" />";
				$JumpHTML .= "</div>";
				
				parent::addParameter("JumpHTML",$JumpHTML);
				parent::addParameter("JumpBody","");
				parent::addParameter("JumpScript","<script type='text/javascript'>function chgp(){location.href = '".$webJumpLink."';}</script>");
			}else if($webJumpType == "30"){
				parent::addParameter("JumpHTML",$JumpHTML);
				parent::addParameter("JumpBody"," style='overflow:hidden;'");
				parent::addParameter("JumpScript","<script type='text/javascript'>window.onmousewheel=function(){return false;};window.onscroll=function(){window.scrollTo(0,0);}</script>");
			}else if($webJumpType == "60"){
				parent::addParameter("JumpHTML","<iframe id=\"jumpIframe\" name=\"mainwindow\" src=\"".$webJumpLink."\" style=\"width: 100%; height: 1182px;\" frameborder=\"0\">您的瀏覽器不支援內置框架或目前的設定為不顯示內置框架。</iframe><div style=\"width:100%; background-color:#FFF; height:8000px; text-align:center;\"></div>");
				parent::addParameter("JumpBody"," style='overflow:hidden;'");
				parent::addParameter("JumpScript","<script type='text/javascript'>document.getElementById(\"jumpIframe\").style.height=(document.documentElement.clientHeight)+\"px\";</script>");
			}else{
				parent::addParameter("JumpHTML","");
				parent::addParameter("JumpBody","");
				parent::addParameter("JumpScript","");
			}

			//臉書粉絲團
			if(trim($this->registry->fbFansURL) == ''){
				$fbRoot = '';
			}else{
				if($this->is_index){
					$fbRoot = "<div id=\"fb-root\"></div>\r\n<script>(function(d, s, id) {\r\n  var js, fjs = d.getElementsByTagName(s)[0];\r\n  if (d.getElementById(id)) return;\r\n  js = d.createElement(s); js.id = id;\r\n  js.src = \"//connect.facebook.net/zh_TW/sdk.js#xfbml=1&version=v2.3\";\r\n  fjs.parentNode.insertBefore(js, fjs);\r\n}(document, 'script', 'facebook-jssdk'));</script>";
				}else{
					if($this->registry->fbFansSidePageType == '3'){
						$fbRoot = "<div id=\"fb-root\"></div>\r\n<script>(function(d, s, id) {\r\n  var js, fjs = d.getElementsByTagName(s)[0];\r\n  if (d.getElementById(id)) return;\r\n  js = d.createElement(s); js.id = id;\r\n  js.src = \"//connect.facebook.net/zh_TW/sdk.js#xfbml=1&version=v2.3\";\r\n  fjs.parentNode.insertBefore(js, fjs);\r\n}(document, 'script', 'facebook-jssdk'));</script>";
					}else{
						$fbRoot = '';
					}
				}
			}
			parent::addParameter("fbRoot",$fbRoot);

			

			//rel link
			parent::addParameter("RelLink","https://".$_SERVER['HTTP_HOST']);
			parent::addParameter("HTTPHOST",$_SERVER['HTTP_HOST']);
			parent::addParameter("REQUESTURI",$_SERVER['REQUEST_URI']);

			//marquee
			parent::addParameter("webMarquee",$this->registry->webMarquee);

			//頁頭
			$header = webPartsFactory::create("header");
			$header->is_index = $this->is_index;
			$header->picturetype = $this->picturetype;
			$header->NoPicImage = $this->NoPicImage;
			$header->pwk = $this->pwk;
			$header->load();
			parent::addParameter("header",$header->getContent());

			//橫幅廣告
			$banner = webPartsFactory::create("banner");
			$banner->is_index = $this->is_index;
			$banner->picturetype = $this->picturetype;
			$banner->NoPicImage = $this->NoPicImage;
			$banner->load();
			parent::addParameter("banner",$banner->getContent());

			//頁側邊
			$sidePage = webPartsFactory::create("sidePage");
			$sidePage->picturetype = $this->picturetype;
			$sidePage->htLink4 = $this->htLink4;
			$sidePage->htLink2 = $this->htLink2;
			$sidePage->load();
			parent::addParameter("sidePage",$sidePage->getContent());
			
			//頁側邊
			$sidePage2 = webPartsFactory::create("sidePage2");
			$sidePage2->picturetype = $this->picturetype;
			$sidePage2->htLink4 = $this->htLink4;
			$sidePage2->load();
			parent::addParameter("sidePage2",$sidePage2->getContent());

			//頁脚
			$footer = webPartsFactory::create("footer");
			$footer->load();
			parent::addParameter("footer",$footer->getContent());
		}
		public function getPageParameter($name,$default){
			$value = "";
			if(isset($_GET[$name]) && $_GET[$name] != "")
				$value = $_GET[$name];
			else if(isset($_POST[$name]) && $_POST[$name] != "")
				$value = $_POST[$name];
			else
				$value = $default;
			$value = htmlentities($value);
			return trim($value);
		}
		public function alert($msg){
			echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />";
			echo "<script language=\"javascript\">window.alert(\"".$msg."\");history.back();</script>";
		}
		public function alert2($msg,$url){
			echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />";
			echo "<script language=\"javascript\">window.alert(\"".$msg."\");location.href=\"".$url."\";</script>";
		}
	}
?>