<?php
	require_once "pageBase.php";
	require_once "bin/system/conver.php";
	require_once "bin/system/email.php";
	require_once "bin/system/smtp_mail.php";
	require_once "bin/web/repeater.php";
	require_once "dal/orderDAL.php";
	require_once "dal/productDAL.php";
	require_once "dal/pictureDAL.php";
	class _order extends pageBase{
		public function load(){
			if($this->registry->webType != "20"){
				parent::alert2("線上訂單功能製作中!","/");
			}else{
				if(parent::isPostBack())
					$this->saveData();
				else
					$this->loadData();
			}
			parent::load();
		}
		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/order.html");
			
			//橫幅廣告
			$this->picturetype = "100";
			
			//線上訂單標題
			parent::addParameter("OrderName",$this->registry->OrderName);

			//線上購物說明
			$webOrder = $this->registry->webOrder;
			parent::addParameter("webOrder",$webOrder);

			//
			$dal = new productDAL();
			parent::addParameter("htLink4",$this->htLink4);
			
			//網站資訊
			$isShow = 0;
			
			//客服信箱是否顯示
			if($this->registry->webEmail == ""){
				parent::addParameter("webEmail","");
				parent::addParameter("webEmailStyle"," style='display:none;'");
			}else{
				if($this->registry->webEmailisShow == "1"){
					$isShow = 1;
					parent::addParameter("webEmail",$this->registry->webEmail);
					parent::addParameter("webEmailStyle","");
				}else{
					parent::addParameter("webEmail","");
					parent::addParameter("webEmailStyle"," style='display:none;'");
				}
			}
			
			//聯絡地址是否顯示
			if($this->registry->webAddress == ""){
				parent::addParameter("webAddress","");
				parent::addParameter("webAddressStyle"," style='display:none;'");
				parent::addParameter("webAddressLink","javascript:void(0);");
			}else{
				if($this->registry->webAddressisShow == "1"){
					$isShow = 1;
					parent::addParameter("webAddress",$this->registry->webAddress);
					parent::addParameter("webAddressStyle","");
					if(trim($this->registry->webAddress) != ''){
						$webAddressLink = "http://maps.google.com/maps?ll=23.016519,120.21529&z=15&t=m&hl=zh-TW&gl=US&mapclient=embed&q=".urlencode(trim($this->registry->webAddress));
					}else{
						$webAddressLink = "javascript:void(0);";
					}
					parent::addParameter("webAddressLink",$webAddressLink);
				}else{
					parent::addParameter("webAddress","");
					parent::addParameter("webAddressStyle"," style='display:none;'");
					parent::addParameter("webAddressLink","javascript:void(0);");
				}
			}
			
			//聯絡電話是否顯示
			if($this->registry->webPhone == ""){
				parent::addParameter("webPhone","");
				parent::addParameter("webPhoneStyle"," style='display:none;'");
			}else{
				if($this->registry->webPhoneisShow == "1"){
					$isShow = 1;
					parent::addParameter("webPhone",$this->registry->webPhone);
					parent::addParameter("webPhoneStyle","");
				}else{
					parent::addParameter("webPhone","");
					parent::addParameter("webPhoneStyle"," style='display:none;'");
				}
			}
			
			//聯絡傳真是否顯示
			if($this->registry->webFax == ""){
				parent::addParameter("webFax","");
				parent::addParameter("webFaxStyle"," style='display:none;'");
			}else{
				if($this->registry->webFaxisShow == "1"){
					$isShow = 1;
					parent::addParameter("webFax",$this->registry->webFax);
					parent::addParameter("webFaxStyle","");
				}else{
					parent::addParameter("webFax","");
					parent::addParameter("webFaxStyle"," style='display:none;'");
				}
			}
			
			if($isShow == 1){
				parent::addParameter("webInfoStyle","");
			}else{
				parent::addParameter("webInfoStyle"," style='display:none;'");
			}
			//Google MAP
			if(trim($this->registry->googlemapAddress) != ''){
				parent::addParameter("googlemapAddress",urlencode(trim($this->registry->googlemapAddress)));
				parent::addParameter("googlemapStyle","");
			}else{
				parent::addParameter("googlemapAddress","");
				parent::addParameter("googlemapStyle"," style='display:none;'");
			}
			
			//網站資訊是否顯示
			$arySN = explode(",",$this->registry->sideNavShow);
			if(in_array($this->picturetype,$arySN)){
				parent::addParameter("sideNavStyle","");
			}else{
				parent::addParameter("sideNavStyle"," style='display:none;'");
			}

			//購物車
			$productPrice = 0;
			$transPrice = $this->registry->transPrice;
			$transFreePrice = $this->registry->transFreePrice;
			if(isset($_COOKIE["cart"])){
				$cart = $_COOKIE["cart"];
				$cart = str_replace('\"','"',$cart);
				$cartAry = json_decode($cart);
				$aryC = array();
				$newCartAry = array();
				$flag = 0;
				foreach($cartAry as $row){
					$dal->ProductID = $row->id;
					$dal->loadRecord();
					if($dal->Visible == "1" && $dal->CategoryVisible == "1" && ($dal->ParentVisible == "1" || $dal->ParentID == "0") && is_numeric($row->q)){
						$ary1 = array();
						$ary1["ProductID"] = $dal->ProductID;
						if(trim($dal->IconImage) != '' && file_exists('.'.$dal->IconImage)){
							$ary1["IconImage"] = $dal->IconImage;
							$ary1["imageStyle"] = "";
						}else{
							$ary1["IconImage"] = "/images/no-pic.jpg";
							$ary1["imageStyle"] = " style='display:none;'";
						}
						$ary1["ProductName"] = $dal->ProductName;
						$ary1["Price"] = $dal->Price;
						$ary1["Quantity"] = $row->q;
						$ary1["Amount"] = "".((int)$dal->Price * (int)$row->q);
						$ary1["htLink"] = $this->htLink4;
						$aryC[] = $ary1;
						$productPrice += ((int)$dal->Price * (int)$row->q);

						$ary2 = array();
						$ary2["id"] = $row->id;
						$ary2["q"] = $row->q;
						$newCartAry[] = $ary2;
					}else{
						$flag = 1;
					}
				}
				$cart = json_encode($newCartAry);
				setcookie("cart",$cart);
				$listC = new repeater();
				$listC->id = "listC";
				$listC->dataSource = $aryC;
				parent::addControl($listC);
				parent::addParameter("ProductPrice","".$productPrice);
				if($productPrice >= (int)$transFreePrice){
					parent::addParameter("TransPrice","0");
					parent::addParameter("OrderPrice","".$productPrice);
				}else{
					parent::addParameter("TransPrice","".$transPrice);
					parent::addParameter("OrderPrice","".($productPrice + (int)$transPrice));
				}
			}else{
				parent::alert2("購物車是空的!","/");
			}

			//父類方法
			parent::loadData();
		}

		private function saveData(){
			////logo
			$dalPi = new pictureDAL();
			$dalPi->PictureType = "10";
			$dalPi->TypeOrderNO = "0";
			$dalPi->loadRecord();
			
			$checknum = conver::toDbString(trim($_POST["Checknum"]));
			if($checknum == $_SESSION["dd_ckstr"] && isset($_SESSION["dd_ckstr"]) && $_SESSION["dd_ckstr"] != ''){
				$dal = new orderDAL();
				$dalP = new productDAL();
				$productPrice = 0;
				$transPrice = (int)$this->registry->transPrice;
				$transFreePrice = (int)$this->registry->transFreePrice;
				$orderPrice = 0;
				if(isset($_COOKIE["cart"])){
					$cart = $_COOKIE["cart"];
					$cart = str_replace('\"','"',$cart);
					$cartAry = json_decode($cart);
					$dal->OrderProduct = array();
					foreach($cartAry as $row){
						$dalP->ProductID = $row->id;
						$dalP->loadRecord();
						if($dalP->ProductID == $row->id && is_numeric($row->q)){
							$ary = array();
							$ary["ProductID"] = $dalP->ProductID;
							$ary["Price"] = $dalP->Price;
							$ary["Quantity"] = $row->q;
							$dal->OrderProduct[] = $ary;
							$productPrice += ((int)$dalP->Price * (int)$row->q);
						}
					}
					if($productPrice >= $transFreePrice){
						$transPrice = 0;
						$orderPrice = $productPrice;
					}else{
						$orderPrice = $productPrice + $transPrice;
					}
					if($productPrice == (int)conver::toDbString($_POST["ProductPrice"]) && $transPrice == (int)conver::toDbString($_POST["TransPrice"]) && $orderPrice == (int)conver::toDbString($_POST["OrderPrice"])){
						$dal->ProductPrice = $productPrice;
						$dal->TransPrice = $transPrice;
						$dal->OrderPrice = $orderPrice;
						$dal->Name = conver::toDbString(trim($_POST["Name"]));
						$dal->Email = conver::toDbString(trim($_POST["Email"]));
						$dal->Phone = conver::toDbString(trim($_POST["Phone"]));
						$dal->Mobile = conver::toDbString(trim($_POST["Mobile"]));
						$dal->Address = conver::toDbString(trim($_POST["Address"]));
						$dal->Content = conver::toDbString(trim($_POST["Content"]));
						if(!empty($_SERVER["HTTP_CLIENT_IP"])){
							$ip = $_SERVER["HTTP_CLIENT_IP"];
						}else if(!empty($_SERVER["HTTP_X_FORWARDED_FOR"])){
							$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
						}else{
							$ip = $_SERVER["REMOTE_ADDR"];
						}
						$dal->CreatedIP = $ip;

						//系統信件內容
						$mailtxt = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
						$mailtxt .= '<html xmlns="http://www.w3.org/1999/xhtml">';
						$mailtxt .= '<head>';
						$mailtxt .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
						$mailtxt .= '</head>';
						$mailtxt .= '<body>';
						$mailtxt .= '<p>此信件為系統自動寄送之通知信!請勿直接回覆!</p>';
						$mailtxt .= '<table border="1" align="center" cellpadding="0" cellspacing="0" style="width:660px; border:1px #000 solid;">';
						$mailtxt .= '<tr>';
						$mailtxt .= '<td colspan="4" style="border:0; border-bottom:1px #ccc solid; text-align:center;"><img src="';
						if($dalPi->Image == ''){
							$mailtxt .= '';
						}else{
							$mailtxt .= 'http://'.$_SERVER["HTTP_HOST"].$dalPi->Image;
						}
						$mailtxt .= '" style="margin:30px;" /></td>';
						$mailtxt .= '</tr>';
						$mailtxt .= '<tr style="background:#E7E7E7;border-left:0;">';
						$mailtxt .= '<th style="border-left:0;">產品名稱&nbsp;&nbsp;</th>';
						$mailtxt .= '<th style="border-left:0;">單價&nbsp;&nbsp;</th>';
						$mailtxt .= '<th style="border-left:0;">數量&nbsp;&nbsp;</th>';
						$mailtxt .= '<th style="border-left:0;">小計&nbsp;&nbsp;</th>';
						$mailtxt .= '</tr>';
						foreach($dal->OrderProduct as $row){
							$dalP->ProductID = $row["ProductID"];
							$dalP->loadRecord();
							if(trim($dalP->IconImage) != '' && file_exists('.'.$dalP->IconImage)){
								$image = '<img src="http://'.$_SERVER['HTTP_HOST'].$dalP->IconImage.'" width="50" height="50">';
							}else{
								$image = '';
							}
							$mailtxt .= '<tr>';
							$mailtxt .= '<td><a href="http://'.$_SERVER['HTTP_HOST'].'/'.$this->htLink4.'-'.$row["ProductID"].'.html" target="_blank">'.$image.$dalP->ProductName.'</a></td>';
							$mailtxt .= '<td>'.$row["Price"].'</td>';
							$mailtxt .= '<td>'.$row["Quantity"].'</td>';
							$mailtxt .= '<td>'.((int)$row["Price"] * (int)$row["Quantity"]).'</td>';
							$mailtxt .= '</tr>';
						}
						$mailtxt .= '<tr><td colspan="4" style="text-align:right;"><br />產品金額：'.$productPrice.'<br /></td></tr>';
						$mailtxt .= '<tr><td colspan="4" style="text-align:right;"><br />運費：'.$transPrice.'<br /></td></tr>';
						$mailtxt .= '<tr><td colspan="4" style="text-align:right;"><br />總計：'.$orderPrice.'<br /></td></tr>';
						$mailtxt .= '</table><br />';
						$mailtxt .= '<table border="1" align="center" cellpadding="0" cellspacing="0" style="width:660px; border:1px #000 solid;">';
						$mailtxt .= '<tr style="background:#E7E7E7;">';
						$mailtxt .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
						$mailtxt .= '<br />姓名：<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
						$mailtxt .= '<br />'.$dal->Name.'<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '</tr>';
						$mailtxt .= '<tr>';
						$mailtxt .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
						$mailtxt .= '<br />電話：<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
						$mailtxt .= '<br />'.$dal->Phone.'<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '</tr>';
						$mailtxt .= '<tr style="background:#E7E7E7;">';
						$mailtxt .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
						$mailtxt .= '<br />手機：<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
						$mailtxt .= '<br />'.$dal->Mobile.'<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '</tr>';
						$mailtxt .= '<tr>';
						$mailtxt .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
						$mailtxt .= '<br />地址：<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
						$mailtxt .= '<br />'.$dal->Address.'<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '</tr>';
						$mailtxt .= '<tr style="background:#E7E7E7;">';
						$mailtxt .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
						$mailtxt .= '<br />信箱：<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
						$mailtxt .= '<br />'.$dal->Email.'<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '</tr>';
						$mailtxt .= '<tr>';
						$mailtxt .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
						$mailtxt .= '<br />備註：<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
						$mailtxt .= '<br />'.str_replace("\r\n","<br />",$dal->Content).'<br />';
						$mailtxt .= '</td>';
						$mailtxt .= '</tr>';
						$mailtxt .= '</table><br />';
						$mailtxt .= '<p>此信件為系統自動寄送之通知信!請勿直接回覆!</p>';
						$mailtxt .= '</body>';
						$mailtxt .= '</html>';
						
						//信件
						$sendMail = array();
						if(trim($this->registry->systemEmail1) != ''){
							$sendMail[] = trim($this->registry->systemEmail1);
						}
						if(trim($this->registry->systemEmail2) != ''){
							$sendMail[] = trim($this->registry->systemEmail2);
						}
						if(trim($this->registry->systemEmail3) != ''){
							$sendMail[] = trim($this->registry->systemEmail3);
						}
						if(trim($this->registry->systemEmail4) != ''){
							$sendMail[] = trim($this->registry->systemEmail4);
						}
						if(trim($this->registry->systemEmail5) != ''){
							$sendMail[] = trim($this->registry->systemEmail5);
						}
						if(count($sendMail) > 0){
							if($this->registry->sendMailType == ""){
								$email = new email();
								$email->fromAddress = "=?UTF-8?B?".base64_encode($this->registry->webName)."?=<".$this->registry->webEmail.">";
								$email->replyToAddress = "=?UTF-8?B?".base64_encode($dal->Name)."?=<".$dal->Email.">";
								$email->subject = "[".$this->registry->webName."][線上訂單系統通知]";
								$email->content = $mailtxt;
								$email->toAddress = implode(",",$sendMail);
								if($email->send()){
									if(!$dal->insertRecord()){
										parent::alert("很抱歉!線上訂單送出不成功!");
									}else{
										setcookie("cart","");
										
										//系統信件內容
										$mailtxt2 = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
										$mailtxt2 .= '<html xmlns="http://www.w3.org/1999/xhtml">';
										$mailtxt2 .= '<head>';
										$mailtxt2 .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
										$mailtxt2 .= '</head>';
										$mailtxt2 .= '<body>';
										$mailtxt2 .= '<p>親愛的顧客您好，非常感謝您的訂購。<br />我們已收到您的訂單，我們客服人員會在第一時間，為您出貨，請你耐心等候。</p>';
										$mailtxt2 .= '<table border="1" align="center" cellpadding="0" cellspacing="0" style="width:660px; border:1px #000 solid;">';
										$mailtxt2 .= '<tr>';
										$mailtxt2 .= '<td colspan="4" style="border:0; border-bottom:1px #ccc solid; text-align:center;"><img src="';
										if($dalPi->Image == ''){
											$mailtxt2 .= '';
										}else{
											$mailtxt2 .= 'http://'.$_SERVER["HTTP_HOST"].$dalPi->Image;
										}
										$mailtxt2 .= '" style="margin:30px;" /></td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr style="background:#E7E7E7;border-left:0;">';
										$mailtxt2 .= '<th style="border-left:0;">產品名稱&nbsp;&nbsp;</th>';
										$mailtxt2 .= '<th style="border-left:0;">單價&nbsp;&nbsp;</th>';
										$mailtxt2 .= '<th style="border-left:0;">數量&nbsp;&nbsp;</th>';
										$mailtxt2 .= '<th style="border-left:0;">小計&nbsp;&nbsp;</th>';
										$mailtxt2 .= '</tr>';
										foreach($dal->OrderProduct as $row){
											$dalP->ProductID = $row["ProductID"];
											$dalP->loadRecord();
											if(trim($dalP->IconImage) != '' && file_exists('.'.$dalP->IconImage)){
												$image = '<img src="http://'.$_SERVER['HTTP_HOST'].$dalP->IconImage.'" width="50" height="50">';
											}else{
												$image = '';
											}
											$mailtxt2 .= '<tr>';
											$mailtxt2 .= '<td><a href="http://'.$_SERVER['HTTP_HOST'].'/'.$this->htLink4.'-'.$row["ProductID"].'.html" target="_blank">'.$image.$dalP->ProductName.'</a></td>';
											$mailtxt2 .= '<td>'.$row["Price"].'</td>';
											$mailtxt2 .= '<td>'.$row["Quantity"].'</td>';
											$mailtxt2 .= '<td>'.((int)$row["Price"] * (int)$row["Quantity"]).'</td>';
											$mailtxt2 .= '</tr>';
										}
										$mailtxt2 .= '<tr><td colspan="4" style="text-align:right;"><br />產品金額：'.$productPrice.'<br /></td></tr>';
										$mailtxt2 .= '<tr><td colspan="4" style="text-align:right;"><br />運費：'.$transPrice.'<br /></td></tr>';
										$mailtxt2 .= '<tr><td colspan="4" style="text-align:right;"><br />總計：'.$orderPrice.'<br /></td></tr>';
										$mailtxt2 .= '</table><br />';
										$mailtxt2 .= '<table border="1" align="center" cellpadding="0" cellspacing="0" style="width:660px; border:1px #000 solid;">';
										$mailtxt2 .= '<tr style="background:#E7E7E7;">';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />姓名：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Name.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr>';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />電話：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Phone.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr style="background:#E7E7E7;">';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />手機：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Mobile.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr>';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />地址：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Address.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr style="background:#E7E7E7;">';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />信箱：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Email.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr>';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />備註：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.str_replace("\r\n","<br />",$dal->Content).'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '</table><br />';
										$mailtxt2 .= '<p>親愛的顧客您好，非常感謝您的訂購。<br />我們已收到您的訂單，我們客服人員會在第一時間，為您出貨，請你耐心等候。</p>';
										$mailtxt2 .= '</body>';
										$mailtxt2 .= '</html>';
										
										//信件
										$e2mail = new email();
										$e2mail->fromAddress = "=?UTF-8?B?".base64_encode($this->registry->webName)."?=<".$this->registry->webEmail.">";
										$e2mail->replyToAddress = "=?UTF-8?B?".base64_encode($dal->Name)."?=<".$dal->Email.">";
										$e2mail->subject = "[".$_SERVER['HTTP_HOST']."][線上訂單系統確認信]".$dal->Title;
										$e2mail->content = $mailtxt2;
										$e2mail->toAddress = $dal->Email;
										$e2mail->send();
										
										parent::alert2("線上訂單已經送出!我們會盡快處理您的訂單!","/");
									}
								}else{
									parent::alert("很抱歉!線上訂單送出不成功!!");
								}
							}else{
								$smtp_mail = new smtp_mail();
								$smtp_mail->toAry = $sendMail;
								$smtp_mail->name = "=?UTF-8?B?".base64_encode($this->registry->webName)."?=";
								$smtp_mail->subject = "[".$this->registry->webName."][線上訂單系統通知]";
								$smtp_mail->body = $mailtxt;
								if($smtp_mail->send()){
									if(!$dal->insertRecord()){
										parent::alert("很抱歉!線上訂單送出不成功!");
									}else{
										setcookie("cart","");
										
										//系統信件內容
										$mailtxt2 = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
										$mailtxt2 .= '<html xmlns="http://www.w3.org/1999/xhtml">';
										$mailtxt2 .= '<head>';
										$mailtxt2 .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
										$mailtxt2 .= '</head>';
										$mailtxt2 .= '<body>';
										$mailtxt2 .= '<p>親愛的顧客您好，非常感謝您的訂購。<br />我們已收到您的訂單，我們客服人員會在第一時間，為您出貨，請你耐心等候。</p>';
										$mailtxt2 .= '<table border="1" align="center" cellpadding="0" cellspacing="0" style="width:660px; border:1px #000 solid;">';
										$mailtxt2 .= '<tr>';
										$mailtxt2 .= '<td colspan="4" style="border:0; border-bottom:1px #ccc solid; text-align:center;"><img src="';
										if($dalPi->Image == ''){
											$mailtxt2 .= '';
										}else{
											$mailtxt2 .= 'http://'.$_SERVER["HTTP_HOST"].$dalPi->Image;
										}
										$mailtxt2 .= '" style="margin:30px;" /></td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr style="background:#E7E7E7;border-left:0;">';
										$mailtxt2 .= '<th style="border-left:0;">產品名稱&nbsp;&nbsp;</th>';
										$mailtxt2 .= '<th style="border-left:0;">單價&nbsp;&nbsp;</th>';
										$mailtxt2 .= '<th style="border-left:0;">數量&nbsp;&nbsp;</th>';
										$mailtxt2 .= '<th style="border-left:0;">小計&nbsp;&nbsp;</th>';
										$mailtxt2 .= '</tr>';
										foreach($dal->OrderProduct as $row){
											$dalP->ProductID = $row["ProductID"];
											$dalP->loadRecord();
											if(trim($dalP->IconImage) != '' && file_exists('.'.$dalP->IconImage)){
												$image = '<img src="http://'.$_SERVER['HTTP_HOST'].$dalP->IconImage.'" width="50" height="50">';
											}else{
												$image = '';
											}
											$mailtxt2 .= '<tr>';
											$mailtxt2 .= '<td><a href="http://'.$_SERVER['HTTP_HOST'].'/'.$this->htLink4.'-'.$row["ProductID"].'.html" target="_blank">'.$image.$dalP->ProductName.'</a></td>';
											$mailtxt2 .= '<td>'.$row["Price"].'</td>';
											$mailtxt2 .= '<td>'.$row["Quantity"].'</td>';
											$mailtxt2 .= '<td>'.((int)$row["Price"] * (int)$row["Quantity"]).'</td>';
											$mailtxt2 .= '</tr>';
										}
										$mailtxt2 .= '<tr><td colspan="4" style="text-align:right;"><br />產品金額：'.$productPrice.'<br /></td></tr>';
										$mailtxt2 .= '<tr><td colspan="4" style="text-align:right;"><br />運費：'.$transPrice.'<br /></td></tr>';
										$mailtxt2 .= '<tr><td colspan="4" style="text-align:right;"><br />總計：'.$orderPrice.'<br /></td></tr>';
										$mailtxt2 .= '</table><br />';
										$mailtxt2 .= '<table border="1" align="center" cellpadding="0" cellspacing="0" style="width:660px; border:1px #000 solid;">';
										$mailtxt2 .= '<tr style="background:#E7E7E7;">';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />姓名：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Name.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr>';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />電話：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Phone.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr style="background:#E7E7E7;">';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />手機：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Mobile.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr>';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />地址：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Address.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr style="background:#E7E7E7;">';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />信箱：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.$dal->Email.'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '<tr>';
										$mailtxt2 .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
										$mailtxt2 .= '<br />備註：<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
										$mailtxt2 .= '<br />'.str_replace("\r\n","<br />",$dal->Content).'<br />';
										$mailtxt2 .= '</td>';
										$mailtxt2 .= '</tr>';
										$mailtxt2 .= '</table><br />';
										$mailtxt2 .= '<p>親愛的顧客您好，非常感謝您的訂購。<br />我們已收到您的訂單，我們客服人員會在第一時間，為您出貨，請你耐心等候。</p>';
										$mailtxt2 .= '</body>';
										$mailtxt2 .= '</html>';
											
										//信件
										$to2Ary = array();
										$to2Ary[] = $dal->Email;
										$smtp2_mail = new smtp_mail();
										$smtp2_mail->toAry = $to2Ary;
										$smtp2_mail->name = "=?UTF-8?B?".base64_encode($this->registry->webName)."?=";
										$smtp2_mail->subject = "[".$_SERVER['HTTP_HOST']."][線上訂單系統確認信]".$dal->Title;
										$smtp2_mail->body = $mailtxt2;
										$smtp2_mail->send();
											
										parent::alert2("線上訂單已經送出!我們會盡快處理您的訂單!","/");
									}
								}else{
									parent::alert("很抱歉!線上訂單送出不成功!!");
								}
							}
						}else{
							if(!$dal->insertRecord()){
								parent::alert("很抱歉!線上訂單送出不成功!");
							}else{
								setcookie("cart","");
								parent::alert2("線上訂單已經送出!我們會盡快處理您的訂單!","/");
							}
						}
					}else{
						parent::alert2("系統異常!請重新整理再試一次!",$this->htLink7.".html");
					}
				}else{
					parent::alert2("購物車是空的!","/");
				}
			}else{
				parent::alert("驗證碼輸入錯誤喔");
			}
		}
	}

	$page = new _order();
	$page->load();
	$page->render();
?>