<?php
	require_once "pageBase.php";
	require_once "bin/web/repeater.php";
	require_once "dal/newsDAL.php";
	require_once "dal/news_categoryDAL.php";
	require_once "dal/pictureDAL.php";

	class _news extends pageBase{
		public function load(){
			$this->loadData();
			parent::load();
		}
		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/news.html");
			
			//橫幅廣告
			$this->picturetype = "60";

			//宣告
			$dal = new newsDAL();
			$dalC = new news_categoryDAL();
			$id = parent::getPageParameter("id","");
			$pageIndex = (int)parent::getPageParameter("p","1");
			if(isset($this->registry->newsPageSize) && $this->registry->newsPageSize != "" && $this->registry->newsPageSize != "0"){
				$pageSize = (int)$this->registry->newsPageSize;
			}else{
				$pageSize = 10;
			}
			$start = ($pageIndex - 1) * $pageSize;
			parent::addParameter("htLink",$this->htLink2);

			//條件式
			$filter = "a.`Visible`='1' AND a.`OnlineTime`<='".date("Y-m-d H:i:s")."' AND b.`Visible`='1'";
			if($id != "" && $id != "0"){
				$filter .= " AND a.`CategoryID`='".$id."'";
			}
			$orderExp = "a.`OrderNO`,a.`OnlineTime` DESC,b.`OrderNO`,a.`CreatedTime` DESC";

			//最新消息分類資訊
			if($id != "" && $id != "0"){
				$dalC->CategoryID = $id;
				$dalC->loadRecord();
				if($dalC->Visible != "1"){
					parent::alert2("頁面不存在!!",$this->htLink2.".html");
					exit;
				}
				parent::addParameter("CategoryName",$dalC->CategoryName);
				parent::addParameter("CategoryID",$dalC->CategoryID);

				if(trim($dalC->WebTitle) != ""){
					parent::addParameter("webTitle",$dalC->WebTitle);
				}
				if(trim($dalC->WebKeyword) != ""){
					parent::addParameter("webKeyword",$dalC->WebKeyword);
				}
				if(trim($dalC->WebDescription) != ""){
					parent::addParameter("webDescription",$dalC->WebDescription);
				}
			}else{
				parent::addParameter("CategoryName","Tin mới");
				parent::addParameter("className"," class='action'");
			}

			//最新消息分類列表
			$dataC = $dalC->executeRecordset("a.`Visible`='1'");
			for($i=0;$i<count($dataC);$i++){
				$dataC[$i]["htLink"] = $this->htLink2;
				if($dataC[$i]["CategoryID"] == $id){
					$dataC[$i]["className"] = " class='action'";
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			//最新消息列表
			$data = $dal->executeRecordset($filter,$orderExp,$start,$pageSize);
			for($i=0;$i<count($data);$i++){
				$data[$i]["htLink"] = $this->htLink2;
				$data[$i]["Introduction"] = str_replace("\r\n","<br />",$data[$i]["Introduction"]);
				$data[$i]["sIntroduction"] = str_replace("\r\n","<br />",$data[$i]["Introduction"]);
				if(trim($data[$i]["Image"]) == "" || !file_exists(".".$data[$i]["Image"])){
					$data[$i]["Image"] = $this->NoPicImage;
					$data[$i]["imageStyle"] = " style='display:none;'";
				}else{
					$data[$i]["imageStyle"] = "";
				}
				$data[$i]["OnlineDate"] = date("Y-m-d",strtotime($data[$i]["OnlineTime"]));
				$data[$i]["OnlineY"] = date("Y",strtotime($data[$i]["OnlineTime"]));
				$data[$i]["OnlineM"] = date("m",strtotime($data[$i]["OnlineTime"]));
				$data[$i]["OnlineD"] = date("d",strtotime($data[$i]["OnlineTime"]));
				$data[$i]["OnlineM2"] = date("M",strtotime($data[$i]["OnlineTime"]));
				$data[$i]["NO1"] = $i + 1;
				$data[$i]["NO2"] = str_pad($data[$i]["NO1"],2,"0",STR_PAD_LEFT);
				$data[$i]["NO3"] = $start + $i + 1;
				$data[$i]["NO4"] = str_pad($data[$i]["NO3"],3,"0",STR_PAD_LEFT);
			}
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			//分頁
			$pageRange = 10;							//分頁範圍
			$rowCount = $dal->countRecordset($filter);
			$nm1 = $rowCount % $pageSize;				//取得不滿一頁的資料筆數
			$nm2 = ($rowCount - $nm1) / $pageSize;		//取得總頁數(目前是滿頁的頁數)
			if($nm1 > 0){								//如果有不滿一頁的資料，總頁數加一
				$nm2 = $nm2 + 1;
			}
			$nm3 = $pageIndex % $pageRange;				//取得頁數在分頁範圍的位置
			$nm4 = ($pageIndex - $nm3) / $pageRange;	//取得頁數在第幾個分頁範圍
			if($nm3 == 0){								//頁數在分頁範圍最後時，第幾個分頁範圍需要減一
				$nm4 = $nm4 - 1;
			}
			////檢查是否超過範圍
			if($rowCount > 0){
				if($pageIndex > $nm2 || $pageIndex < 1){
					parent::alert2("頁面不存在!", $this->htLink2.$id.".html");
					exit;
				}
			}else{
				if($pageIndex != 1){
					parent::alert2("頁面不存在!", $this->htLink2.$id.".html");
					exit;
				}
			}
			////上一頁////
			$pagtxt = "<a class='prev' href='".$this->htLink2.$id."_";
			if($pageIndex == 1){
				$pagtxt .= "1";
			}else{
				$pagtxt .= ($pageIndex - 1);
			}
			$pagtxt .= ".html'><i class=\"fa fa-angle-double-left\"></i></a>";
			////分頁範圍////
			for($i=1;$i<=$pageRange;$i++){
				if($nm4 * $pageRange + $i == $pageIndex){
					$pagtxt .= "<strong>".($nm4 * $pageRange + $i)."</strong>";
				}else{
					$pagtxt .= "<a href='".$this->htLink2.$id."_".($nm4 * $pageRange + $i).".html'>".($nm4 * $pageRange + $i)."</a>";
				}
				if($nm4 * $pageRange + $i == $nm2){
					$i = $pageRange + 1;
				}
			}
			////下一頁////
			$pagtxt .= "<a class='next' href='".$this->htLink2.$id."_";
			if($pageIndex == $nm2){
				$pagtxt .= $pageIndex;
			}else{
				$pagtxt .= ($pageIndex + 1);
			}
			$pagtxt .= ".html'><i class=\"fa fa-angle-double-right\"></i></a>";
			if($rowCount == 0){							////如果沒有任何資料時
				$pagtxt = "目前暫無資料!!";
			}
			parent::addParameter("pagtxt",$pagtxt);

			//父類方法
			parent::loadData();
		}
	}

	$page = new _news();
	$page->load();
	$page->render();
?>