<?php
	require_once "pageBase.php";
	require_once "bin/web/repeater.php";
	require_once "dal/newsDAL.php";
	require_once "dal/news_categoryDAL.php";

	class _newsdetail extends pageBase{
		public function load(){
			$this->loadData();
			parent::load();
		}
		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/news-detail.html");

			//橫幅廣告
			$this->picturetype = "60";

			//宣告
			$dal = new newsDAL();
			$dalC = new news_categoryDAL();
			$id = parent::getPageParameter("id","0");
			parent::addParameter("htLink",$this->htLink2);

			//最新消息
			if($id == "0"){
				parent::alert2("頁面不存在!!",$this->htLink2.".html");
				exit;
			}else{
				$dal->NewsID = $id;
				$dal->loadRecord();
				if($dal->Visible != "1" || strtotime($dal->OnlineTime) > time()){
					parent::alert2("頁面不存在!!",$this->htLink2.".html");
					exit;
				}else{
					$dalC->CategoryID = $dal->CategoryID;
					$dalC->loadRecord();
					if($dalC->Visible != "1"){
						parent::alert2("頁面不存在!!",$this->htLink2.".html");
						exit;
					}else{
						parent::addParameter("CategoryName",$dal->CategoryName);
						parent::addParameter("CategoryID",$dal->CategoryID);
						parent::addParameter("NewsID",$dal->NewsID);
						parent::addParameter("Title",$dal->Title);
						if($dal->QuoteText == "" && $dal->QuoteLink == ""){
							parent::addParameter("QuoteStyle"," style='display:none;'");
							parent::addParameter("QuoteText","");
							parent::addParameter("QuoteLink","");
						}else{
							parent::addParameter("QuoteStyle","");
							if($dal->QuoteText == ""){
								parent::addParameter("QuoteText",$dal->QuoteLink);
							}else{
								parent::addParameter("QuoteText",$dal->QuoteText);
							}
							if($dal->QuoteLink == ""){
								parent::addParameter("QuoteLink","javascript:void(0);");
							}else{
								parent::addParameter("QuoteLink",$dal->QuoteLink);
							}
						}
						$introduction = str_replace("\r\n","<br />",$dal->Introduction);
						parent::addParameter("Introduction",$introduction);
						parent::addParameter("Description",$dal->Description);
						if(trim($dal->Image) == "" || !file_exists(".".$dal->Image)){
							parent::addParameter("Image","/images/no-pic.jpg");
							parent::addParameter("imageStyle"," style='display:none;'");
						}else{
							parent::addParameter("Image",$dal->Image);
							parent::addParameter("imageStyle","");
						}
						$onlineDate = date("Y-m-d",strtotime($dal->OnlineTime));
						$onlineY = date("Y",strtotime($dal->OnlineTime));
						$onlineM = date("m",strtotime($dal->OnlineTime));
						$onlineD = date("d",strtotime($dal->OnlineTime));
						$onlineM2 = date("M",strtotime($dal->OnlineTime));
						parent::addParameter("OnlineTime",$dal->OnlineTime);
						parent::addParameter("OnlineDate",$onlineDate);
						parent::addParameter("OnlineY",$onlineY);
						parent::addParameter("OnlineM",$onlineM);
						parent::addParameter("OnlineD",$onlineD);
						parent::addParameter("OnlineM2",$onlineM2);
						if(trim($dal->WebTitle) != ""){
							parent::addParameter("webTitle",$dal->WebTitle);
						}
						if(trim($dal->WebKeyword) != ""){
							parent::addParameter("webKeyword",$dal->WebKeyword);
						}
						if(trim($dal->WebDescription) != ""){
							parent::addParameter("webDescription",$dal->WebDescription);
						}
					}
				}
			}

			//最新消息分類列表
			$dataC = $dalC->executeRecordset("a.`Visible`='1'");
			for($i=0;$i<count($dataC);$i++){
				$dataC[$i]["htLink"] = $this->htLink2;
				if($dataC[$i]["CategoryID"] == $dal->CategoryID){
					$dataC[$i]["className"] = " class='action'";
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			//上下頁
			$filter = "a.`CategoryID`='".$dal->CategoryID."' AND a.`OnlineTime`<='".date("Y-m-d H:i:s")."' AND a.`Visible`='1' AND b.`Visible`='1'";
			$orderExp = "a.`OrderNO`,a.`OnlineTime` DESC,a.`CreatedTime` DESC";
			$data = $dal->executeRecordset($filter,$orderExp);
			$flagA = 0;												//判斷是否找到目前的最新消息
			for($i=0;$i<count($data);$i++){
				if($flagA == 0){
					if($data[$i]["NewsID"] == $id){
						$flagA = 1;
					}else{
						$pagUID = $data[$i]["NewsID"];				//上一筆最新消息的ID
						$pagUTitle = $data[$i]["Title"];			//上一筆最新消息的名稱
						$pagUImage = $data[$i]["Image"];			//上一筆最新消息的圖片
					}
				}else{
					$pagDID = $data[$i]["NewsID"];					//下一筆最新消息的ID
					$pagDTitle = $data[$i]["Title"];				//下一筆最新消息的名稱
					$pagDImage = $data[$i]["Image"];				//下一筆最新消息的圖片
					$i = count($data) + 1;
				}
			}
			if($pagUID != ""){
				parent::addParameter("pageUpLink",$this->htLink2."-".$pagUID.".html");
				parent::addParameter("pageUpTitle",$pagUTitle);
				parent::addParameter("pageUpStyle","");
				if(trim($pagUImage) == "" || !file_exists(".".$pagUImage)){
					parent::addParameter("pagUpImage","/images/no-pic.jpg");
				}else{
					parent::addParameter("pagUpImage",$pagUImage);
				}
			}else{
				parent::addParameter("pageUpLink","javascript:void(0);");
				parent::addParameter("pageUpTitle","-");
				parent::addParameter("pageUpStyle"," style='display:none;'");
				parent::addParameter("pagUpImage","/images/no-pic.jpg");
			}
			if($pagDID != ""){
				parent::addParameter("pageDownLink",$this->htLink2."-".$pagDID.".html");
				parent::addParameter("pageDownTitle",$pagDTitle);
				parent::addParameter("pageDownStyle","");
				if(trim($pagDImage) == "" || !file_exists(".".$pagDImage)){
					parent::addParameter("pagDownImage","/images/no-pic.jpg");
				}else{
					parent::addParameter("pagDownImage",$pagDImage);
				}
			}else{
				parent::addParameter("pageDownLink","javascript:void(0);");
				parent::addParameter("pageDownTitle","-");
				parent::addParameter("pageDownStyle"," style='display:none;'");
				parent::addParameter("pagDownImage","/images/no-pic.jpg");
			}

			//父類方法
			parent::loadData();
		}
	}

	$page = new _newsdetail();
	$page->load();
	$page->render();
?>