<?php
	require_once "../mobile/pageBase.php";
	require_once "../dal/categoryDAL.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/productDAL.php";
	class _products extends pageBase
	{
		public $CategoryID;
		public $pageSize;
		public $pageIndex=1;
		public $rowCount;
		public $page;

		public function load()
		{
			$this->CategoryID = parent::getPageParameter("id","0");
			$this->loadData();
			parent::load();
		}

		public function loadData()
		{
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/products.html");

			//產品分類列表
			$catetxt = "";
			$dalCate1 = new categoryDAL();
			$filter = "Visible='1' AND ParentID='0'";
			$dataCate1 = $dalCate1->executeRecordset2($filter);
			for($i=0;$i<count($dataCate1);$i++){
				$catetxt .= "<li>";
				$filter = "a.Visible='1' AND a.ParentID='".$dataCate1[$i]["CategoryID"]."'";
				$cateCount = $dalCate1->countRecordset($filter);
				if($cateCount == 0){
					$catetxt .= "<a href=\"products".$dataCate1[$i]["CategoryID"]."_1.html\">".$dataCate1[$i]["Name"]."</a>";
				}else{
					$catetxt .= $dataCate1[$i]["Name"];
					$catetxt .= "<ul>";
					$filter = "Visible='1' AND ParentID='".$dataCate1[$i]["CategoryID"]."'";
					$dataCate2 = $dalCate1->executeRecordset2($filter);
					for($j=0;$j<count($dataCate2);$j++){
						$catetxt .= "<li><a href=\"products".$dataCate2[$j]["CategoryID"]."_1.html\">".$dataCate2[$j]["Name"]."</a></li>";
					}
					$catetxt .= "</ul>";
				}
				$catetxt .= "</li>";
			}
			parent::addParameter("catetxt",$catetxt);

			//產品列表
			if(isset($this->CategoryID) && $this->CategoryID != "" && $this->CategoryID != "0"){
				//頁面內容
				$prolist =new productDAL();
				$filter ="a.Visible='1' AND a.CategoryID='".$_GET["id"]."'";
				$orderExp = "a.OrderNO DESC";

				$this->rowCount =$prolist->countRecordset($filter);
				$this->pageSize =10;
				$this->pageIndex=isset($_GET["p"])?$_GET["p"]:1;
				$data =$prolist->executeRecordset($filter,$orderExp,($this->pageIndex-1)*$this->pageSize,$this->pageSize);
				
				$list =new repeater();
				$list->id ="list";
				$list->dataSource =$data;
				parent::addControl($list);
			
				//分頁導航
				$nm1 = $this->rowCount % $this->pageSize;
				$nm2 = ($this->rowCount - $nm1) / $this->pageSize;
				if($nm1 > 0)
					$nm2 = $nm2 + 1;
				$nm3 = $this->pageIndex % 9;
				$nm4 = ($this->pageIndex - $nm3) / 9;
				if($nm3 == 0)
					$nm4 = $nm4 - 1;
				$pagtxt = "<div class=\"page_1\"><a href=\"products".$this->cid."_";
				if($this->pageIndex == 1)
					$pagtxt .= "1";
				else
					$pagtxt .= ($this->pageIndex - 1);
				$pagtxt .= ".html\">&lt;</a></div>";
				for($i=1;$i<10;$i++){
					if($nm4 * 9 + $i == $this->pageIndex)
						$pagtxt .= "<div class=\"page_1\">".($nm4 * 9 + $i)."</div>";
					else
						$pagtxt .= "<div class=\"page_1\"><a href=\"products".$this->cid."_".($nm4 * 9 + $i).".html\">".($nm4 * 9 + $i)."</a></div>";
					if($nm4 * 9 + $i == $nm2)
						$i = 11;
				}
				$pagtxt .= "<div class=\"page_1\"><a href=\"products".$this->cid."_";
				if($this->pageIndex == $nm2)
					$pagtxt .= $this->pageIndex;
				else
					$pagtxt .= ($this->pageIndex + 1);
				$pagtxt .= ".html\">&gt;</a></div>";
				if($this->rowCount > 0)
					$this->addParameter("pagtxt",$pagtxt);
			}else{
				//頁面內容
				$prolist =new productDAL();
				$filter ="a.Visible='1'";
				$orderExp = "a.OrderNO DESC";

				$this->rowCount =$prolist->countRecordset($filter);
				$this->pageSize =10;
				$this->pageIndex=isset($_GET["p"])?$_GET["p"]:1;
				$data =$prolist->executeRecordset($filter,$orderExp,($this->pageIndex-1)*$this->pageSize,$this->pageSize);
				
				$list =new repeater();
				$list->id ="list";
				$list->dataSource =$data;
				parent::addControl($list);

				//分頁導航
				$nm1 = $this->rowCount % $this->pageSize;
				$nm2 = ($this->rowCount - $nm1) / $this->pageSize;
				if($nm1 > 0)
					$nm2 = $nm2 + 1;
				$nm3 = $this->pageIndex % 9;
				$nm4 = ($this->pageIndex - $nm3) / 9;
				if($nm3 == 0)
					$nm4 = $nm4 - 1;
				$pagtxt = "<div class=\"page_1\"><a href=\"products_";
				if($this->pageIndex == 1)
					$pagtxt .= "1";
				else
					$pagtxt .= ($this->pageIndex - 1);
				$pagtxt .= ".html\">&lt;</a></div>";
				for($i=1;$i<10;$i++){
					if($nm4 * 9 + $i == $this->pageIndex)
						$pagtxt .= "<div class=\"page_1\">".($nm4 * 9 + $i)."</div>";
					else
						$pagtxt .= "<div class=\"page_1\"><a href=\"products_".($nm4 * 9 + $i).".html\">".($nm4 * 9 + $i)."</a></div>";
					if($nm4 * 9 + $i == $nm2)
						$i = 11;
				}
				$pagtxt .= "<div class=\"page_1\"><a href=\"products_";
				if($this->pageIndex == $nm2)
					$pagtxt .= $this->pageIndex;
				else
					$pagtxt .= ($this->pageIndex + 1);
				$pagtxt .= ".html\">&gt;</a></div>";
				if($this->rowCount > 0)
					$this->addParameter("pagtxt",$pagtxt);
			}

			//網站標題
			if(isset($dal->WebTitle) && $dal->WebTitle != "")
				parent::addParameter("webTitle",$dal->WebTitle);

			//網站關鍵字
			if(isset($dal->WebKeyword) && $dal->WebKeyword != "")
				parent::addParameter("webKeyword",$dal->WebKeyword);

			//網站描述
			if(isset($dal->WebDescription) && $dal->WebDescription != "")
				parent::addParameter("webDescription",$dal->WebDescription);

			parent::loadData();
		}
	}

	$page=new _products();
	$page->load();
	$page->render();
?>