<?php
	require_once "../mobile/pageBase.php";
	require_once "../dal/newsDAL.php";
	require_once "../bin/web/repeater.php";
	class _news extends pageBase
	{
		public $pageSize;
		public $pageIndex=1;
		public $rowCount;

		public function load()
		{
			$this->loadData();

			parent::load();
		}
		public function loadData()
		{
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/news.html");
			
			//頁面內容
			$newslist =new newsDAL();
			$filter ="a.Visible='1' AND b.ParentID='1'";
			$orderExp ="b.OrderNO,a.PubTime DESC,a.OrderNO";
			$this->rowCount =$newslist->countRecordset($filter);
			$this->pageSize =10;
			$this->pageIndex=isset($_GET["p"])?$_GET["p"]:1;
			$data =$newslist->executeRecordset($filter,$orderExp,($this->pageIndex-1)*$this->pageSize,$this->pageSize);
			$data=$this->formatTime($data);

			$list =new repeater();
			$list->id ="list";
			$list->dataSource =$data;
			parent::addControl($list);

			//分頁導航
			$nm1 = $this->rowCount % $this->pageSize;
			$nm2 = ($this->rowCount - $nm1) / $this->pageSize;
			if($nm1 > 0)
				$nm2 = $nm2 + 1;
			$nm3 = $this->pageIndex % 9;
			$nm4 = ($this->pageIndex - $nm3) / 9;
			if($nm3 == 0)
				$nm4 = $nm4 - 1;
			$pagtxt = "<div class=\"page_1\"><a href=\"news_";
			if($this->pageIndex == 1)
				$pagtxt .= "1";
			else
				$pagtxt .= ($this->pageIndex - 1);
			$pagtxt .= ".html\">&lt;</a></div>";
			for($i=1;$i<10;$i++){
				if($nm4 * 9 + $i == $this->pageIndex)
					$pagtxt .= "<div class=\"page_1\">".($nm4 * 9 + $i)."</div>";
				else
					$pagtxt .= "<div class=\"page_1\"><a href=\"news_".($nm4 * 9 + $i).".html\">".($nm4 * 9 + $i)."</a></div>";
				if($nm4 * 9 + $i == $nm2)
					$i = 11;
			}
			$pagtxt .= "<div class=\"page_1\"><a href=\"news_";
			if($this->pageIndex == $nm2)
				$pagtxt .= $this->pageIndex;
			else
				$pagtxt .= ($this->pageIndex + 1);
			$pagtxt .= ".html\">&gt;</a></div>";
			if($this->rowCount > 0)
				$this->addParameter("pagtxt",$pagtxt);

			//父類方法蘋果也界有限公司
			parent::loadData();
		}
		private function formatTime($data)
		{
			for($i=0;$i<count($data);$i++)
				$data[$i]["PubTime"]= date("Y-m-d",strtotime($data[$i]["PubTime"]));
			return $data;
		}
	}
	$page=new _news();
	$page->load();
	$page->render();
?>