<?php
	require_once "../mobile/pageBase.php";
	require_once "../dal/newsDAL.php";
	class _newsdetail extends pageBase
	{
		private $id;
		public function load()
		{
			$this->id=parent::getPageParameter("id","0");
			$this->loadData();
			parent::load();
		}
		public function loadData()
		{
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/news-detail.html");

			//頁面內容
			$news=new newsDAL();
			$news->PathName=$this->id;
			$news->loadRecord();
			parent::addParameter("Title",$news->Title);
			parent::addParameter("Content",$news->Content);
			parent::addParameter("PubTime",date("Y-m-d",strtotime($news->PubTime)));

			//網站標題
			if(isset($news->WebTitle) && $news->WebTitle != "")
				parent::addParameter("webTitle",$news->WebTitle);

			//網站關鍵字
			if(isset($news->WebKeyword) && $news->WebKeyword != "")
				parent::addParameter("webKeyword",$news->WebKeyword);

			//網站描述
			if(isset($news->WebDescription) && $news->WebDescription != "")
				parent::addParameter("webDescription",$news->WebDescription);

			//父類方法蘋果也界有限公司
			parent::loadData();
		}
	}

	$page=new _newsdetail();
	$page->load();
	$page->render();
?>