<?php
	require_once "../mobile/pageBase.php";
	require_once "../dal/articleDAL.php";
	class _about extends pageBase
	{
		public function load()
		{
			$this->loadData();

			parent::load();
		}
		public function loadData()
		{
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/about.html");

			//頁面內容
			$about = new articleDAL();
			$filter = "a.Visible='1'";
			$num = $about->countRecordset($filter);
			if($num > 0)
			{
				$orderExp = "a.OrderNO";
				$data = $about->executeRecordset($filter,$orderExp,0,1);

				parent::addParameter("aboutTitle",$data[0]["Title"]);
				parent::addParameter("aboutContent",$data[0]["Content"]);
			}
			else
			{
				parent::addParameter("aboutTitle","關於我們");
				parent::addParameter("aboutContent","暫無資料");
			}

			//網站標題
			if(isset($about->WebTitle) && $about->WebTitle != "")
				parent::addParameter("webTitle",$about->WebTitle);

			//網站關鍵字
			if(isset($about->WebKeyword) && $about->WebKeyword != "")
				parent::addParameter("webKeyword",$about->WebKeyword);

			//網站描述
			if(isset($about->WebDescription) && $about->WebDescription != "")
				parent::addParameter("webDescription",$about->WebDescription);

			//父類方法
			parent::loadData();
		}
	}

	$page = new _about();
	$page->load();
	$page->render();
?>