<?php
	require_once "pageBase.php";
	require_once "bin/system/conver.php";
	require_once "bin/web/repeater.php";
	require_once "dal/pictureDAL.php";
	require_once "dal/customerDAL.php";
	require_once "bin/system/email.php";
	require_once "bin/system/smtp_mail.php";

	class _memberlogin extends pageBase{
		public function load(){
			if(!parent::isPostBack())
	 			$this->loadData();
 			else
 				$this->saveData();
			
			parent::load();
		}
		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/member.html");
			
			//橫幅廣告
			$this->picturetype = "100";			

			parent::addParameter("CustomerID",$_SESSION["CustomerID"]);
			parent::addParameter("FacebookID",$_SESSION["FacebookID"]);
			parent::addParameter("FacebookEmail",$_SESSION["LoginName"]);
			parent::addParameter("FacebookName",$_SESSION["CustomerName"]);

			//父類方法
			parent::loadData();
		}
		
		public function saveData(){
			$dal = new customerDAL();
			$CustomerID = conver::toDbString(trim($_POST["CustomerID"]));
			$LoginName = conver::toDbString(trim($_POST["LoginName"]));
			$FacebookID = conver::toDbString(trim($_POST["FacebookID"]));
			$CustomerName = conver::toDbString(trim($_POST["CustomerName"]));
			$Mobile = conver::toDbString(trim($_POST["Mobile"]));
			$LineID = conver::toDbString(trim($_POST["LineID"]));
			$Checknum = conver::toDbString(trim($_POST["Checknum"]));
			
			$errorTxt = 'Không đúng!\r\n';
			$reMail = "/^[A-Za-z0-9\-_\.]+@[A-Za-z0-9\-_]+(\.[A-Za-z0-9\-_]+)+$/";
			if(!preg_match($reMail, $LoginName)){
				$newmemberBack = "Y";
				$errorTxt .= 'Địa chỉ email bị sai!\r\n';
			}else{
				if($dal->countRecordset("a.`LoginName`='".$LoginName."'") > 0){
					$newmemberBack = "Y";
					$errorTxt .= '「'.$LoginName.'」Đã từng đăng ký!\r\n';
				}
			}
			$reMobile = "/^09[0-9]{8}$/";
			if(!preg_match($reMobile,$Mobile)){
				$newmemberBack = "Y";
				$errorTxt .= 'Số điện thoại di động không đúng!\r\n';
			}
			if($Checknum == "" || !isset($_SESSION["dd_ckstr"]) || $Checknum != $_SESSION["dd_ckstr"]){
				$newmemberBack = "Y";
				$errorTxt .= 'Mã xác nhận không đúng!\r\n';
			}
			
			if($newmemberBack == "Y"){
				parent::alert2($errorTxt,"member.html");
				exit;
			}else{
				if($CustomerID != "" && $CustomerID != "0"){
					$dal->CustomerID = $CustomerID;
					$dal->loadRecord();
				}
				$dal->CustomerLevel = "0";
				$dal->LoginName = $LoginName;
				$dal->FacebookID = $FacebookID;
				$dal->CustomerName = $CustomerName;
				$dal->Mobile = $Mobile;
				$dal->LineID = $LineID;
				if(!empty($_SERVER["HTTP_CLIENT_IP"])){
					$ip = $_SERVER["HTTP_CLIENT_IP"];
				}else if(!empty($_SERVER["HTTP_X_FORWARDED_FOR"])){
					$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
				}else{
					$ip = $_SERVER["REMOTE_ADDR"];
				}
				$dal->CreatedIP = $ip;
				
				if($CustomerID != "" && $CustomerID != "0"){
					$dal->updateRecord();
					$customerID = $dal->CustomerID;
				}else{
					$customerID = $dal->insertRecord();
					
					//系統信件內容
					$mailtxt = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
					$mailtxt .= '<html xmlns="http://www.w3.org/1999/xhtml">';
					$mailtxt .= '<head>';
					$mailtxt .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
					$mailtxt .= '</head>';
					$mailtxt .= '<body>';
					$mailtxt .= '<table border="1" align="center" cellpadding="0" cellspacing="0" style="width:660px; border:1px #000 solid;">';
					$mailtxt .= '<tr>';
					$mailtxt .= '<td colspan="2" style="border:0; border-bottom:1px #ccc solid; text-align:center;"><img src="';
					if($dalP->Image == ''){
						$mailtxt .= '';
					}else{
						$mailtxt .= 'http://'.$_SERVER["HTTP_HOST"].$dalP->Image;
					}
					$mailtxt .= '" style="margin:30px;" /></td>';
					$mailtxt .= '</tr>';
					$mailtxt .= '<tr style="background:#E7E7E7;">';
					$mailtxt .= '<td colspan="2" style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
					$mailtxt .= '親愛的會員「'.$dal->CustomerName.'」您好<br />';
					$mailtxt .= '您已經在「<a href="http://'.$_SERVER["HTTP_HOST"].'">'.$this->registry->webName.'</a>」中使用Facebook登入成功!!!<br /><br />';
					$mailtxt .= '</td>';
					$mailtxt .= '</tr>';
					$mailtxt .= '<tr>';
					$mailtxt .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
					$mailtxt .= '<br />會員帳號：<br />';
					$mailtxt .= '</td>';
					$mailtxt .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
					$mailtxt .= '<br />'.$dal->LoginName.'<br />';
					$mailtxt .= '</td>';
					$mailtxt .= '</tr>';
					$mailtxt .= '<tr style="background:#E7E7E7;">';
					$mailtxt .= '<td style="width:200px; border:0; border-bottom:1px #ccc solid; text-align:center;">';
					$mailtxt .= '<br />您的Facebook名稱為：<br />';
					$mailtxt .= '</td>';
					$mailtxt .= '<td style="width:400px; border:0; border-bottom:1px #ccc solid;">';
					$mailtxt .= '<br />'.$dal->CustomerName.'<br />';
					$mailtxt .= '</td>';
					$mailtxt .= '</tr>';
					$mailtxt .= '</table><br />';
					$mailtxt .= '<p style="padding:10px;">如果您並未在本網站註冊，請來信到我們的客服信箱「<a href="mailto:'.$this->registry->webEmail.'">'.$this->registry->webEmail.'</a>」</p>';
					$mailtxt .= '<p style="padding:10px; color:#f00; font-weight:bolder;">此信件為系統自動發送!請勿直接回覆!</p>';
					$mailtxt .= '</body>';
					$mailtxt .= '</html>';
					
					if($this->registry->sendMailType == ""){
						$email = new email();
						$email->fromAddress = "=?UTF-8?B?".base64_encode($this->registry->webName)."?=<".$this->registry->webEmail.">";
						$email->replyToAddress = "=?UTF-8?B?".base64_encode($dal->CustomerName)."?=<".$dal->LoginName.">";
						$email->subject = "[".$_SERVER['HTTP_HOST']."][會員註冊通知信]";
						$email->content = $mailtxt;
						$email->toAddress = $dal->LoginName;
						$email->send();
					}else{
						$toAry = array();
						$toAry[] = $dal->LoginName;
						$smtp_mail = new smtp_mail();
						$smtp_mail->toAry = $toAry;
						$smtp_mail->name = "=?UTF-8?B?".base64_encode($this->registry->webName)."?=";
						$smtp_mail->subject = "[".$_SERVER['HTTP_HOST']."][會員註冊通知信]";
						$smtp_mail->body = $mailtxt;
						$smtp_mail->send();
					}
				}
				$_SESSION["CustomerID"] = $customerID;
				$_SESSION["CustomerLevel"] = $dal->CustomerLevel;
				$_SESSION["LoginName"] = $dal->LoginName;
				$_SESSION["CustomerName"] = $dal->CustomerName;
				$_SESSION["FacebookID"] = $dal->FacebookID;
			}
		}
	}

	$page = new _memberlogin();
	$page->load();
	$page->render();
?>