<?php
	header("Access-Control-Allow-Origin: *");
	require_once "pageBase.php";
	require_once "bin/web/repeater.php";
	require_once "dal/articleDAL.php";
	require_once "dal/pictureDAL.php";

	class _article extends pageBase{
		private $path;
		public function load(){
			$this->path = parent::getPageParameter("path","");
			$this->loadData();

			parent::load();
		}
		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/jump.html");
			
			//橫幅廣告
			$this->picturetype = "40";

			//宣告
			$dal = new articleDAL();

			//沒有指定文章時，取得第一篇文章
			if($this->path == ""){
				$data = $dal->executeRecordset("a.`Visible`='1' AND b.`Visible`='1'","b.`OrderNO`,a.`OrderNO`",0,1);
				if(count($data) == 1){
					$this->path = $data[0]["PathName"];
				}
			}
			$dal->PathName = $this->path;
			$dal->loadRecord();
			if($dal->Visible == "1"){
				parent::addParameter("CategoryName",$dal->CategoryName);
				parent::addParameter("Title",$dal->Title);
				parent::addParameter("PathName",$dal->PathName);
				parent::addParameter("Description",$dal->Description);
				if(trim($dal->Image) == "" || !file_exists(".".$dal->Image)){
					parent::addParameter("Image",$this->NoPicImage);
					$imgStyle = "display:none;";
				}else{
					parent::addParameter("Image",$dal->Image);
					$imgStyle = "";
				}
				if($dal->Structure == "2"){
					$imgStyle .= "float:right;";
				}else{
					$imgStyle .= "float:left;";
				}
				parent::addParameter("imgStyle",$imgStyle);
				if(trim($dal->WebTitle) != ""){
					parent::addParameter("webTitle",$dal->WebTitle);
				}
				if(trim($dal->WebKeyword) != ""){
					parent::addParameter("webKeyword",$dal->WebKeyword);
				}
				if(trim($dal->WebDescription) != ""){
					parent::addParameter("webDescription",$dal->WebDescription);
				}
			}else{
				parent::alert2("文章不存在!!","/");
			}

			//同分類文章列表
			$dataA = $dal->executeRecordset("a.`CategoryID`='".$dal->CategoryID."' AND a.`Visible`='1'","a.`OrderNO`");
			for($i=0;$i<count($dataA);$i++){
				$dataA[$i]["htLink"] = $this->htLink1;
				if($dataA[$i]["PathName"] == $this->path){
					$dataA[$i]["className"] = " class='action'";
				}
				$dataA[$i]["sTitle"] = string::cut_str($dataA[$i]["Title"],"5");
			}
			$listA = new repeater();
			$listA->id = "listA";
			$listA->dataSource = $dataA;
			parent::addControl($listA);

			//父類方法
			parent::loadData();
		}
	}

	$page = new _article();
	$page->load();
	$page->render();
?>