<?php
	require_once "pageBase.php";
	require_once "bin/system/string.php";
	require_once "bin/web/repeater.php";
	require_once "dal/bookDAL.php";
	require_once "dal/newsDAL.php";
	require_once "dal/pictureDAL.php";
	require_once "dal/productDAL.php";
	require_once "dal/faqDAL.php";
	class _index extends pageBase{
		public function load(){
			$this->loadData();
			parent::load();
		}

		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/index.html");
			parent::addParameter("htLink1",$this->htLink1);
			parent::addParameter("htLink2",$this->htLink2);
			parent::addParameter("htLink3",$this->htLink3);
			if($this->registry->indexListType == "20"){
				parent::addParameter("htLink4",$this->htLink5);
			}else{
				parent::addParameter("htLink4",$this->htLink4);
			}
			parent::addParameter("htLink6",$this->htLink6);
			parent::addParameter("htLink7",$this->htLink7);
			parent::addParameter("webPhone",$this->registry->webPhone);

			//設定header參數
			$this->is_index = true;
			$this->picturetype = 30;
			
			////logo
			$dalP = new pictureDAL();
			$dalP->PictureType = "10";
			$dalP->TypeOrderNO = "0";
			$dalP->loadRecord();
			if(trim($dalP->Image) == ''){
				parent::addParameter("logoImage",$this->NoPicImage);
				parent::addParameter("logoStyle"," style='display:none; width: auto;'");
			}else{
				if(file_exists(".".$dalP->Image)){
					parent::addParameter("logoImage",$dalP->Image);
					parent::addParameter("logoStyle","");
				}else{
					parent::addParameter("logoImage",$this->NoPicImage);
					parent::addParameter("logoStyle"," style='display:none; width: auto;'");
				}
			}
			if(trim($dalP->Title) == ''){
				parent::addParameter("logoTitle",$this->registry->webName);
			}else{
				parent::addParameter("logoTitle",$dalP->Title);
			}
			parent::addParameter("logoLink",$dalP->Link);

			//最新消息
			$dalN = new newsDAL();
			//最新消息筆數
			$newLength = 0;
			if($this->registry->webTemplates == "16"){
				$newLength = 3;
			}else if($this->registry->webTemplates == "17"){
				$newLength = 2;
			}else if($this->registry->webTemplates == "25"){
				$newLength = 7;
			}else if($this->registry->webTemplates == "31"){
				$newLength = 4;
			}else{
				$newLength = 20;
			}
			$dataN = $dalN->executeRecordset("a.`Visible`='1' AND a.`OnlineTime`<='".date("Y-m-d H:i:s")."'","",0,$newLength);
			for($i=0;$i<count($dataN);$i++){
				if(trim($dataN[$i]["Image"]) == "" || !file_exists(".".$dataN[$i]["Image"])){
					$dataN[$i]["Image"] = $this->NoPicImage;
				}else{
					$dataN[$i]["imageStyle"] = "";
				}
				$dataN[$i]["sTitle"] = string::cut_str($dataN[$i]["Title"],"15");
				$dataN[$i]["sIntroduction"] = string::cut_str($dataN[$i]["Introduction"],"50");
				$dataN[$i]["OnlineDate"] = date("Y-m-d",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["OnlineDY"] = date("Y",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["OnlineDM"] = date("m",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["OnlineDD"] = date("d",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["OnlineDM2"] = date("M",strtotime($dataN[$i]["OnlineTime"]));
				$dataN[$i]["htLink"] = $this->htLink2;
			}
			$listN = new repeater();
			$listN->id = "listN";
			$listN->dataSource = $dataN;
			parent::addControl($listN);
			
			//常見問題
			$dalfaq = new faqDAL();
			$datafaq = $dalfaq->executeRecordset("a.`Visible`='1'","RAND()",0,5);
			for($i=0;$i<count($datafaq);$i++){
				$datafaq[$i]["htLink"] = $this->htLink3;
				$datafaq[$i]["Title"] = string::cut_str($datafaq[$i]["Title"],"25");
			}
			$listfaq = new repeater();
			$listfaq->id = "listfaq";
			$listfaq->dataSource = $datafaq;
			parent::addControl($listfaq);

			//自訂欄位
			parent::addParameter("customTitle1",$this->registry->indexCustomTitle1);
			$customContent1 = $this->registry->indexCustomContent1;
			$customContent1 = str_replace("\r\n","<br />",$customContent1);
			parent::addParameter("customContent1",$customContent1);
			parent::addParameter("customTitle2",$this->registry->indexCustomTitle2);
			$customContent2 = $this->registry->indexCustomContent2;
			$customContent2 = str_replace("\r\n","<br />",$customContent2);
			parent::addParameter("customContent2",$customContent2);
			parent::addParameter("customTitle3",$this->registry->indexCustomTitle3);
			$customContent3 = $this->registry->indexCustomContent3;
			$customContent3 = str_replace("\r\n","<br />",$customContent3);
			parent::addParameter("customContent3",$customContent3);

			//Google MAP
			if($this->registry->googlemapIndex == "1" && trim($this->registry->googlemapAddress) != ""){
				parent::addParameter("googlemapStyle","");
				parent::addParameter("googlemapAddress",urlencode($this->registry->googlemapAddress));
			}else{
				parent::addParameter("googlemapStyle"," style='display:none;'");
				parent::addParameter("googlemapAddress","");
			}

			//關於我們
			$aboutIntroduction = $this->registry->indexAboutIntroduction;
			$aboutIntroduction = str_replace("\r\n","<br />",$aboutIntroduction);
			parent::addParameter("aboutIntroduction",$aboutIntroduction);
			if(trim($this->registry->indexAboutImage) == "" || !file_exists(".".$this->registry->indexAboutImage)){
				parent::addParameter("aboutImageStyle"," style='display:none;'");
				parent::addParameter("aboutImage",$this->NoPicImage);
			}else{
				parent::addParameter("aboutImageStyle","");
				parent::addParameter("aboutImage",$this->registry->indexAboutImage);
			}
			if(trim($this->registry->indexAboutLink) == ""){
				parent::addParameter("aboutLink","javascript:void(0);");
			}else{
				parent::addParameter("aboutLink",$this->registry->indexAboutLink);
			}

			//Youbtube
			if(trim($this->registry->youtubeURL) == ""){
				parent::addParameter("youtubeStyle"," style='display:none;'");
				parent::addParameter("youtubeURL","");
			}else{
				parent::addParameter("youtubeStyle","");
				$youtubeURL = str_replace("//youtu.be/","//www.youtube.com/embed/",$this->registry->youtubeURL);
				parent::addParameter("youtubeURL",$youtubeURL);
			}

			//臉書粉絲團
			if(trim($this->registry->fbFansURL) != ''){
				if($this->registry->fbFansFriendFace == '0'){
					$facepile = 'false';
				}else{
					$facepile = 'true';
				}
				if($this->registry->fbFansCoverPhoto == '1'){
					$hidecover = 'false';
				}else{
					$hidecover = 'true';
				}
				if($this->registry->fbFansPagePost == '0'){
					$showpost = 'false';
				}else{
					$showpost = 'true';
				}
				$fbFans = '<div class="fb-page" data-href="'.$this->registry->fbFansURL.'"  data-width="1200" data-adapt-container-width="true" data-hide-cover="'.$hidecover.'" data-show-facepile="'.$facepile.'" data-show-posts="'.$showpost.'"><div class="fb-xfbml-parse-ignore"><blockquote cite="'.$this->registry->fbFansURL.'"><a href="'.$this->registry->fbFansURL.'">Facebook</a></blockquote></div></div>';
			}else{
				$fbFans = '';
			}
			parent::addParameter("fbFans",$fbFans);

			//LINE QRCode
			parent::addParameter("lineTitle",$this->registry->lineTitle);
			if(trim($this->registry->lineQRCode) == "" || !file_exists(".".$this->registry->lineQRCode)){
				parent::addParameter("QRstyle","display:none;");
				parent::addParameter("lineQRCode",$this->NoPicImage);
			}else{
				parent::addParameter("QRstyle","");
				parent::addParameter("lineQRCode",$this->registry->lineQRCode);
			}

			//小廣告圖
			$aryPT = array();
			$dalPT = new pictureDAL();
			$dataPT = $dalPT->executeRecordset("a.`PictureType`='120'","a.`TypeOrderNO`");
			for($i=0;$i<count($dataPT);$i++){
				if(trim($dataPT[$i]["Image"]) != "" && file_exists(".".$dataPT[$i]["Image"])){
					$ary = array();
					$ary["Image"] = $dataPT[$i]["Image"];
					$ary["Title"] = $dataPT[$i]["Title"];
					if(trim($dataPT[$i]["Link"]) == ""){
						$ary["Link"] = "javascript:void(0);";
					}else{
						$ary["Link"] = $dataPT[$i]["Link"];
					}
					$aryPT[] = $ary;
					parent::addParameter("small_picture_".$i."_image", $ary["Image"]);
					parent::addParameter("small_picture_".$i."_title", $ary["Title"]);
					parent::addParameter("small_picture_".$i."_link", $ary["Link"]);
				}
			}
			$listPT = new repeater();
			$listPT->id = "listPT";
			$listPT->dataSource = $aryPT;
			parent::addControl($listPT);

			//推薦產品/相本
			$aryPB = array();
			$dalP = new productDAL();
			$dalB = new bookDAL();
			if($this->registry->indexListType == "20"){
				$dataB = $dalB->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,3);
				for($i=0;$i<count($dataB);$i++){
					$ary = array();
					$ary["ID"] = $dataB[$i]["BookID"];
					$ary["Name"] = $dataB[$i]["BookName"];
					if(trim($dataB[$i]["Image"]) == "" || !file_exists(".".$dataB[$i]["Image"])){
						$ary["Image"] = $this->NoPicImage;
					}else{
						$ary["Image"] = $dataB[$i]["Image"];
					}
					$ary["Introduction"] = string::cut_str($dataB[$i]["Description"],"70");
					$ary["sName"] =  string::cut_str($dataB[$i]["ProductName"],"9");
					$ary["htLink"] = $this->htLink5;
					$ary["Price"] = "";
					$ary["OldPrice"] = "";
					$ary["priceStyle"] = " style='display:none;'";
					$ary["oldPriceStyle"] = " style='display:none;'";
					$aryPB[] = $ary;
				}
				//版3-相本(抓4筆) - id = "listPB2"
				$dataB2 = $dalB->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,4);
				for($i=0;$i<count($dataB2);$i++){
					$ary2 = array();
					$ary2["ID"] = $dataB2[$i]["BookID"];
					$ary2["Name"] = $dataB2[$i]["BookName"];
					$ary2["sName"] = string::cut_str($dataB2[$i]["BookName"],"9");
					if(trim($dataB2[$i]["Image"]) == "" || !file_exists(".".$dataB2[$i]["Image"])){
						$ary2["Image"] = $this->NoPicImage;
					}else{
						$ary2["Image"] = $dataB2[$i]["Image"];
					}
					$ary2["Introduction"] = string::cut_str($dataB2[$i]["Description"],"30");
					$ary2["htLink"] = $this->htLink5;
					$ary2["Price"] = "";
					$ary2["OldPrice"] = "";
					$ary2["priceStyle"] = " style='display:none;'";
					$ary2["oldPriceStyle"] = " style='display:none;'";
					$aryPB2[] = $ary2;
				}
				//版4-相本(抓6筆) - id = "listPB3"
				$dataB3 = $dalB->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,6);
				for($i=0;$i<count($dataB3);$i++){
					$ary3 = array();
					$ary3["ID"] = $dataB3[$i]["BookID"];
					$ary3["Name"] = $dataB3[$i]["BookName"];
					$ary3["sName"] = string::cut_str($dataB3[$i]["BookName"],"9");
					if(trim($dataB3[$i]["Image"]) == "" || !file_exists(".".$dataB3[$i]["Image"])){
						$ary3["Image"] = $this->NoPicImage;
					}else{
						$ary3["Image"] = $dataB3[$i]["Image"];
					}
					$ary3["Introduction"] = string::cut_str($dataB3[$i]["Description"],"30");
					$ary3["htLink"] = $this->htLink5;
					$ary3["Price"] = "";
					$ary3["OldPrice"] = "";
					$ary3["priceStyle"] = " style='display:none;'";
					$ary3["oldPriceStyle"] = " style='display:none;'";
					$aryPB3[] = $ary3;
				}
				//版1-推薦產品(抓5筆) - id = "listPB4"
				$dataB4 = $dalB->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,5);
				for($i=0;$i<count($dataB4);$i++){
					$ary4 = array();
					$ary4["ID"] = $dataB4[$i]["BookID"];
					$ary4["Name"] = $dataB4[$i]["BookName"];
					$ary4["sName"] = string::cut_str($dataB4[$i]["BookName"],"9");
					if(trim($dataB4[$i]["Image"]) == "" || !file_exists(".".$dataB4[$i]["Image"])){
						$ary4["Image"] = $this->NoPicImage;
					}else{
						$ary4["Image"] = $dataB4[$i]["Image"];
					}
					$ary4["Introduction"] = string::cut_str($dataB4[$i]["Description"],"30");
					$ary4["htLink"] = $this->htLink5;
					$ary4["Price"] = "";
					$ary4["OldPrice"] = "";
					$ary4["priceStyle"] = " style='display:none;'";
					$ary4["oldPriceStyle"] = " style='display:none;'";
					$aryPB4[] = $ary4;
				}
				//版10-推薦產品(抓8筆) - id = "listPB5"
				$dataB5 = $dalB->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,8);
				for($i=0;$i<count($dataB5);$i++){
					$ary5 = array();
					$ary5["ID"] = $dataB5[$i]["BookID"];
					$ary5["Name"] = $dataB5[$i]["BookName"];
					$ary5["sName"] = string::cut_str($dataB5[$i]["BookName"],"9");
					if(trim($dataB5[$i]["Image"]) == "" || !file_exists(".".$dataB5[$i]["Image"])){
						$ary5["Image"] = $this->NoPicImage;
					}else{
						$ary5["Image"] = $dataB5[$i]["Image"];
					}
					$ary5["Introduction"] = string::cut_str($dataB5[$i]["Description"],"30");
					$ary5["htLink"] = $this->htLink5;
					$ary5["Price"] = "";
					$ary5["OldPrice"] = "";
					$ary5["priceStyle"] = " style='display:none;'";
					$ary5["oldPriceStyle"] = " style='display:none;'";
					$aryPB5[] = $ary5;
				}
				//版17-推薦相本(抓1筆) - id = "listPB6"
				$dataB6 = $dalB->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,1);
				for($i=0;$i<count($dataB6);$i++){
					$ary6 = array();
					$ary6["ID"] = $dataB6[$i]["BookID"];
					$ary6["Name"] = $dataB6[$i]["BookName"];
					$ary6["sName"] = string::cut_str($dataB6[$i]["BookName"],"9");
					if(trim($dataB5[$i]["Image"]) == "" || !file_exists(".".$dataB6[$i]["Image"])){
						$ary6["Image"] = $this->NoPicImage;
					}else{
						$ary6["Image"] = $dataB6[$i]["Image"];
					}
					$ary6["Introduction"] = string::cut_str($dataB6[$i]["Description"],"30");
					$ary6["htLink"] = $this->htLink5;
					$ary6["Price"] = "";
					$ary6["OldPrice"] = "";
					$ary6["priceStyle"] = " style='display:none;'";
					$ary6["oldPriceStyle"] = " style='display:none;'";
					$aryPB6[] = $ary6;
				}
				//版29-推薦相本(抓7筆) - id = "listPB7"
				$dataB7 = $dalB->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,7);
				for($i=0;$i<count($dataB7);$i++){
					$ary7 = array();
					$ary7["ID"] = $dataB7[$i]["BookID"];
					$ary7["Name"] = $dataB7[$i]["BookName"];
					$ary7["sName"] = string::cut_str($dataB7[$i]["BookName"],"9");
					if(trim($dataB5[$i]["Image"]) == "" || !file_exists(".".$dataB7[$i]["Image"])){
						$ary7["Image"] = $this->NoPicImage;
					}else{
						$ary7["Image"] = $dataB7[$i]["Image"];
					}
					$ary7["Introduction"] = string::cut_str($dataB7[$i]["Description"],"30");
					$ary7["htLink"] = $this->htLink5;
					$ary7["Price"] = "";
					$ary7["OldPrice"] = "";
					$ary7["priceStyle"] = " style='display:none;'";
					$ary7["oldPriceStyle"] = " style='display:none;'";
					$aryPB7[] = $ary7;
				}
			}else{
				$dataP = $dalP->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,3);
				for($i=0;$i<count($dataP);$i++){
					$ary = array();
					$ary["ID"] = $dataP[$i]["ProductID"];
					$ary["Name"] = $dataP[$i]["ProductName"];
					if(trim($dataP[$i]["IconImage"]) == "" || !file_exists(".".$dataP[$i]["IconImage"])){
						$ary["Image"] = $this->NoPicImage;
					}else{
						$ary["Image"] = $dataP[$i]["IconImage"];
					}
					$ary["Introduction"] = string::cut_str($dataP[$i]["Introduction"],"70");
					$ary["sName"] =  string::cut_str($dataP[$i]["ProductName"],"9");
					$ary["htLink"] = $this->htLink4;
					$ary["Price"] = $dataP[$i]["Price"];
					$ary["OldPrice"] = $dataP[$i]["OldPrice"];
					if($this->registry->webType == "20"){
						if($dataP[$i]["Price"] == "0" || $dataP[$i]["Price"] == ""){
							$ary["priceStyle"] = " style='display:none;'";
						}else{
							$ary["priceStyle"] = "";
						}
						if($dataP[$i]["OldPrice"] == "0" || $dataP[$i]["OldPrice"] == ""){
							$ary["oldPriceStyle"] = " style='display:none;'";
						}else{
							$ary["oldPriceStyle"] = "";
						}
					}else{
						$ary["priceStyle"] = " style='display:none;'";
						$ary["oldPriceStyle"] = " style='display:none;'";
					}
					$aryPB[] = $ary;
				}
				//版3-推薦產品(抓4筆) - id = "listPB2"
				$dataP2 = $dalP->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,4);
				for($i=0;$i<count($dataP2);$i++){
					$ary2 = array();
					$ary2["ID"] = $dataP2[$i]["ProductID"];
					$ary2["Name"] = $dataP2[$i]["ProductName"];
					$ary2["sName"] = string::cut_str($dataP2[$i]["ProductName"],"9");
					if(trim($dataP2[$i]["IconImage"]) == "" || !file_exists(".".$dataP2[$i]["IconImage"])){
						$ary2["Image"] = $this->NoPicImage;
					}else{
						$ary2["Image"] = $dataP2[$i]["IconImage"];
					}
					$ary2["Introduction"] = string::cut_str($dataP2[$i]["Introduction"],"30");
					$ary2["htLink"] = $this->htLink4;
					$ary2["Price"] = $dataP2[$i]["Price"];
					$ary2["OldPrice"] = $dataP2[$i]["OldPrice"];
					if($this->registry->webType == "20"){
						if($dataP2[$i]["Price"] == "0" || $dataP2[$i]["Price"] == ""){
							$ary2["priceStyle"] = " style='display:none;'";
						}else{
							$ary2["priceStyle"] = "";
						}
						if($dataP2[$i]["OldPrice"] == "0" || $dataP2[$i]["OldPrice"] == ""){
							$ary2["oldPriceStyle"] = " style='display:none;'";
						}else{
							$ary2["oldPriceStyle"] = "";
						}
					}else{
						$ary2["priceStyle"] = " style='display:none;'";
						$ary2["oldPriceStyle"] = " style='display:none;'";
					}
					$aryPB2[] = $ary2;
				}
				//版4-推薦產品(抓6筆) - id = "listPB3"
				$dataP3 = $dalP->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,6);
				for($i=0;$i<count($dataP3);$i++){
					$ary3 = array();
					$ary3["ID"] = $dataP3[$i]["ProductID"];
					$ary3["Name"] = $dataP3[$i]["ProductName"];
					$ary3["sName"] = string::cut_str($dataP3[$i]["ProductName"],"9");
					if(trim($dataP3[$i]["IconImage"]) == "" || !file_exists(".".$dataP3[$i]["IconImage"])){
						$ary3["Image"] = $this->NoPicImage;
					}else{
						$ary3["Image"] = $dataP3[$i]["IconImage"];
					}
					$ary3["Introduction"] = string::cut_str($dataP3[$i]["Introduction"],"30");
					$ary3["htLink"] = $this->htLink4;
					$ary3["Price"] = $dataP3[$i]["Price"];
					$ary3["OldPrice"] = $dataP3[$i]["OldPrice"];
					if($this->registry->webType == "20"){
						if($dataP3[$i]["Price"] == "0" || $dataP3[$i]["Price"] == ""){
							$ary3["priceStyle"] = " style='display:none;'";
						}else{
							$ary3["priceStyle"] = "";
						}
						if($dataP3[$i]["OldPrice"] == "0" || $dataP3[$i]["OldPrice"] == ""){
							$ary3["oldPriceStyle"] = " style='display:none;'";
						}else{
							$ary3["oldPriceStyle"] = "";
						}
					}else{
						$ary3["priceStyle"] = " style='display:none;'";
						$ary3["oldPriceStyle"] = " style='display:none;'";
					}
					$aryPB3[] = $ary3;
				}
				//版1-推薦產品(抓5筆) - id = "listPB4"
				$dataP4 = $dalP->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,5);
				for($i=0;$i<count($dataP4);$i++){
					$ary4 = array();
					$ary4["ID"] = $dataP4[$i]["ProductID"];
					$ary4["Name"] = $dataP4[$i]["ProductName"];
					$ary4["sName"] = string::cut_str($dataP4[$i]["ProductName"],"9");
					if(trim($dataP4[$i]["IconImage"]) == "" || !file_exists(".".$dataP4[$i]["IconImage"])){
						$ary4["Image"] = $this->NoPicImage;
					}else{
						$ary4["Image"] = $dataP4[$i]["IconImage"];
					}
					$ary4["Introduction"] = string::cut_str($dataP4[$i]["Introduction"],"30");
					$ary4["htLink"] = $this->htLink4;
					$ary4["Price"] = $dataP4[$i]["Price"];
					$ary4["OldPrice"] = $dataP4[$i]["OldPrice"];
					if($this->registry->webType == "20"){
						if($dataP4[$i]["Price"] == "0" || $dataP4[$i]["Price"] == ""){
							$ary4["priceStyle"] = " style='display:none;'";
						}else{
							$ary4["priceStyle"] = "";
						}
						if($dataP4[$i]["OldPrice"] == "0" || $dataP4[$i]["OldPrice"] == ""){
							$ary4["oldPriceStyle"] = " style='display:none;'";
						}else{
							$ary4["oldPriceStyle"] = "";
						}
					}else{
						$ary4["priceStyle"] = " style='display:none;'";
						$ary4["oldPriceStyle"] = " style='display:none;'";
					}
					
					if($i == 4){
						$dataP4[$i]["styleClass"] = " class='last'";
						$ary4["styleClass"] = $dataP4[$i]["styleClass"];
					}
					$aryPB4[] = $ary4;
				}
				//版10-推薦產品(抓8筆) - id = "listPB5"
				$dataP5 = $dalP->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,8);
				for($i=0;$i<count($dataP5);$i++){
					$ary5 = array();
					$ary5["ID"] = $dataP5[$i]["ProductID"];
					$ary5["Name"] = $dataP5[$i]["ProductName"];
					$ary5["sName"] = string::cut_str($dataP5[$i]["ProductName"],"9");
					if(trim($dataP5[$i]["IconImage"]) == "" || !file_exists(".".$dataP5[$i]["IconImage"])){
						$ary5["Image"] = $this->NoPicImage;
					}else{
						$ary5["Image"] = $dataP5[$i]["IconImage"];
					}
					$ary5["Introduction"] = string::cut_str($dataP5[$i]["Introduction"],"30");
					$ary5["htLink"] = $this->htLink4;
					$ary5["Price"] = $dataP5[$i]["Price"];
					$ary5["OldPrice"] = $dataP5[$i]["OldPrice"];
					if($this->registry->webType == "20"){
						if($dataP5[$i]["Price"] == "0" || $dataP5[$i]["Price"] == ""){
							$ary5["priceStyle"] = " style='display:none;'";
						}else{
							$ary5["priceStyle"] = "";
						}
						if($dataP5[$i]["OldPrice"] == "0" || $dataP5[$i]["OldPrice"] == ""){
							$ary5["oldPriceStyle"] = " style='display:none;'";
						}else{
							$ary5["oldPriceStyle"] = "";
						}
					}else{
						$ary5["priceStyle"] = " style='display:none;'";
						$ary5["oldPriceStyle"] = " style='display:none;'";
					}
					$aryPB5[] = $ary5;
				}
				//版17-推薦產品(抓1筆) - id = "listPB6"
				$dataP6 = $dalP->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,1);
				for($i=0;$i<count($dataP6);$i++){
					$ary6 = array();
					$ary6["ID"] = $dataP6[$i]["ProductID"];
					$ary6["Name"] = $dataP6[$i]["ProductName"];
					$ary6["sName"] = string::cut_str($dataP6[$i]["ProductName"],"9");
					if(trim($dataP6[$i]["IconImage"]) == "" || !file_exists(".".$dataP6[$i]["IconImage"])){
						$ary6["Image"] = $this->NoPicImage;
					}else{
						$ary6["Image"] = $dataP6[$i]["IconImage"];
					}
					$ary6["Introduction"] = string::cut_str($dataP6[$i]["Introduction"],"30");
					$ary6["htLink"] = $this->htLink4;
					$ary6["Price"] = $dataP6[$i]["Price"];
					$ary6["OldPrice"] = $dataP6[$i]["OldPrice"];
					if($this->registry->webType == "20"){
						if($dataP6[$i]["Price"] == "0" || $dataP6[$i]["Price"] == ""){
							$ary6["priceStyle"] = " style='display:none;'";
						}else{
							$ary6["priceStyle"] = "";
						}
						if($dataP6[$i]["OldPrice"] == "0" || $dataP6[$i]["OldPrice"] == ""){
							$ary6["oldPriceStyle"] = " style='display:none;'";
						}else{
							$ary6["oldPriceStyle"] = "";
						}
					}else{
						$ary6["priceStyle"] = " style='display:none;'";
						$ary6["oldPriceStyle"] = " style='display:none;'";
					}
					$aryPB6[] = $ary6;
				}
				//版29-推薦產品(抓7筆) - id = "listPB7"
				$dataP7 = $dalP->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,7);
				for($i=0;$i<count($dataP7);$i++){
					$ary7 = array();
					$ary7["ID"] = $dataP7[$i]["ProductID"];
					$ary7["Name"] = $dataP7[$i]["ProductName"];
					$ary7["sName"] = string::cut_str($dataP7[$i]["ProductName"],"9");
					if(trim($dataP7[$i]["IconImage"]) == "" || !file_exists(".".$dataP7[$i]["IconImage"])){
						$ary7["Image"] = $this->NoPicImage;
					}else{
						$ary7["Image"] = $dataP7[$i]["IconImage"];
					}
					$ary7["Introduction"] = string::cut_str($dataP7[$i]["Introduction"],"30");
					$ary7["htLink"] = $this->htLink4;
					$ary7["Price"] = $dataP7[$i]["Price"];
					$ary7["OldPrice"] = $dataP7[$i]["OldPrice"];
					if($this->registry->webType == "20"){
						if($dataP7[$i]["Price"] == "0" || $dataP7[$i]["Price"] == ""){
							$ary7["priceStyle"] = " style='display:none;'";
						}else{
							$ary7["priceStyle"] = "";
						}
						if($dataP7[$i]["OldPrice"] == "0" || $dataP7[$i]["OldPrice"] == ""){
							$ary7["oldPriceStyle"] = " style='display:none;'";
						}else{
							$ary7["oldPriceStyle"] = "";
						}
					}else{
						$ary7["priceStyle"] = " style='display:none;'";
						$ary7["oldPriceStyle"] = " style='display:none;'";
					}
					$aryPB7[] = $ary7;
				}
			}
			$listPB = new repeater();
			$listPB->id = "listPB";
			$listPB->dataSource = $aryPB;
			parent::addControl($listPB);
			
			$listPB2 = new repeater();
			$listPB2->id = "listPB2";
			$listPB2->dataSource = $aryPB2;
			parent::addControl($listPB2);
			
			$listPB3 = new repeater();
			$listPB3->id = "listPB3";
			$listPB3->dataSource = $aryPB3;
			parent::addControl($listPB3);
			
			$listPB4 = new repeater();
			$listPB4->id = "listPB4";
			$listPB4->dataSource = $aryPB4;
			parent::addControl($listPB4);
			
			$listPB5 = new repeater();
			$listPB5->id = "listPB5";
			$listPB5->dataSource = $aryPB5;
			parent::addControl($listPB5);
			
			$listPB6 = new repeater();
			$listPB6->id = "listPB6";
			$listPB6->dataSource = $aryPB6;
			parent::addControl($listPB6);
			
			$listPB7 = new repeater();
			$listPB7->id = "listPB7";
			$listPB7->dataSource = $aryPB7;
			parent::addControl($listPB7);
			
			//單撈相本
			$dataBL = $dalB->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1'","RAND()",0,6);
			for($i=0;$i<count($dataBL);$i++){
				$dataBL[$i]["htLink"] = $this->htLink5;
			}
			$listBL = new repeater();
			$listBL->id = "listBL";
			$listBL->dataSource = $dataBL;
			parent::addControl($listBL);
			
			//單撈產品
			$dataPD = $dalP->executeRecordset("a.`IsIndex`='1' AND a.`Visible`='1' AND b.`Visible`='1'","RAND()",0,20);
			for($i=0;$i<count($dataPD);$i++){
				$dataPD[$i]["htLink"] = $this->htLink4;
			}
			$listPD = new repeater();
			$listPD->id = "listPD";
			$listPD->dataSource = $dataPD;
			parent::addControl($listPD);

			//父類方法
			parent::loadData();
		}
	}

	$page = new _index();
	$page->load();
	$page->render();
?>