<?php
	require_once "pageBase.php";
	require_once "bin/web/repeater.php";
	require_once "dal/faqDAL.php";
	require_once "dal/faq_categoryDAL.php";

	class _faqdetail extends pageBase{
		public function load(){
			$this->loadData();
			parent::load();
		}
		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/faq-detail.html");

			//橫幅廣告
			$this->picturetype = "60";

			//宣告
			$dal = new faqDAL();
			$dalC = new faq_categoryDAL();
			$id = parent::getPageParameter("id","0");
			parent::addParameter("htLink",$this->htLink3);

			//問與答
			if($id == "0"){
				parent::alert2("頁面不存在!!",$this->htLink3.".html");
				exit;
			}else{
				$dal->FaqID = $id;
				$dal->loadRecord();
				if($dal->Visible != "1"){
					parent::alert2("頁面不存在!!",$this->htLink3.".html");
					exit;
				}else{
					$dalC->CategoryID = $dal->CategoryID;
					$dalC->loadRecord();
					if($dalC->Visible != "1"){
						parent::alert2("頁面不存在!!",$this->htLink3.".html");
						exit;
					}else{
						parent::addParameter("CategoryName",$dal->CategoryName);
						parent::addParameter("CategoryID",$dal->CategoryID);
						parent::addParameter("Title",$dal->Title);
						parent::addParameter("Description",$dal->Description);
						if(trim($dal->WebTitle) != ""){
							parent::addParameter("webTitle",$dal->WebTitle);
						}
						if(trim($dal->WebKeyword) != ""){
							parent::addParameter("webKeyword",$dal->WebKeyword);
						}
						if(trim($dal->WebDescription) != ""){
							parent::addParameter("webDescription",$dal->WebDescription);
						}
					}
				}
			}

			//最新消息分類列表
			$dataC = $dalC->executeRecordset("a.`Visible`='1'");
			for($i=0;$i<count($dataC);$i++){
				$dataC[$i]["htLink"] = $this->htLink3;
				if($dataC[$i]["CategoryID"] == $dal->CategoryID){
					$dataC[$i]["className"] = " class='action'";
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			//上下頁
			$filter = "a.`CategoryID`='".$dal->CategoryID."' AND a.`Visible`='1' AND b.`Visible`='1'";
			$orderExp = "a.`OrderNO`,a.`CreatedTime` DESC";
			$data = $dal->executeRecordset($filter,$orderExp);
			$flagA = 0;												//判斷是否找到目前的問與答
			for($i=0;$i<count($data);$i++){
				if($flagA == 0){
					if($data[$i]["FaqID"] == $id){
						$flagA = 1;
					}else{
						$pagUID = $data[$i]["FaqID"];				//上一筆問與答的ID
						$pagUTitle = $data[$i]["Title"];			//上一筆問與答的名稱
					}
				}else{
					$pagDID = $data[$i]["FaqID"];					//下一筆問與答的ID
					$pagDTitle = $data[$i]["Title"];				//下一筆問與答的名稱
					$i = count($data) + 1;
				}
			}
			if($pagUID != ""){
				parent::addParameter("pageUpLink",$this->htLink3."-".$pagUID.".html");
				parent::addParameter("pageUpTitle",$pagUTitle);
				parent::addParameter("pageUpStyle","");
			}else{
				parent::addParameter("pageUpLink","javascript:void(0);");
				parent::addParameter("pageUpTitle","-");
				parent::addParameter("pageUpStyle"," style='display:none;'");
			}
			if($pagDID != ""){
				parent::addParameter("pageDownLink",$this->htLink2."-".$pagDID.".html");
				parent::addParameter("pageDownTitle",$pagDTitle);
				parent::addParameter("pageDownStyle","");
			}else{
				parent::addParameter("pageDownLink","javascript:void(0);");
				parent::addParameter("pageDownTitle","-");
				parent::addParameter("pageDownStyle"," style='display:none;'");
			}

			//父類方法
			parent::loadData();
		}
	}

	$page = new _faqdetail();
	$page->load();
	$page->render();
?>