<?php
/*--------------------------------------------------------- 
 * File:about.php
 * Author:Tomix
 * Description: 
 * Created:2009
 * -------------------------------------------------------
 * Modified history:
 * -------------------------------------------------------
 * Copyright:
 * -------------------------------------------------------
 */
 require_once "pageBase.php";
 require_once "dal/articleDAL.php";
 require_once "dal/article_categoryDAL.php";
 require_once "bin/web/repeater.php";
 require_once "controls/pagenav.php";
 class _about extends pageBase
 {
 	private $id;
 	public $pageSize;
	public $pageIndex=1;
	public $rowCount;
 	public function load()
 	{
 		$this->id=parent::getPageParameter("id","0");
 		$this->loadData();
 		
 		parent::load();
 	}
 	public function loadData()
 	{ 		
 		//加載模板
 		parent::loadTemplateFile("templates/download.html");
 		
 		//頁面內容
 		$about=new articleDAL();
 		
 		$filter ="a.Visible ='1' and a.CategoryID ='11'";
 	    $this->rowCount =$about->countRecordset($filter);
 		$this->pageSize =10;
 		$this->pageIndex=isset($_GET["p"])?$_GET["p"]:1;
 	    $data =$about->executeRecordset($filter,"",($this->pageIndex-1)*$this->pageSize,$this->pageSize);
		
		$data =$this->formatData($data);
		
		$list =new  repeater();
		$list->id ="downlist";
		$list->dataSource=$data;
		parent::addControl($list);
		
		//文章分類名稱
		$dal =new article_categoryDAL();
		$dal->CategoryID="11";
		$dal->loadRecord();
		parent::addParameter("CategorytName",$dal->Name);
		
		
		//分頁導航
		$nav=new pagenav();
	    $nav->cssClass="pagenav";
		$nav->rowCount=$this->rowCount;
		$nav->pageSize=$this->pageSize;
		$nav->pageIndex=$this->pageIndex;	
		$nav->formatUrl="?id=".$_GET["id"]."&p={0}";
		$nav->showInfoText=true;
		$nav->showInfoName="downloads";
		$nav->noResultText="Sorry,there is no messages!";
		$nav->topText="First";
		$nav->previewText="Preview";
		$nav->nextText="Next";
		$nav->endText="Last";	
	 	parent::addParameter("pagenav",$nav->getContent());

 		//父類方法
 		parent::loadData();
 	}
 	
 	private function formatData($data)
 	{
 		$k=1;
 		for($i=0;$i<count($data);$i++)
 		{
 			$data[$i]["downIdName"]="dowload_".$k;
 			$k++;	
 		}
 		
 		return $data;
 	}
 	
 }
 
 $page=new _about();
 $page->load();
 $page->render();
?>