<?php
	require_once "dalBase.php";
	class orderDAL extends dalBase{
		public $OrderID;
		public $ProductPrice;
		public $TransPrice;
		public $OrderPrice;
		public $Name;
		public $Email;
		public $Phone;
		public $Mobile;
		public $Address;
		public $Content;
		public $IsView;
		public $CreatedTime;
		public $CreatedIP;
		public $ModifiedTime;
		public $ModifiedUserID;
		//外連資料列表
		public $OrderProduct = array();

		public function loadRecord(){
			$sql = "SELECT a.* FROM `order` a WHERE a.`OrderID`='".$this->OrderID."'";
			$reader = $this->data->executeReader($sql);

			$this->OrderID = $reader["OrderID"];
			$this->ProductPrice = $reader["ProductPrice"];
			$this->TransPrice = $reader["TransPrice"];
			$this->OrderPrice = $reader["OrderPrice"];
			$this->Name = $reader["Name"];
			$this->Email = $reader["Email"];
			$this->Phone = $reader["Phone"];
			$this->Mobile = $reader["Mobile"];
			$this->Address = $reader["Address"];
			$this->Content = $reader["Content"];
			$this->IsView = $reader["IsView"];
			$this->CreatedTime = $reader["CreatedTime"];
			$this->CreatedIP = $reader["CreatedIP"];
			$this->ModifiedTime = $reader["ModifiedTime"];
			$this->ModifiedUserID = $reader["ModifiedUserID"];
			//外連資料列表
			$sql = "SELECT a.*,b.`ProductName`,b.`ProductNO`,b.`IconImage` FROM `order_product` a LEFT JOIN `product` b ON a.`ProductID`=b.`ProductID` WHERE a.`OrderID`='".$this->OrderID."' ORDER BY a.`ID`";
			$this->OrderProduct = $this->data->executeRecordset($sql);

			if(!$this->data->error)
				return true;
			return false;
		}

		public function insertRecord(){
			//開始事務
			$this->data->beginTransaction();

			//新增主表
			$sql = "INSERT INTO `order` (`ProductPrice`, `TransPrice`, `OrderPrice`, `Name`, `Email`, `Phone`, `Mobile`, `Address`, `Content`, `IsView`, `CreatedTime`, `CreatedIP`, `ModifiedTime`, `ModifiedUserID`)" .
				" VALUES (@ProductPrice,@TransPrice,@OrderPrice,@Name,@Email,@Phone,@Mobile,@Address,@Content,@IsView,@CreatedTime,@CreatedIP,@ModifiedTime,@ModifiedUserID)";
			$sql = str_replace("@ProductPrice","'".$this->ProductPrice."'",$sql);
			$sql = str_replace("@TransPrice","'".$this->TransPrice."'",$sql);
			$sql = str_replace("@OrderPrice","'".$this->OrderPrice."'",$sql);
			$sql = str_replace("@Name","'".$this->Name."'",$sql);
			$sql = str_replace("@Email","'".$this->Email."'",$sql);
			$sql = str_replace("@Phone","'".$this->Phone."'",$sql);
			$sql = str_replace("@Mobile","'".$this->Mobile."'",$sql);
			$sql = str_replace("@Address","'".$this->Address."'",$sql);
			$sql = str_replace("@Content","'".$this->Content."'",$sql);
			$sql = str_replace("@IsView","'".$this->IsView."'",$sql);
			$sql = str_replace("@CreatedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@CreatedIP","'".$this->CreatedIP."'",$sql);
			$sql = str_replace("@ModifiedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@ModifiedUserID","'".$this->ModifiedUserID."'",$sql);

			$this->data->executeNonQuery($sql,true);
			$insertID = $this->data->getInsertID();

			//新增訂單_商品
			if(is_array($this->OrderProduct) && count($this->OrderProduct) > 0){
				foreach($this->OrderProduct as $row){
					$sql = "INSERT INTO `order_product` (`OrderID`, `ProductID`, `Price`, `Quantity`) VALUES (@OrderID,@ProductID,@Price,@Quantity)";
					$sql = str_replace("@OrderID","'".$insertID."'",$sql);
					$sql = str_replace("@ProductID","'".$row["ProductID"]."'",$sql);
					$sql = str_replace("@Price","'".$row["Price"]."'",$sql);
					$sql = str_replace("@Quantity","'".$row["Quantity"]."'",$sql);
					$this->data->executeNonQuery($sql,true);
				}
			}

			if(!$this->data->error){
				//提交事務
				$this->data->commitTransaction();
				return true;
			}else{
				//回滾事務
				$this->data->rollbackTransaction();
				return false;
			}
		}

		public function updateRecord(){
			//開始事務
			$this->data->beginTransaction();

			//更新主表
			$sql = "UPDATE `order` SET " .
				"`ProductPrice`=@ProductPrice" .
				",`TransPrice`=@TransPrice" .
				",`OrderPrice`=@OrderPrice" .
				",`Name`=@Name" .
				",`EMail`=@EMail" .
				",`Phone`=@Phone" .
				",`Mobile`=@Mobile" .
				",`Address`=@Address" .
				",`Content`=@Content" .
				",`ModifiedTime`=@ModifiedTime" .
				",`ModifiedUserID`=@ModifiedUserID" .
				" WHERE `OrderID`=@OrderID";
			$sql = str_replace("@OrderID","'".$this->OrderID."'",$sql);
			$sql = str_replace("@ProductPrice","'".$this->ProductPrice."'",$sql);
			$sql = str_replace("@TransPrice","'".$this->TransPrice."'",$sql);
			$sql = str_replace("@OrderPrice","'".$this->OrderPrice."'",$sql);
			$sql = str_replace("@Name","'".$this->Name."'",$sql);
			$sql = str_replace("@Email","'".$this->Email."'",$sql);
			$sql = str_replace("@Phone","'".$this->Phone."'",$sql);
			$sql = str_replace("@Mobile","'".$this->Mobile."'",$sql);
			$sql = str_replace("@Address","'".$this->Address."'",$sql);
			$sql = str_replace("@Content","'".$this->Content."'",$sql);
			$sql = str_replace("@ModifiedTime","'".$this->ModifiedTime."'",$sql);
			$sql = str_replace("@ModifiedUserID","'".$this->ModifiedUserID."'",$sql);

			$this->data->executeNonQuery($sql,true);

			//更新訂單_商品
			////刪除舊資料
			$sql = "DELETE FROM `order_product` WHERE `OrderID`='".$this->OrderID."'";
			$this->data->executeNonQuery($sql,true);

			////新增新資料
			if(is_array($this->OrderProduct) && count($this->OrderProduct) > 0){
				foreach($this->OrderProduct as $row){
					$sql = "INSERT INTO `order_product` (`OrderID`, `ProductID`, `Price`, `Quantity`) VALUES (@OrderID,@ProductID,@Price,@Quantity)";
					$sql = str_replace("@OrderID","'".$this->OrderID."'",$sql);
					$sql = str_replace("@ProductID","'".$row["ProductID"]."'",$sql);
					$sql = str_replace("@Price","'".$row["Price"]."'",$sql);
					$sql = str_replace("@Quantity","'".$row["Quantity"]."'",$sql);
					$this->data->executeNonQuery($sql,true);
				}
			}

			if(!$this->data->error){
				//提交事務
				$this->data->commitTransaction();
				return true;
			}else{
				//回滾事務
				$this->data->rollbackTransaction();
				return false;
			}
		}

		//查詢
		public function executeRecordset($filter="",$orderExp="",$start=0,$length=-1){
			$sql = "SELECT a.* FROM `order` a";
			if(trim($filter) != "")
				$sql .= " WHERE ".$filter;
			if(trim($orderExp) != "")
				$sql .= " ORDER BY ".$orderExp;
			else
				$sql .= " ORDER BY a.CreatedTime DESC";

			return $this->data->executeRecordset($sql,$start,$length);
		}
		//計數
		public function countRecordset($filter=""){
			$sql = "SELECT COUNT(*) FROM `order` a";
			if(trim($filter) != "")
				$sql .= " WHERE ".$filter;
			return $this->data->executeScalar($sql);
		}

		//刪除
		public function deleteRecord($orderID){
			$sql = "DELETE a,b FROM `order` a LEFT JOIN `order_product` b ON a.`OrderID`=b.`OrderID` WHERE a.`OrderID`='".$orderID."'";
			$this->data->executeNonQuery($sql);

			if(!$this->data->error)
				return true;
			return false;
		}
		//批量刪除
		public function batDelete($orderIDs){
			$sql = "DELETE a,b FROM `order` a LEFT JOIN `order_product` b ON a.`OrderID`=b.`OrderID` WHERE a.`OrderID` IN (".$orderIDs.")";
			$this->data->executeNonQuery($sql);

			if(!$this->data->error)
				return true;
			return false;
		}

		//讀取
		public function view(){
			$sql = "UPDATE `order` SET `IsView`='1' WHERE `OrderID`='".$this->OrderID."' AND `IsView`='0'";
			$this->data->executeNonQuery($sql);

			if(!$this->data->error)
				return true;
			return false;
		}
	}
?>