<?php
	require_once dirname(__FILE__)."/dalBase.php";
	class faqDAL extends dalBase{
		public $FaqID;
		public $CategoryID;
		public $Title;
		public $Description;
		public $Visible;
		public $OrderNO;
		public $WebTitle;
		public $WebKeyword;
		public $WebDescription;
		public $CreatedTime;
		public $CreatedUserID;
		public $ModifiedTime;
		public $ModifiedUserID;
		//外部欄位
		public $CategoryName;

		public function loadRecord(){
			$sql = "SELECT a.*,b.`CategoryName` FROM `faq` a LEFT JOIN `faq_category` b ON a.`CategoryID`=b.`CategoryID` WHERE a.`FaqID`='".$this->FaqID."'";
			$reader = $this->data->executeReader($sql);

			$this->FaqID = $reader["FaqID"];
			$this->CategoryID = $reader["CategoryID"];
			$this->Title = $reader["Title"];
			$this->Description = $reader["Description"];
			$this->Visible = $reader["Visible"];
			$this->OrderNO = $reader["OrderNO"];
			$this->WebTitle = $reader["WebTitle"];
			$this->WebKeyword = $reader["WebKeyword"];
			$this->WebDescription = $reader["WebDescription"];
			$this->CreatedTime = $reader["CreatedTime"];
			$this->CreatedUserID = $reader["CreatedUserID"];
			$this->ModifiedTime = $reader["ModifiedTime"];
			$this->ModifiedUserID = $reader["ModifiedUserID"];
			$this->CategoryName = $reader["CategoryName"];

			if(!$this->data->error)
				return true;
			return false;
		}
		public function insertRecord(){
			$sql = "INSERT INTO `faq` (`CategoryID`, `Title`, `Description`, `Visible`, `OrderNO`, `WebTitle`, `WebKeyword`, `WebDescription`, `CreatedTime`, `CreatedUserID`, `ModifiedTime`, `ModifiedUserID`)" .
				" VALUES (@CategoryID,@Title,@Description,@Visible,@OrderNO,@WebTitle,@WebKeyword,@WebDescription,@CreatedTime,@CreatedUserID,@ModifiedTime,@ModifiedUserID)";
			$sql = str_replace("@CategoryID","'".$this->CategoryID."'",$sql);
			$sql = str_replace("@Title","'".$this->Title."'",$sql);
			$sql = str_replace("@Description","'".$this->Description."'",$sql);
			$sql = str_replace("@Visible","'".$this->Visible."'",$sql);
			$sql = str_replace("@OrderNO","'".$this->OrderNO."'",$sql);
			$sql = str_replace("@WebTitle","'".$this->WebTitle."'",$sql);
			$sql = str_replace("@WebKeyword","'".$this->WebKeyword."'",$sql);
			$sql = str_replace("@WebDescription","'".$this->WebDescription."'",$sql);
			$sql = str_replace("@CreatedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@CreatedUserID","'".$this->CreatedUserID."'",$sql);
			$sql = str_replace("@ModifiedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@ModifiedUserID","'".$this->ModifiedUserID."'",$sql);

			$this->data->executeNonQuery($sql);
			if(!$this->data->error)
				return $this->data->getInsertID();
			return false;
		}
		public function updateRecord(){
			$sql = "UPDATE `faq` SET " .
				"`CategoryID`=@CategoryID" .
				",`Title`=@Title" .
				",`Description`=@Description" .
				",`Visible`=@Visible" .
				",`OrderNO`=@OrderNO" .
				",`WebTitle`=@WebTitle" .
				",`WebKeyword`=@WebKeyword" .
				",`WebDescription`=@WebDescription" .
				",`ModifiedTime`=@ModifiedTime" .
				",`ModifiedUserID`=@ModifiedUserID" .
				" WHERE `FaqID`=@FaqID";
			$sql = str_replace("@FaqID","'".$this->FaqID."'",$sql);
			$sql = str_replace("@CategoryID","'".$this->CategoryID."'",$sql);
			$sql = str_replace("@Title","'".$this->Title."'",$sql);
			$sql = str_replace("@Description","'".$this->Description."'",$sql);
			$sql = str_replace("@Visible","'".$this->Visible."'",$sql);
			$sql = str_replace("@OrderNO","'".$this->OrderNO."'",$sql);
			$sql = str_replace("@WebTitle","'".$this->WebTitle."'",$sql);
			$sql = str_replace("@WebKeyword","'".$this->WebKeyword."'",$sql);
			$sql = str_replace("@WebDescription","'".$this->WebDescription."'",$sql);
			$sql = str_replace("@ModifiedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@ModifiedUserID","'".$this->ModifiedUserID."'",$sql);

			$this->data->executeNonQuery($sql);
			if(!$this->data->error)
				return true;
			return false;
		}
		//查詢
		public function executeRecordset($filter="",$order="",$start=0,$length=-1){
			$sql = "SELECT a.*,b.`CategoryName` FROM `faq` a LEFT JOIN `faq_category` b ON a.`CategoryID`=b.`CategoryID`";
			if(trim($filter) != "")
				$sql .= " WHERE ".$filter;
			if(!isset($order) || $order == "")
				$sql .= " ORDER BY a.`OrderNO`,a.`CreatedTime`";
			else
				$sql .= " ORDER BY ".$order;
			return $this->data->executeRecordset($sql,$start,$length);
		}
		//查詢計數
		public function countRecordset($filter=""){
			$sql = "SELECT COUNT(*) FROM `faq` a LEFT JOIN `faq_category` b ON a.`CategoryID`=b.`CategoryID`";
			if($filter != "")
				$sql .= " WHERE ".$filter;

			return $this->data->executeScalar($sql);
		}

		//刪除
		public function deleteRecord($faqID){
			$sql = "DELETE FROM `faq` WHERE `FaqID`='".$faqID."'";
			$this->data->executeNonQuery($sql);

			if(!$this->data->error)
				return true;
			return false;
		}

		//批量刪除，傳入參數為用逗號分隔的id串
		public function batDelete($faqIDs){
			$sql = "DELETE FROM `faq` WHERE `FaqID` IN (".$faqIDs.")";
			$this->data->executeNonQuery($sql,true);

			if(!$this->data->error)
				return true;
			return false;
		}

		//批量修改啟用狀態，傳入參數為用逗號分隔的id串和啟用欄位值
		public function batUpdateVisible($faqIDs,$value="1"){
			$sql = "UPDATE `faq` SET `Visible`='".$value."' WHERE `FaqID` IN (".$faqIDs.")";
			$this->data->executeNonQuery($sql);
			if(!$this->data->error)
				return true;
			return false;
		}
	}
?>