<?php
	require_once dirname(__FILE__)."/dalBase.php";
	class categoryDAL extends dalBase{
		public $CategoryID;
		public $ParentID;
		public $CategoryName;
		public $Visible;
		public $OrderNO;
		public $WebTitle;
		public $WebKeyword;
		public $WebDescription;
		public $CreatedTime;
		public $CreatedUserID;
		public $ModifiedTime;
		public $ModifiedUserID;
		//外部欄位
		public $ParentName;

		public function loadRecord(){
			$sql = "SELECT a.*,b.`CategoryName` AS `ParentName` FROM `category` a LEFT JOIN `category` b ON a.`ParentID`=b.`CategoryID` WHERE a.`CategoryID`='".$this->CategoryID."'";
			$reader = $this->data->executeReader($sql);

			$this->CategoryID = $reader["CategoryID"];
			$this->ParentID = $reader["ParentID"];
			$this->CategoryName = $reader["CategoryName"];
			$this->Visible = $reader["Visible"];
			$this->OrderNO = $reader["OrderNO"];
			$this->WebTitle = $reader["WebTitle"];
			$this->WebKeyword = $reader["WebKeyword"];
			$this->WebDescription = $reader["WebDescription"];
			$this->CreatedTime = $reader["CreatedTime"];
			$this->CreatedUserID = $reader["CreatedUserID"];
			$this->ModifiedTime = $reader["ModifiedTime"];
			$this->ModifiedUserID = $reader["ModifiedUserID"];
			$this->ParentName = $reader["ParentName"];

			if(!$this->data->error)
				return true;
			return false;
		}

		public function insertRecord(){
			$sql = "INSERT INTO `category` (`ParentID`,`CategoryName`,`Visible`,`OrderNO`,`WebTitle`,`WebKeyword`,`WebDescription`,`CreatedTime`,`CreatedUserID`,`ModifiedTime`,`ModifiedUserID`)" .
				" VALUES (@ParentID,@CategoryName,@Visible,@OrderNO,@WebTitle,@WebKeyword,@WebDescription,@CreatedTime,@CreatedUserID,@ModifiedTime,@ModifiedUserID)";
			$sql = str_replace("@ParentID","'".$this->ParentID."'",$sql);
			$sql = str_replace("@CategoryName","'".$this->CategoryName."'",$sql);
			$sql = str_replace("@Visible","'".$this->Visible."'",$sql);
			$sql = str_replace("@OrderNO","'".$this->OrderNO."'",$sql);
			$sql = str_replace("@WebTitle","'".$this->WebTitle."'",$sql);
			$sql = str_replace("@WebKeyword","'".$this->WebKeyword."'",$sql);
			$sql = str_replace("@WebDescription","'".$this->WebDescription."'",$sql);
			$sql = str_replace("@CreatedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@CreatedUserID","'".$this->CreatedUserID."'",$sql);
			$sql = str_replace("@ModifiedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@ModifiedUserID","'".$this->ModifiedUserID."'",$sql);

			$this->data->executeNonQuery($sql);
			if(!$this->data->error)
				return $this->data->getInsertID();
			return false;
		}

		public function updateRecord(){
			$sql = "UPDATE `category` SET " .
				"`ParentID`=@ParentID" .
				",`CategoryName`=@CategoryName" .
				",`Visible`=@Visible" .
				",`OrderNO`=@OrderNO" .
				",`WebTitle`=@WebTitle" .
				",`WebKeyword`=@WebKeyword" .
				",`WebDescription`=@WebDescription" .
				",`ModifiedTime`=@ModifiedTime" .
				",`ModifiedUserID`=@ModifiedUserID" .
				" WHERE `CategoryID`=@CategoryID";
			$sql = str_replace("@CategoryID","'".$this->CategoryID."'",$sql);
			$sql = str_replace("@ParentID","'".$this->ParentID."'",$sql);
			$sql = str_replace("@CategoryName","'".$this->CategoryName."'",$sql);
			$sql = str_replace("@Visible","'".$this->Visible."'",$sql);
			$sql = str_replace("@OrderNO","'".$this->OrderNO."'",$sql);
			$sql = str_replace("@WebTitle","'".$this->WebTitle."'",$sql);
			$sql = str_replace("@WebKeyword","'".$this->WebKeyword."'",$sql);
			$sql = str_replace("@WebDescription","'".$this->WebDescription."'",$sql);
			$sql = str_replace("@ModifiedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@ModifiedUserID","'".$this->ModifiedUserID."'",$sql);

			$this->data->executeNonQuery($sql);
			if(!$this->data->error)
				return true;
			return false;
		}

		//查詢
		public function executeRecordset($filter="",$orderexp="",$start=0,$length=-1){
			$sql = "SELECT a.*,b.`CategoryName` AS `ParentName` FROM `category` a LEFT JOIN `category` b ON a.`ParentID`=b.`CategoryID`";
			if(trim($filter) != "")
				$sql .= " WHERE ".$filter;
			if(trim($orderexp)!="")
				$sql .= " ORDER BY ".$orderexp;
			else
				$sql .= " ORDER BY a.OrderNO";

			return $this->data->executeRecordset($sql,$start,$length);
		}

		//查詢計數
		public function countRecordset($filter){
			$sql = "SELECT COUNT(*) FROM `category` a";
			if($filter != "")
				$sql .= " WHERE ".$filter;

			return $this->data->executeScalar($sql);
		}

		//刪除
		public function deleteRecord($categoryID){
			$sql = "DELETE FROM `category` WHERE `CategoryID`='".$categoryID."'";
			$this->data->executeNonQuery($sql);
			if(!$this->data->error)
				return true;
			return false;
		}
	}
?>