<?php
	require_once dirname(__FILE__)."/dalBase.php";
	class articleDAL extends dalBase{
		public $ArticleID;
		public $CategoryID;
		public $Title;
		public $PathName;
		public $Description;
		public $Image;
		public $Structure;
		public $Visible;
		public $OrderNO;
		public $WebTitle;
		public $WebKeyword;
		public $WebDescription;
		public $CreatedTime;
		public $CreatedUserID;
		public $ModifiedTime;
		public $ModifiedUserID;
		//外部欄位
		public $CategoryName;

		public function loadRecord(){
			$sql = "SELECT a.*,b.`CategoryName` FROM `article` a LEFT JOIN `article_category` b ON a.`CategoryID`=b.`CategoryID`";
			if($this->PathName != "")
				$sql .= " WHERE a.`PathName`='".$this->PathName."'";
			else
				$sql .= " WHERE a.`ArticleID`='".$this->ArticleID."'";

			$reader = $this->data->executeReader($sql);

			$this->ArticleID = $reader["ArticleID"];
			$this->CategoryID = $reader["CategoryID"];
			$this->Title = $reader["Title"];
			$this->PathName = $reader["PathName"];
			$this->Description = $reader["Description"];
			$this->Image = $reader["Image"];
			$this->Structure = $reader["Structure"];
			$this->Visible = $reader["Visible"];
			$this->OrderNO = $reader["OrderNO"];
			$this->WebTitle = $reader["WebTitle"];
			$this->WebKeyword = $reader["WebKeyword"];
			$this->WebDescription = $reader["WebDescription"];
			$this->CreatedTime = $reader["CreatedTime"];
			$this->CreatedUserID = $reader["CreatedUserID"];
			$this->ModifiedTime = $reader["ModifiedTime"];
			$this->ModifiedUserID = $reader["ModifiedUserID"];
			$this->CategoryName = $reader["CategoryName"];

			if(!$this->data->error)
				return true;
			return false;
		}
		public function insertRecord(){
			$sql = "INSERT INTO `article` (`CategoryID`, `Title`, `PathName`, `Description`, `Image`, `Structure`, `Visible`, `OrderNO`, `WebTitle`, `WebKeyword`, `WebDescription`, `CreatedTime`, `CreatedUserID`, `ModifiedTime`, `ModifiedUserID`)" .
				" VALUES (@CategoryID,@Title,@PathName,@Description,@Image,@Structure,@Visible,@OrderNO,@WebTitle,@WebKeyword,@WebDescription,@CreatedTime,@CreatedUserID,@ModifiedTime,@ModifiedUserID)";
			$sql = str_replace("@CategoryID","'".$this->CategoryID."'",$sql);
			$sql = str_replace("@Title","'".$this->Title."'",$sql);
			$sql = str_replace("@PathName","'".$this->PathName."'",$sql);
			$sql = str_replace("@Description","'".$this->Description."'",$sql);
			$sql = str_replace("@Image","'".$this->Image."'",$sql);
			$sql = str_replace("@Structure","'".$this->Structure."'",$sql);
			$sql = str_replace("@Visible","'".$this->Visible."'",$sql);
			$sql = str_replace("@OrderNO","'".$this->OrderNO."'",$sql);
			$sql = str_replace("@WebTitle","'".$this->WebTitle."'",$sql);
			$sql = str_replace("@WebKeyword","'".$this->WebKeyword."'",$sql);
			$sql = str_replace("@WebDescription","'".$this->WebDescription."'",$sql);
			$sql = str_replace("@CreatedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@CreatedUserID","'".$this->CreatedUserID."'",$sql);
			$sql = str_replace("@ModifiedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@ModifiedUserID","'".$this->ModifiedUserID."'",$sql);

			$this->data->executeNonQuery($sql);
			if(!$this->data->error)
				return $this->data->getInsertID();
			return false;
		}
		public function updateRecord(){
			$sql = "UPDATE `article` SET " .
				"`CategoryID`=@CategoryID" .
				",`Title`=@Title" .
				",`PathName`=@PathName" .
				",`Description`=@Description" .
				",`Image`=@Image" .
				",`Structure`=@Structure" .
				",`Visible`=@Visible" .
				",`OrderNO`=@OrderNO" .
				",`WebTitle`=@WebTitle" .
				",`WebKeyword`=@WebKeyword" .
				",`WebDescription`=@WebDescription" .
				",`ModifiedTime`=@ModifiedTime" .
				",`ModifiedUserID`=@ModifiedUserID" .
				" WHERE `ArticleID`=@ArticleID";
			$sql = str_replace("@ArticleID","'".$this->ArticleID."'",$sql);
			$sql = str_replace("@CategoryID","'".$this->CategoryID."'",$sql);
			$sql = str_replace("@Title","'".$this->Title."'",$sql);
			$sql = str_replace("@PathName","'".$this->PathName."'",$sql);
			$sql = str_replace("@Description","'".$this->Description."'",$sql);
			$sql = str_replace("@Image","'".$this->Image."'",$sql);
			$sql = str_replace("@Structure","'".$this->Structure."'",$sql);
			$sql = str_replace("@Visible","'".$this->Visible."'",$sql);
			$sql = str_replace("@OrderNO","'".$this->OrderNO."'",$sql);
			$sql = str_replace("@WebTitle","'".$this->WebTitle."'",$sql);
			$sql = str_replace("@WebKeyword","'".$this->WebKeyword."'",$sql);
			$sql = str_replace("@WebDescription","'".$this->WebDescription."'",$sql);
			$sql = str_replace("@ModifiedTime","'".date("Y-m-d H:i:s")."'",$sql);
			$sql = str_replace("@ModifiedUserID","'".$this->ModifiedUserID."'",$sql);

			$this->data->executeNonQuery($sql);
			if(!$this->data->error)
				return true;
			return false;
		}
		//查詢
		public function executeRecordset($filter="",$orderExp="", $start=0,$length=-1){
			$sql = "SELECT a.*,b.`CategoryName` FROM `article` a LEFT JOIN `article_category` b ON a.`CategoryID`=b.`CategoryID`";
			if(trim($filter) != "")
				$sql .= " WHERE ".$filter;

			if(trim($orderExp) != "")
				$sql .= " ORDER BY ".$orderExp;
			else
				$sql .= " ORDER BY a.`OrderNO`,a.`CreatedTime`";
			return $this->data->executeRecordset($sql,$start,$length);
		}

		public function countRecordset($filter=""){
			$sql = "SELECT COUNT(*) FROM `article` a LEFT JOIN `article_category` b ON a.`CategoryID`=b.`CategoryID`";
			if(trim($filter) != "")
				$sql .= " WHERE ".$filter;
			return $this->data->executeScalar($sql);
		}

		//刪除
		public function deleteRecord($articleID){
			$sql = "DELETE FROM `article` WHERE `ArticleID`='".$articleID."'";
			$this->data->executeNonQuery($sql);

			if(!$this->data->error)
				return true;
			return false;
		}

		//檢查路徑是否已存在
		public function checkPathNameExists($pathName){
			$sql = "SELECT COUNT(*) FROM `article` WHERE `PathName`='".$pathName."'";
			$num = $this->data->executeScalar($sql);

			if($num > 0)
				return true;
			return false;
		}
	}
?>