<?php
/*--------------------------------------------------------- 
 * File:currency.php
 * Author:Tomix
 * Description: 
 * Created:2009-7-21
 * -------------------------------------------------------
 * Modified history:
 * -------------------------------------------------------
 * Copyright:
 * -------------------------------------------------------
 */
 require_once dirname(__FILE__)."/dal/currencyDAL.php";
 require_once dirname(__FILE__)."/bin/configuration/configFactory.php";
 class currency
 {
 	//私有屬性:貨幣信息(陣列)
 	static private $info;
 	
 	static public function getCurrencyID()
 	{ 		
 		if(!isset(self::$info) || !is_array(self::$info))
 			self::refresh();
 		return self::$info->ID;
 	}
 	
 	//取貨幣左符號
 	static public function getSymbolLeft()
 	{
 		if(!isset(self::$info) || !is_array(self::$info))
 			self::refresh();
 		return self::$info->SymbolLeft;
 	}
 	
 	//取貨幣右符號
 	static public function getSymbolRight()
 	{
 		if(!isset(self::$info) || !is_array(self::$info))
 			self::refresh();	
 		return self::$info->SymbolRight;
 	}
 	
 	//取兌美元的匯率
 	static public function getRate()
 	{
 		if(!isset(self::$info) || !is_array(self::$info))
 			self::refresh();
 		return self::$info->Value;	
 	}
 	
 	//刷新
 	static public function refresh()
 	{
 		self::queryCurrency();
 	}
 	
 	//從資料庫讀取信息
 	static private function queryCurrency()
 	{
		//從cookie讀取
 		if(isset($_COOKIE["currency"]) && $_COOKIE["currency"] != "" && $_COOKIE["currency"] != "0")
 			$currency_cookie=$_COOKIE["currency"];
  		
 		//從post參數讀取
 		if(isset($_POST["currency"]) && $_POST["currency"] != "" && $_POST["currency"] != "0")
 			$currency_cookie=$_POST["currency"];
 						
 		//從get參數讀取
 		if(isset($_GET["currency"]) && $_GET["currency"] != "" && $_GET["currency"] != "0")
 			$currency_cookie=$_GET["currency"];
 		
 		if(!isset($currency_cookie) || $currency_cookie == "" || $currency_cookie == "")
 		{
	 		//從配置讀取默認貨幣id
	 		$config=configFactory::createConfiguration(); 		
	 		$dal=new currencyDAL();
	 		$currency_cookie=$config->getConfigValue("appsettings","defaultCurrencyID"); 			
 		}
 		
 		//保存到cookie	
 		$currency_cookie="6";
 		setcookie("currency",$currency_cookie);	
 		$dal=new currencyDAL();
 		$dal->CurrencyID=$currency_cookie;
 		$dal->loadRecord();
 		self::$info=$dal; 
 	}
 }
?>
