<?php
/*--------------------------------------------------------- 
 * File:pagenav.php
 * Author:Tomix
 * Description: 頁面導航類(不繼承control基類)
 * Created:2009-7-9
 * -------------------------------------------------------
 * Modified history:
 * -------------------------------------------------------
 * Copyright:
 * -------------------------------------------------------
 */
 class pagenav
 {
 	//控件ID
 	public $id;
 	
 	//当前页面索引(默认值:1)
 	public $pageIndex=1;
 	
 	//每页记录数(默认值:15)
 	public $pageSize=15;
 	
 	//记录计数(默认值:0,空记录)
 	public $rowCount=0;
 	
 	//信息顯示格式化文字
 	public $showInfoName="Photos";
 	public $formatInfoTextTop="Displaying:&nbsp;<strong>{0}</strong>&nbsp;/&nbsp;<strong>{1}</strong>&nbsp;pages&nbsp;(of <strong>{2}</strong>&nbsp; ";
 	public $formatInfoTextEnd=" )&nbsp;&nbsp;&nbsp;&nbsp;\r\n";
 	
 	//格式化url,只有一个格式化参数{0}.该属性与formatText两者必需至少要为一个赋值
 	public $formatUrl="#";
 	
 	//單擊事件格式化函數
 	public $formatOnClickFunc="void(0);";
 	
 	//生成链接的样式类属性(可选赋值属性)
 	public $cssClass;
 	
 	//当前页面文字样式类属性
 	public $currentCssClass;
 	
 	//第一页链接文字
 	public $topText="First";
 	
 	//上一页链接文字
 	public $previewText="preview";
 	
 	//上10页链接文字
 	public $pre10Text="...";
 	
 	//下10页链接文字
 	public $next10Text="...";
 	
 	//下一页链接文字
 	public $nextText="next";
 	
 	//最后一页链接文字
 	public $endText="Last";
 	
 	//记录数为0时输出文本
 	public $noResultText="この結果の記録が見つかりません!";
 	
 	//是否顯示信息提示文字
 	public $showInfoText=true;
 	
 	//公开方法:呈现html
 	public function render()
 	{
 		echo $this->getContent();	
 	}
  	
 	//公开方法:获取页导航html内容
 	public function getContent()
 	{
 		//初始化失败时,返回空文本
 		$this->init();
 		if($this->rowCount==0)
 			return $this->noResultText;
 		
 		//构造导航链接字串
 		$text="";
 		
 		$pageCount=$this->getPageCount();
 		
 		$text .= "<div";
 		if(isset($this->ID) && $this->ID != "")
 			$text .= " id=\"".$this->ID."\"";
 		if(isset($this->cssClass) && $this->cssClass != "")
 			$text .= " class=\"".$this->cssClass."\"";
 		$text .= ">";

 		//导航信息文字
 		if($this->showInfoText)
 		{
	 		$infoText = $this->formatInfoTextTop.$this->showInfoName.$this->formatInfoTextEnd;
	 		$infoText=str_replace("{0}",$this->pageIndex,$infoText);
	 		$infoText=str_replace("{1}",$pageCount,$infoText);
	 		$infoText=str_replace("{2}",$this->rowCount,$infoText);
	 		$text .= $infoText;
 		}
// 		$text .= "Displaying:&nbsp;<strong>".$this->pageIndex."</strong>&nbsp;/&nbsp;<strong>".$pageCount."</strong>&nbsp;pages&nbsp;(of <strong>".$this->rowCount."</strong> products)&nbsp;&nbsp;&nbsp;&nbsp;\r\n";
 		
 		//第一页,上一页链接
 		if($this->pageIndex > 1)
 		{
 			$text .= $this->buildLink(1,$this->topText)."\r\n";
 			$text .= $this->buildLink($this->pageIndex-1,$this->previewText)."\r\n";
 		}
 		
 		$navPageCount=ceil($pageCount/10);
 		if($navPageCount <= 0)
 			$navPageCount=1;
 		$navPageIndex=ceil($this->pageIndex/10);
 		
 		//前10页记录
 		if($navPageIndex > 1)
 		{
 			$text .=$this->buildLink($this->pageIndex-10,$this->pre10Text)."\r\n";
 		}
 		
 		//数字页码
 		$skip=$this->pageIndex % 10;
 		if($skip==0)
 			$skip=10;
 		$start=	$this->pageIndex-$skip+1;
 		$end=$this->pageIndex-$skip+10;
 		for($i=$start;$i<$end+1;$i++)
 		{
 			if($i>$pageCount)
 				break;
 			if($i != $this->pageIndex)
 			{
 				$text .= $this->buildLink($i,$i)."\r\n";
 			}
 			else
 			{
 				if(isset($this->currentCssClass) && $this->currentCssClass != "")
 				{
 					$text .= "<span class=\"".$this->currentCssClass."\">".$i."</span>\r\n";
 				}
 				else
 				{
 					$text .= $i."\r\n";
 				}
 			}
 		} 		
 		 		 		
 		//后10页记录
 		if($navPageIndex < $navPageCount)
 		{
 			$currentIndex=$this->pageIndex+10;
 			if($currentIndex>$pageCount)
 				$currentIndex=$pageCount;
 			$text .= $this->buildLink($currentIndex,$this->next10Text)."\r\n";
 		}
 		
 		//后一页,尾页链接
 		if($this->pageIndex < $this->getPageCount())
 		{
 			$text .= $this->buildLink($this->pageIndex+1,$this->nextText)."\r\n";
 			$text .= $this->buildLink($pageCount,$this->endText)."\r\n";
 		}
 		$text .= "</div>";
 		return $text;
 	}
 	
 	//公开方法,返回总页数
 	public function getPageCount()
 	{
 		$num=ceil($this->rowCount/$this->pageSize);
 		if($num==0)
 			return 1;
 		return $num;
 	}
 	
 	//构建链接文本
 	private function buildLink($currentPageIndex,$linkText)
 	{
 		$returnValue="";
 		if(isset($this->formatOnClickFunc) && $this->formatOnClickFunc != "") //單擊事件
 		{
 			$returnValue="<a href=\"{1}\" onclick=\"{2}\">".$linkText."</a>";
			$returnValue=str_replace("{1}",$this->formatUrl,$returnValue);
			$returnValue=str_replace("{2}",$this->formatOnClickFunc,$returnValue);
			$returnValue=str_replace("{0}",$currentPageIndex,$returnValue); 
 		}
 		else
 		{
			$returnValue="<a href=\"{1}\">".$linkText."</a>";
			$returnValue=str_replace("{1}",$this->formatUrl,$returnValue);
			$returnValue=str_replace("{0}",$currentPageIndex,$returnValue); 
 		}
 		return $returnValue;
 	}
 	
 	//初始化
 	private function init()
 	{
 		if($this->pageIndex <= 0)
 			$this->pageIndex=1;
 		if($this->pageSize <= 0)
 			$this->pageSize=15;
 		if($this->rowCount < 0)
 			$this->rowCount=0; 
 	} 	
 }
?>
