<?php
/*--------------------------------------------------------- 
 * File:dropDownList.php
 * Author:Tomix,邱洪榮
 * Description: 下拉框類
 * Created:2009-5-14
 * -------------------------------------------------------
 * Modified history:
 * -------------------------------------------------------
 * Copyright:
 * -------------------------------------------------------
 */
 class dropDownList
 {
 	public $id="dropDownList1";//控件id
 	public $dataSource;//控件收據源
 	public $showTree=false;//是否顯示成樹形
 	public $showUndefine=false;//是否顯示未定義項
 	public $undefineText="Undefine";//顯示未定義項時文字(默認值為空字符串:"")
 	public $undefineValue="";	//顯示未定義項時值(默認值為空字符串:"")
 	public $idField;	//ID字段
 	public $pidField;	//父ID字段
 	public $valueField;	//值字段
 	public $titleField;	//標題(文本)字段
 	public $rootID;//根ID值,默認為空字串"",0,null
 	public $selectedValue="";//選中值
 	public $separator="&nbsp;&nbsp;";//上下級選項前導符號
 	
 	private $clientAttributes=array();
 	
 	public function dropDownList()
 	{
 		
 	}
 	public function getContent()
 	{
 		$html="";
 		if(!is_array($this->dataSource))
 		{
 			return "Data source is not a array!";
 		}
 		if($this->showUndefine)
 		{
 			$html .= "<option value=\"".$this->undefineValue."\">".$this->undefineText."</option>\r\n";
 		}
 		if($this->showTree)	//樹狀顯示
 		{
 			$html .= $this->getTreeItems();
 		}
 		else	//非樹狀顯示
 		{
 			$html .= $this->getAllItems();
 		}
 		$preTag="<select id=\"".$this->id."\" name=\"".$this->id."\"";
 		foreach($this->clientAttributes as $arr)
 		{
 			$preTag .= " ".$arr["name"]."=\"".$arr["value"]."\"";
 		}
 		
 		$preTag .= ">\r\n";
 		$html = $preTag.$html."</select>\r\n";
 		return $html;
 	}
 	
 	//添加客戶端屬性
 	public function addClientAttribute($name,$value)
 	{
 		$arr["name"]=$name;
 		$arr["value"]=$value;
 		$this->clientAttributes[]=$arr;
 	}
 	//呈現控件
 	public function render()
 	{
 		echo $this->getContent();
 	} 
 	
 	//取得樹狀數據所有項
 	private function getTreeItems()
 	{
 		$returnValue="";
 		foreach($this->dataSource as $arr)
 		{
 			$rootArray=array();
 			if(isset($this->rootID))
 			{
 				$rootArray[0]=$this->rootID;
 			}
 			else
 			{
 				$rootArray[0]="";
 				$rootArray[1]="0";
 				$rootArray[2]=null;
 			} 	
			
			if(in_array($arr[$this->pidField],$rootArray))
			{
				//取根的下一級選項
				if($this->selectedValue == $arr[$this->valueField])
	 			{
	 				$returnValue .= "<option  class=\"menu\" value=\"".$arr[$this->valueField]."\" selected=\"selected\">".$arr[$this->titleField]."</option>\r\n";
	 			}
	 			else
	 			{
	 				$returnValue .= "<option  class=\"menu\" value=\"".$arr[$this->valueField]."\">".$arr[$this->titleField]."</option>\r\n";
	 			}
	 			
	 			//取所有子選項
	 			$returnValue .= $this->getItems($arr[$this->idField],1);
			}			
 		}
 		return $returnValue;
 	}
 	
 	//根據父ID取得子選項
 	private function getItems($pid,$level)
 	{
 		$returnValue="";
 		//選項縮進符
 		$sep="";
 		for($i=0;$i<$level;$i++)
 		{
 			$sep .= $this->separator;
 		}
 		foreach($this->dataSource as $arr)
 		{
 			if($arr[$this->pidField]==$pid)
 			{
 				if($this->selectedValue == $arr[$this->valueField])
	 			{
	 				$returnValue .= "<option  class=\"menu_".$level."\" value=\"".$arr[$this->valueField]."\" selected=\"selected\">".$sep.$arr[$this->titleField]."</option>\r\n";
	 			}
	 			else
	 			{
	 				$returnValue .= "<option class=\"menu_".$level."\" value=\"".$arr[$this->valueField]."\">".$sep.$arr[$this->titleField]."</option>\r\n";
	 			}
	 			
	 			//遞迴取得子選項
	 			$returnValue .= $this->getItems($arr[$this->idField],$level+1);
 			}
 		}
 		return $returnValue;
 	}
 	
 	//取得所有項,不區分上下級
 	private function getAllItems()
 	{
 		$returnValue="";
 		foreach($this->dataSource as $arr)
 		{
 			if($this->selectedValue == $arr[$this->valueField])
 			{
 				$returnValue .= "<option value=\"".$arr[$this->valueField]."\" selected=\"selected\">".$arr[$this->titleField]."</option>\r\n";
 			}
 			else
 			{
 				$returnValue .= "<option value=\"".$arr[$this->valueField]."\">".$arr[$this->titleField]."</option>\r\n";
 			}
 		}
 		return $returnValue;
 	}
 }
?>
