<?php
	require_once "pageBase.php";
	require_once "bin/web/repeater.php";
	require_once "dal/bookDAL.php";
	require_once "dal/book_categoryDAL.php";

	class _book extends pageBase{
		public function load(){
			$this->loadData();
			parent::load();
		}
		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/book.html");

			//橫幅廣告
			$this->picturetype = "80";

			//宣告
			$dal = new bookDAL();
			$dalC = new book_categoryDAL();
			$id = parent::getPageParameter("id","");
			$pageIndex = (int)parent::getPageParameter("p","1");
			if(isset($this->registry->bookPageSize) && $this->registry->bookPageSize != "" && $this->registry->bookPageSize != "0"){
				$pageSize = (int)$this->registry->bookPageSize;
			}else{
				$pageSize = 20;
			}
			$start = ($pageIndex - 1) * $pageSize;
			parent::addParameter("htLink",$this->htLink5);

			//條件式
			$filter = "a.`Visible`='1' AND b.`Visible`='1'";
			if($id != "" && $id != "0"){
				$filter .= " AND a.`CategoryID`='".$id."'";
			}
			$orderExp = "a.`OrderNO`,b.`OrderNO`,a.`BookID` DESC";

			//影音相本分類資訊
			if($id != "" && $id != "0"){
				$dalC->CategoryID = $id;
				$dalC->loadRecord();
				if($dalC->Visible != "1"){
					parent::alert2("頁面不存在!!",$this->htLink5.".html");
					exit;
				}
				parent::addParameter("CategoryName",$dalC->CategoryName);
				if(trim($dalC->WebTitle) != ""){
					parent::addParameter("webTitle",$dalC->WebTitle);
				}
				if(trim($dalC->WebKeyword) != ""){
					parent::addParameter("webKeyword",$dalC->WebKeyword);
				}
				if(trim($dalC->WebDescription) != ""){
					parent::addParameter("webDescription",$dalC->WebDescription);
				}
			}else{
				parent::addParameter("CategoryName","影音相本");
			}

			//影音相本分類列表
			$dataC = $dalC->executeRecordset("a.`Visible`='1'");
			for($i=0;$i<count($dataC);$i++){
				$dataC[$i]["htLink"] = $this->htLink5;
				if($dataC[$i]["CategoryID"] == $id){
					$dataC[$i]["className"] = " class='action'";
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			//影音相本列表
			$data = $dal->executeRecordset($filter,$orderExp,$start,$pageSize);
			for($i=0;$i<count($data);$i++){
				$data[$i]["htLink"] = $this->htLink5;
				if(trim($data[$i]["Image"]) == "" || !file_exists(".".$data[$i]["Image"])){
					$data[$i]["Image"] = "/images/no-pic.jpg";
				}else{
					$data[$i]["imageStyle"] = "";
				}
			}
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			//分頁
			$pageRange = 10;							//分頁範圍
			$rowCount = $dal->countRecordset($filter);
			$nm1 = $rowCount % $pageSize;				//取得不滿一頁的資料筆數
			$nm2 = ($rowCount - $nm1) / $pageSize;		//取得總頁數(目前是滿頁的頁數)
			if($nm1 > 0){								//如果有不滿一頁的資料，總頁數加一
				$nm2 = $nm2 + 1;
			}
			$nm3 = $pageIndex % $pageRange;				//取得頁數在分頁範圍的位置
			$nm4 = ($pageIndex - $nm3) / $pageRange;	//取得頁數在第幾個分頁範圍
			if($nm3 == 0){								//頁數在分頁範圍最後時，第幾個分頁範圍需要減一
				$nm4 = $nm4 - 1;
			}
			////檢查是否超過範圍
			if($rowCount > 0){
				if($pageIndex > $nm2 || $pageIndex < 1){
					parent::alert2("頁面不存在!", $this->htLink5.$id.".html");
					exit;
				}
			}else{
				if($pageIndex != 1){
					parent::alert2("頁面不存在!", $this->htLink5.$id.".html");
					exit;
				}
			}
			////上一頁////
			$pagtxt = "<a class=\"prev\" href='".$this->htLink5.$id."_";
			if($pageIndex == 1){
				$pagtxt .= "1";
			}else{
				$pagtxt .= ($pageIndex - 1);
			}
			$pagtxt .= ".html'><i class=\"fa fa-angle-double-left\"></i></a>";
			////分頁範圍////
			for($i=1;$i<=$pageRange;$i++){
				if($nm4 * $pageRange + $i == $pageIndex){
					$pagtxt .= "<strong>".($nm4 * $pageRange + $i)."</strong>";
				}else{
					$pagtxt .= "<a href='".$this->htLink5.$id."_".($nm4 * $pageRange + $i).".html'>".($nm4 * $pageRange + $i)."</a>";
				}
				if($nm4 * $pageRange + $i == $nm2){
					$i = $pageRange + 1;
				}
			}
			////下一頁////
			$pagtxt .= "<a class=\"next\" href='".$this->htLink5.$id."_";
			if($pageIndex == $nm2){
				$pagtxt .= $pageIndex;
			}else{
				$pagtxt .= ($pageIndex + 1);
			}
			$pagtxt .= ".html'><i class=\"fa fa-angle-double-right\"></i></a>";
			if($rowCount == 0){							////如果沒有任何資料時
				$pagtxt = "目前暫無資料!!";
			}
			parent::addParameter("pagtxt",$pagtxt);

			//父類方法蘋果也界有限公司
			parent::loadData();
		}
	}

	$page = new _book();
	$page->load();
	$page->render();
?>