<?php
	require_once "pageBase.php";
	require_once "bin/web/repeater.php";
	require_once "dal/bookDAL.php";
	require_once "dal/book_categoryDAL.php";
	require_once "dal/photoDAL.php";

	class _bookdetail extends pageBase{
		public function load(){
			$this->loadData();
			parent::load();
		}
		public function loadData(){
			//加載模板
			parent::loadTemplateFile("templates/".$this->registry->webTemplates."/book-detail.html");

			//橫幅廣告
			$this->picturetype = "80";

			//宣告
			$dal = new bookDAL();
			$dalC = new book_categoryDAL();
			$dalP = new photoDAL();
			$id = parent::getPageParameter("id","0");
			$id = str_replace("'", "", $id);
			$id = str_replace("\"", "", $id);
			$id = str_replace("\\", "", $id);
			$pageIndex = (int)parent::getPageParameter("p","1");
			if(isset($this->registry->bookPageSize) && $this->registry->bookPageSize != "" && $this->registry->bookPageSize != "0"){
				$pageSize = (int)$this->registry->bookPageSize;
			}else{
				$pageSize = 20;
			}
			$start = ($pageIndex - 1) * $pageSize;
			parent::addParameter("htLink",$this->htLink5);

			//影音相本
			if($id == "0"){
				parent::alert2("頁面不存在!!",$this->htLink5.".html");
				exit;
			}else{
				$dal->BookID = $id;
				$dal->loadRecord();
				if($dal->Visible != "1"){
					parent::alert2("頁面不存在!!",$this->htLink5.".html");
					exit;
				}else{
					$dalC->CategoryID = $dal->CategoryID;
					$dalC->loadRecord();
					if($dalC->Visible != "1"){
						parent::alert2("頁面不存在!!",$this->htLink5.".html");
						exit;
					}else{
						//相本資訊
						parent::addParameter("CategoryID",$dal->CategoryID);
						parent::addParameter("CategoryName",$dal->CategoryName);
						parent::addParameter("BookName",$dal->BookName);
						$description = str_replace("\r\n","<br />",$dal->Description);
						parent::addParameter("Description",$description);
						if(trim($dal->Image) == "" || !file_exists(".".$dal->Image)){
							parent::addParameter("Image","/images/no-pic.jpg");
							parent::addParameter("imageStyle"," style='display:none;'");
						}else{
							parent::addParameter("Image",$dal->Image);
							parent::addParameter("imageStyle","");
						}
						if(trim($dal->WebTitle) != ""){
							parent::addParameter("webTitle",$dal->WebTitle);
						}
						if(trim($dal->WebKeyword) != ""){
							parent::addParameter("webKeyword",$dal->WebKeyword);
						}
						if(trim($dal->WebDescription) != ""){
							parent::addParameter("webDescription",$dal->WebDescription);
						}

						//相片/影音列表
						$dataP = $dalP->executeRecordset("a.`BookID`='".$id."' AND a.`Visible`='1'");
						for($i=0;$i<count($dataP);$i++){
							if($dataP[$i]["PhotoType"] == "2"){
								$dataP[$i]["attr"] = "><a class=\"popup-youtube photo\"";
								$dataP[$i]["Image"] = str_replace("youtu.be/","img.youtube.com/vi/",$dataP[$i]["Movie"])."/0.jpg";
								$dataP[$i]["Link"] = str_replace("youtu.be/","www.youtube.com/watch?v=",$dataP[$i]["Movie"]."?autoplay=1");
								$dataP[$i]["imageStyle"] = "";
							}else{
								if(trim($dataP[$i]["Image"]) != "" && file_exists(".".$dataP[$i]["Image"])){
									$dataP[$i]["imageStyle"] = "";
								}else{
									$dataP[$i]["Image"] = "/images/no-pic.jpg";
									$dataP[$i]["imageStyle"] = " style='display:none;'";
								}
								$dataP[$i]["attr"] = " class=\"popup-img\"><a class=\"photo\"";
								$dataP[$i]["Link"] = $dataP[$i]["Image"];
							}
						}
						$listP = new repeater();
						$listP->id = "listP";
						$listP->dataSource = $dataP;
						parent::addControl($listP);
					}
				}
			}

			//影音相本分類列表
			$dataC = $dalC->executeRecordset("a.`Visible`='1'");
			for($i=0;$i<count($dataC);$i++){
				$dataC[$i]["htLink"] = $this->htLink5;
				if($dataC[$i]["CategoryID"] == $dal->CategoryID){
					$dataC[$i]["className"] = " class='action'";
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);
			
			//分頁
			$pageRange = 10;							//分頁範圍
			$rowCount = $dal->countRecordset($filter);
			$nm1 = $rowCount % $pageSize;				//取得不滿一頁的資料筆數
			$nm2 = ($rowCount - $nm1) / $pageSize;		//取得總頁數(目前是滿頁的頁數)
			if($nm1 > 0){								//如果有不滿一頁的資料，總頁數加一
				$nm2 = $nm2 + 1;
			}
			$nm3 = $pageIndex % $pageRange;				//取得頁數在分頁範圍的位置
			$nm4 = ($pageIndex - $nm3) / $pageRange;	//取得頁數在第幾個分頁範圍
			if($nm3 == 0){								//頁數在分頁範圍最後時，第幾個分頁範圍需要減一
				$nm4 = $nm4 - 1;
			}
			////上一頁////
			$pagtxt = "<a class=\"prev\" href='".$this->htLink5.$id."_";
			if($pageIndex == 1){
				$pagtxt .= "1";
			}else{
				$pagtxt .= ($pageIndex - 1);
			}
			$pagtxt .= ".html'><i class=\"fa fa-angle-double-left\"></i></a>";
			////分頁範圍////
			for($i=1;$i<=$pageRange;$i++){
				if($nm4 * $pageRange + $i == $pageIndex){
					$pagtxt .= "<strong>".($nm4 * $pageRange + $i)."</strong>";
				}else{
					$pagtxt .= "<a href='".$this->htLink5.$id."_".($nm4 * $pageRange + $i).".html'>".($nm4 * $pageRange + $i)."</a>";
				}
				if($nm4 * $pageRange + $i == $nm2){
					$i = $pageRange + 1;
				}
			}
			////下一頁////
			$pagtxt .= "<a class=\"next\" href='".$this->htLink5.$id."_";
			if($pageIndex == $nm2){
				$pagtxt .= $pageIndex;
			}else{
				$pagtxt .= ($pageIndex + 1);
			}
			$pagtxt .= ".html'><i class=\"fa fa-angle-double-right\"></i></a>";
			if($rowCount == 0){							////如果沒有任何資料時
				$pagtxt = "目前暫無資料!!";
			}
			parent::addParameter("pagtxt",$pagtxt);

			//父類方法
			parent::loadData();
		}
	}

	$page = new _bookdetail();
	$page->load();
	$page->render();
?>