<?php
/*--------------------------------------------------------- 
 * File:authority.php
 * Author:Tomix
 * Description: 身份驗證核心類
 * Created:2009
 * -------------------------------------------------------
 * Modified history:
 * -------------------------------------------------------
 * Copyright:
 * -------------------------------------------------------
 */
 require_once dirname(__FILE__)."/bllBase.php";
 require_once dirname(__FILE__)."/../bin/system/utility.php";
 require_once dirname(__FILE__)."/../modules/sessionKeys.php";
 class authority extends bllBase
 {
 	//用戶登錄.
 	//參數說明:$logMode:0表以LoginName登錄;1表以Email地址登錄
 	//返回值:1，用戶不存在；2密碼錯誤；登錄成功返回用戶信息對象
 	static public function login($account,$password,$logMode=0)
 	{
 		require_once dirname(__FILE__)."/../dal/userDAL.php";
 		$user=new userDAL();
 		if($logMode==0)
 			$user->LoginName=$account;
 		else if($logMode==1)
 			$user->Email=$account;
 		$user->loadRecord();
 		
 		if(!isset($user->UserID) 
 			|| $user->UserID == "" 
 			|| $user->UserID == 0 
 			|| ($user->Flags & 1) >0)
 		{
 			return -1;	//1表示用戶不存在
 		}
 		else if(!utility::checkEncrypt($password,$user->Password))
 		{ 			
 			return -2;	//2表示密碼錯誤
 		}
 		else if(($user->Flags & 1) == 1)
 		{
 			return -3;	//2表示帳號已經被鎖定
 		}
 		else
 		{
 			//更新用戶登錄信息
 			$user->LoginTimes++;
 			$user->LastLoginTime=date("Y-m-d H:i:s");
 			$user->LastLoginIp=$_SERVER["REMOTE_ADDR"];
 			$user->updateRecord();
 			
 			//保存用戶對象到session(userid,email)
 			session_start();
 			
 			$_SESSION[sessionKeys::$userID]=$user->UserID;
 			$_SESSION[sessionKeys::$userEmail]=$user->Email;
 		 			
 			return true; 			
 		}
 	}
 	static public function logout()
 	{
 		session_start();
 		$_SESSION[sessionKeys::$userID]=null;
 	}
 }
?>
