<?php
	require_once dirname(__FILE__)."/template.php";
	require_once dirname(__FILE__)."/control.php";
	class page{
		//受保護屬性：頁面文檔內容
		protected $pageContent;

		//受保護屬性：頁面模版內容
		protected $template;

		//受保護屬性：頁面模版文件
		protected $templateFile;

		//私有屬性:模版類
		private $tmpManager;

		//私有屬性:頁面參數集
		private $parameters = array();

		//私有屬性:頁面控件集
		private $controls = array();

		//控件類名
		private $controlClassName = "control";

		//公開構造函數
		//參數$template為模版內容,也可以隨後再調用loadTemplate()方法加載模版內容
		public function page($template=""){
			$this->tmpManager = new template();

			if(isset($template) && $template != ""){
				$this->template = $template;
			}
		}

		//公開方法：呈現頁面
		public function render(){
			echo $this->pageContent;
		}

		//公開方法:取得頁面文檔內容
		public function getContent(){
			return $this->pageContent;
		}

		//公開方法:從模版內容加載模版	
		public function loadTemplate($template){
			$this->template = $template;
		}

		//公開方法:從模版文件加載模版
		public function loadTemplateFile($fileName){
			$this->templateFile = $fileName;
			if(file_exists($fileName)){
				$handler = fopen($fileName,"rb");
				$this->template = fread($handler,filesize($fileName));
				fclose($handler);
			}
		}

		//公開方法:添加頁面參數
		public function addParameter($name,$value){
			$arr = array();
			$arr["name"] = $name;
			$arr["value"] = $value;

			$this->parameters[] = $arr;
		}

		//公開方法:獲取頁面參數
		public function getParameter($name){
			foreach($this->parameters as $parameter){
				if($parameter["name"] == $name)
					return $parameter["value"];
			}
		}

		//公開方法:添加頁面控件
		//參數$control為控件實例名
		public function addControl($control){
			$this->controls[] = $control;
		}


		//公開方法:加載頁面
		public function load(){
			$this->tmpManager->template = $this->template;
			foreach($this->parameters as $parameter){
				$this->tmpManager->addElement($parameter["name"],$parameter["value"]);
			}
			for($i=0;$i<count($this->controls);$i++){
				$control = $this->controls[$i];
				if(!class_exists($this->controlClassName) || !is_a($control,$this->controlClassName))
					continue;
				$content = $this->tmpManager->addControl("control_".$i,$control->tagPrefix,$control->tagName,$control->id);
				$control ->template = $content;
				$control->load();
				$this->tmpManager->loadControl("control_".$i,$control->getContent());
			}

			$this->pageContent = $this->tmpManager->getContent();
		}

		//公開方法:允許訪問
		public function allowAccess(){
			return true;
		}

		//公開方法:權限檢查
		public function checkAccess($userId,$resourceId,$actionId){
			return false;
		}

		//頁面重定向
		public function redirect($url){
			echo "<script language=\"javascript\">location.replace(\"".$url."\");</script>";
			exit;
		}

		//頁面是否POST回放
		public function isPostBack(){
			return strtoupper($_SERVER['REQUEST_METHOD']) == "POST";
		}

		//公開方法:悉放對象
		public function dispose(){
			//這裡添加需要悉放的頁面對象,以悉放內存空間
		}
	}
?>