<?php
/*---------------------------------------------------------
* File:databaseFactory.php
* Author:Tomix,邱洪榮
* Description: database工廠类
* 				創建資料庫實例，如果已經存在了一個實例，則返回當前實例
* Created:2009-5-12
* -------------------------------------------------------
* Modified history:
* -------------------------------------------------------
* Copyright:
* -------------------------------------------------------
*/

	//配置工廠類
	require_once dirname(__FILE__)."/../configuration/configFactory.php";

	//資料庫核心類
	require_once dirname(__FILE__)."/database.php";

	class databaseFactory{
		static private $database;
		public function databaseFactory(){
		}

		//創建數據庫實例
		static public function createDatabase(){
			if(!isset(self::$database) || !self::$database->ping()){
				$config = configFactory::createConfiguration();

				$dbHost = $config->getConfigValue("data","dbHost");
				$dbUser = $config->getConfigValue("data","dbUser");
				$dbPwd = $config->getConfigValue("data","dbPassword");
				$dbName = $config->getConfigValue("data","dbName");
				$dbCharset = $config->getConfigValue("data","dbCharset");

				self::$database = new database($dbHost,$dbUser,$dbPwd,$dbName,$dbCharset);
				if(!self::$database->ping()){
					//throw new exception("Failed to connect to database!");
					echo "Failed to connect to database!";
					exit;
				}
				//self::$database=new database($dbHost,$dbUser,$dbPwd,$dbName,$dbPort,$dbSocket,$dbCharset);//創建基於mysqli數據庫實例
			}
			return self::$database;
		}
	}
?>