<?php
/*---------------------------------------------------------
* File:database.php
* Author:Tomix,邱洪榮
* Description: 數據庫操作類(支持事務處理)
* 				該類實例化時會新建連接,使用mysql_connect()函數連接到數據庫
* Created:2009-5-4
* -------------------------------------------------------
* Modified history:
* 2009.6.19  因為mysqli兼容性問題,把繼承自mysqli類去掉,使用msyql 普通的連接
* -------------------------------------------------------
* Copyright:
* -------------------------------------------------------
*/


	//數據庫類,繼承自mysqli
	class database{
		//資料庫版本號
		public $version;

		//錯誤信息
		public $error;

		//當前實例的連接句柄
		public $connection;

		//構造函數
		public function database($host,$user,$password,$name,$charset){
			//連接數據庫
			$this->connection = @mysql_connect($host,$user,$password);

			//取數據庫版本
			$this->version = @mysql_get_server_info();

			//選擇數據庫
			@mysql_select_db($name,$this->connection);

			//設置字符集編碼
			if(isset($charset) && $charset != ""){
				if($this->version > "4.1" && isset($charset) && $charset != ""){
					@mysql_query("SET NAMES '".$charset."'",$this->connection);
				}
				if($this->dbVersion > "5.0.1") {
					@mysql_query("SET sql_mode=''",$this->connection);
				}
			}
		}

		//Ping 一個服務器連接
		public function ping(){
			return @mysql_ping($this->connection);
		}

		//執行sql語句,返回結果集
		public function execute($sql,$writeLog=false){
			$result = @mysql_query($sql,$this->connection);
			$err = @mysql_error($this->connection);
			if($err){
				$this->error .= $err."\r\n";
				$this->logError($err."\r\nsql:".$sql);
			}else{
				if($writeLog)
					$this->logExecute($sql);
			}
			return $result;
		}

		//執行sql語句,返回第一行第一列記錄
		public function executeScalar($sql){
			$result = $this->execute($sql);
			$rs = @mysql_fetch_array($result);
			return $rs[0];
		}

		//執行sql語句,返回第一行記錄
		public function executeReader($sql){
			$result = $this->execute($sql);
			$rs = @mysql_fetch_array($result);
			return $rs;
		}

		//執行sql語句,返回影響記錄數
		public function executeNonQuery($sql,$writeLog=false){
			$this->execute($sql,$writeLog);
			return @mysql_affected_rows($this->connection);
		}

		//執行sql語句，以數組形式返回結果集
		//參數說明:$sql,SQL語句;$start,開始記錄 號;$length,返回記錄數
		public function executeRecordset($sql,$start=0,$length=-1){
			if($start >= 0 && $length >= 0)
				$sql .= " LIMIT ".$start.",".$length;
			$result = $this->execute($sql);
			$rs = array();
			while($arr=@mysql_fetch_array($result)){
				$rs[] = $arr;
			}
			return $rs;
		}

		// 取得上一步 INSERT 操作產生的 ID
		public function getInsertID(){
			return mysql_insert_id($this->connection);
		}

		//開始事務
		public function beginTransaction(){
			@mysql_query("START TRANSACTION",$this->connection);
		}

		//提交事務
		public function commitTransaction(){
			@mysql_query("COMMIT",$this->connection);
		}

		//回滾事務
		public function rollbackTransaction(){
			@mysql_query("ROLLBACK",$this->connection);
		}

		//寫入日誌文件
		private function logError($error){
			$msg = "\r\n=============================================================================\r\n";
			$msg .= "Time:".(string)date("Y-m-d H:i:s")."\r\n";
			$msg .= "Type:sql error\r\n";
			$msg .= "Message:\r\n";
			$msg .= $error;

			$path = dirname(__FILE__)."/../../logs/";
			if(!is_dir($path))
				@mkdir($path,0777);
			$fn = $path."err_".(string)date("Ymd").".log";
			$fp = fopen($fn,"ab");
			fwrite($fp,$msg);
			fclose($fp);
		}

		//操作日誌記錄
		private function logExecute($message){
			$msg = "\r\n=============================================================================\r\n";
			$msg .= "Time:".(string)date("Y-m-d H:i:s")."\r\n";
			$msg .= "Type:sql query\r\n";
			$msg .= "Message:\r\n";
			$msg .= $message;

			$path = dirname(__FILE__)."/../../logs/";
			//$path="logs";
			if(!is_dir($path))
				@mkdir($path,0777);
			$fn = $path."query_".(string)date("Ymd").".log";
			$fp = fopen($fn,"ab");
			fwrite($fp,$msg);
			fclose($fp);
		}
	}
?>