<?php
/*---------------------------------------------------------
* File:Configuration.php
* Author:Tomix
* Description: 應用程序配置類
* Created:2009-5-14
* -------------------------------------------------------
* Modified history:
* -------------------------------------------------------
* Copyright:
* -------------------------------------------------------
*/

	//應用程序配置類
	class configuration{
		//xml配置文件數據,數組
		protected $configData;

		//構造函數,$configFile參數為配置xml文件名
		public function configuration($configFile){
			if(file_exists($configFile)){
				$this->initConfig($configFile);
			}else{
				throw new Exception("Fail to load configuration file!");
			}
		}

		//根據配置節和鍵值讀取配置值
		public function getConfigValue($section,$name){
			return $this->configData[$section][$name];
		}

		//根據配置節返回配置數據(鍵值對數組)
		public function getSectionData($section){
			return $this->configData[$section];
		}

		//讀取xml配置文件來初始化類
		private function initConfig($configFile){
			$doc = new DOMDocument();
			$doc->load($configFile);
			$sectionNode = $doc->getElementsByTagName("configSections");
			if($sectionNode->length > 0){
				$sections = $sectionNode->item(0)->getElementsByTagName("*");
				foreach($sections as $section){
					$name = $section->getAttribute("name");
					$value = $section->getAttribute("value");
					$this->configData[$name] = $this->getSectionArray($doc,$value);
				}
			}
		}

		//根據節點名取得該節點下的配置鍵值對數組
		private function getSectionArray($DOMDocument,$section){
			$arr = array();
			$sectionNode = $DOMDocument->getElementsByTagName($section);
			if($sectionNode->length > 0){
				$sections = $sectionNode->item(0)->getElementsByTagName("*");
				foreach($sections as $section){
					$name = $section->getAttribute("name");
					$value = $section->getAttribute("value");
					$arr[$name] = $value;
				}
			}
			return $arr;
		}
	}
?>