<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/registryDAL.php";
	class _websiteSet extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('37')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}
		public function loadData(){
			$productPageSize = registryDAL::getRegistryValue("productPageSize");
			if($productPageSize == ''){
				$productPageSize = '20';
			}
			
			$newsPageSize = registryDAL::getRegistryValue("newsPageSize");
			if($newsPageSize == ''){
				$newsPageSize = '10';
			}
			
			$faqPageSize = registryDAL::getRegistryValue("faqPageSize");
			if($faqPageSize == ''){
				$faqPageSize = '10';
			}
			
			$bookPageSize = registryDAL::getRegistryValue("bookPageSize");
			if($bookPageSize == ''){
				$bookPageSize = '20';
			}
			parent::addParameter("indexListType",$indexListType);
			parent::addParameter("productPageSize",$productPageSize);
			parent::addParameter("newsPageSize",$newsPageSize);
			parent::addParameter("faqPageSize",$faqPageSize);
			parent::addParameter("bookPageSize",$bookPageSize);
			
			$categorySidePageShow = registryDAL::getRegistryValue("categorySidePageShow");
			$aryCSPS = explode(",",$categorySidePageShow);
			$dataCSPS = array();
			foreach($aryCSPS as $value){
				$dataCSPS[]["Value"] = $value;
			}
			$listCSPS = new repeater();
			$listCSPS->id = "listCSPS";
			$listCSPS->dataSource = $dataCSPS;
			parent::addControl($listCSPS);
			
			parent::loadTemplateFile(dirname(__FILE__)."/templates/websiteSet.html");
			parent::loadData();
		}
		public function saveData(){
			$productPageSize = conver::toDbString(trim($_POST["productPageSize"]));
			$newsPageSize = conver::toDbString(trim($_POST["newsPageSize"]));
			$faqPageSize = conver::toDbString(trim($_POST["faqPageSize"]));
			$bookPageSize = conver::toDbString(trim($_POST["bookPageSize"]));
			$aryCSPS = $_POST["categorySidePageShow"];
			if(isset($aryCSPS)){
				$categorySidePageShow = implode(",",$aryCSPS);
			}else{
				$categorySidePageShow = "";
			}
			registryDAL::saveRegistry("productPageSize",$productPageSize);
			registryDAL::saveRegistry("newsPageSize",$newsPageSize);
			registryDAL::saveRegistry("faqPageSize",$faqPageSize);
			registryDAL::saveRegistry("bookPageSize",$bookPageSize);
			registryDAL::saveRegistry("categorySidePageShow",$categorySidePageShow);
			parent::alert2("儲存完畢!","websiteSet.php");
		}
	}

	$page = new _websiteSet();
	$page->load();
	$page->render();
?>