<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../dal/pictureDAL.php";
	class _webpageSet extends pageBase{
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('40')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->dal = new pictureDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			for($i=4;$i<11;$i++){
				$this->dal->PictureType = $i * 10;
				$this->dal->TypeOrderNO = "0";
				$this->dal->loadRecord();
				parent::addParameter("Image".$i,$this->dal->Image);
				parent::addParameter("Title".$i,$this->dal->Title);
				parent::addParameter("Link".$i,$this->dal->Link);
			}

			parent::loadTemplateFile(dirname(__FILE__)."/templates/webpageSet.html");
			parent::loadData();
		}
		public function saveData(){
			$this->dal->TypeOrderNO = "0";
			for($i=4;$i<11;$i++){
				$this->dal->PictureType = $i * 10;
				$this->dal->Image = conver::toDbString(trim($_POST["Image".$i]));
				$this->dal->Title = conver::toDbString(trim($_POST["Title".$i]));
				$this->dal->Link = conver::toDbString(trim($_POST["Link".$i]));
				$this->dal->replaceRecord();
			}

			parent::redirect("webpageSet.php");
		}
	}

	$page = new _webpageSet();
	$page->load();
	$page->render();
?>