<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../dal/webmenuDAL.php";
	class _webmenuSet extends pageBase{
		private $dal;
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('31')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->dal = new webmenuDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();
			parent::load();
		}
		public function loadData(){
			for($i=1;$i<9;$i++){
				$this->dal->MenuID = $i;
				$this->dal->loadRecord();
				if($this->dal->MenuID == $i){
					parent::addParameter("MenuType".$i,$this->dal->MenuType);
					parent::addParameter("MenuTitle".$i,$this->dal->MenuTitle);
					parent::addParameter("SubTitle".$i,$this->dal->SubTitle);
					parent::addParameter("MenuLink".$i,$this->dal->MenuLink);
					parent::addParameter("SubMenu".$i,$this->dal->SubMenu);
					parent::addParameter("Visible".$i,$this->dal->Visible);
				}else{
					parent::addParameter("MenuType".$i,"0");
					parent::addParameter("SubMenu".$i,"0");
					parent::addParameter("Visible".$i,"0");
				}
			}

			parent::addParameter("link1",$this->htLink4.".html");
			parent::addParameter("link2",$this->htLink2.".html");
			parent::addParameter("link3",$this->htLink3.".html");
			parent::addParameter("link4",$this->htLink5.".html");
			parent::addParameter("link5",$this->htLink6.".html");
			parent::addParameter("link6",$this->htLink7.".html");

			parent::loadTemplateFile(dirname(__FILE__)."/templates/webmenuSet.html");
			parent::loadData();
		}
		public function saveData(){
			for($i=1;$i<9;$i++){
				$this->dal->MenuID = $i;
				$this->dal->MenuType = conver::toDbString(trim($_POST["MenuType".$i]));
				$this->dal->MenuTitle = conver::toDbString(trim($_POST["MenuTitle".$i]));
				$this->dal->SubTitle = conver::toDbString(trim($_POST["SubTitle".$i]));
				switch($this->dal->MenuType){
					case "0":
						$this->dal->MenuLink = conver::toDbString(trim($_POST["MenuLink".$i]));
						break;
					case "1":
						$this->dal->MenuLink = $this->htLink4.".html";
						break;
					case "2":
						$this->dal->MenuLink = $this->htLink2.".html";
						break;
					case "3":
						$this->dal->MenuLink = $this->htLink3.".html";
						break;
					case "4":
						$this->dal->MenuLink = $this->htLink5.".html";
						break;
					case "5":
						$this->dal->MenuLink = $this->htLink6.".html";
						break;
					case "6":
						$this->dal->MenuLink = $this->htLink7.".html";
						break;
				}
				if($this->dal->MenuType == "0"){
					$this->dal->SubMenu = "0";
				}else{
					$this->dal->SubMenu = conver::toDbString(trim($_POST["SubMenu".$i]));
				}
				if($this->dal->MenuTitle == ""){
					$this->dal->Visible = "0";
				}else{
					$this->dal->Visible = conver::toDbString(trim($_POST["Visible".$i]));
				}
				$this->dal->OrderNO = $i;
				$this->dal->replaceRecord();
			}
			parent::alert2("儲存完畢!","webmenuSet.php");
		}
	}

	$page = new _webmenuSet();
	$page->load();
	$page->render();
?>