<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../dal/registryDAL.php";
	class _webbaseSet extends pageBase{
		private $dal;
		public function load(){
			if(!parent::chkUserLimit('29')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();
			parent::load();
		}
		public function loadData(){
			$webConfig = registryDAL::getRegistryValues();
			$keys = array_keys($webConfig);
			$values = array_values($webConfig);
			for($i=0;$i<count($webConfig);$i++){
				parent::addParameter($keys[$i],$values[$i]);
			}
			
			$loadpag = (parent::getCurrentUserID() == 1) ?"webbaseSet.html":"webbaseSet2.html";
			parent::loadTemplateFile("templates/".$loadpag);
			parent::loadData();
		}
		public function saveData(){
			$keys = array_keys($_POST);
			$values = array_values($_POST);
			for($i=0;$i<count($_POST);$i++){
				registryDAL::saveRegistry($keys[$i],conver::toDbString($values[$i]));
			}
			if($_POST["webEmailisShow"] != "1"){
				registryDAL::saveRegistry("webEmailisShow","0");
			}
			if($_POST["webAddressisShow"] != "1"){
				registryDAL::saveRegistry("webAddressisShow","0");
			}
			if($_POST["webPhoneisShow"] != "1"){
				registryDAL::saveRegistry("webPhoneisShow","0");
			}
			if($_POST["webFaxisShow"] != "1"){
				registryDAL::saveRegistry("webFaxisShow","0");
			}
			if($_POST["sendMailType"] == "1"){
				registryDAL::saveRegistry("sendMailAddress","");
				registryDAL::saveRegistry("sendMailPassword","");
				registryDAL::saveRegistry("sendMailHost","");
				registryDAL::saveRegistry("sendMailPort","");
				registryDAL::saveRegistry("sendMailSMTPSecure","");
				registryDAL::saveRegistry("sendMailSMTPAuth","");
			}
			registryDAL::saveRegistry("ModifiedTime",date("Y-m-d H:i:s"));
			parent::alert2("儲存完畢!","webbaseSet.php");
		}
	}
	$page = new _webbaseSet();
	$page->load();
	$page->render();
?>