<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/limitDAL.php";
	require_once "../dal/menuDAL.php";
	require_once "../dal/userDAL.php";

	class _userView extends pageBase{
		private $id,$pUrl;
		private $dal,$dalL;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('14')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->id = parent::getPageParameter("id","0");
			$this->pUrl = urldecode(parent::getPageParameter("pUrl","userList.php"));
			$this->dal = new userDAL();
			$this->dalL = new limitDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->UserID = $this->id;
				$this->dal->loadRecord();

				parent::addParameter("LoginName",$this->dal->LoginName);
				parent::addParameter("Password",$this->dal->Password);
				parent::addParameter("UserName",$this->dal->UserName);
				parent::addParameter("Email",$this->dal->Email);
				parent::addParameter("Visible",$this->dal->Visible);

				$dalM = new menuDAL();
				$menuList = "";
				$dataM1 = $dalM->executeRecordset("a.`ParentID`='0' AND a.`Visible`='1'","a.`OrderNO`");
				for($i=0;$i<count($dataM1);$i++){
					$menuList .= "<li>";
					$menuList .= "<input type=\"checkbox\" name=\"MenuID[]\" value=\"".$dataM1[$i]["MenuID"]."\"";
					if($this->dalL->countRecordset("a.`UserID`='".$this->id."' AND a.`MenuID`='".$dataM1[$i]["MenuID"]."'") > 0){
						$menuList .= " checked=\"checked\"";
					}
					$menuList .= ">".$dataM1[$i]["MenuName"];
					$dataM2 = $dalM->executeRecordset("a.`ParentID`='".$dataM1[$i]["MenuID"]."' AND a.`Visible`='1'","a.`OrderNO`");
					if(count($dataM2) > 0){
						$menuList .= "<ul>";
						for($j=0;$j<count($dataM2);$j++){
							$menuList .= "<li><input type=\"checkbox\" name=\"MenuID[]\" value=\"".$dataM2[$j]["MenuID"]."\"";
							if($this->dalL->countRecordset("a.`UserID`='".$this->id."' AND a.`MenuID`='".$dataM2[$j]["MenuID"]."'") > 0){
								$menuList .= " checked=\"checked\"";
							}
							$menuList .= ">".$dataM2[$j]["MenuName"]."</li>";
						}
						$menuList .= "</ul>";
					}
					$menuList .= "</li>";
				}
				parent::addParameter("menuList",$menuList);
			}else{
				parent::redirect($this->pUrl);
			}

			parent::addParameter("id",$this->id);
			parent::addParameter("pUrl",$this->pUrl);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/userView.html");

			//父類方法
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->UserID = $this->id;
				$this->dal->loadRecord();
				$this->dal->Password = conver::toDbString(trim($_POST["Password"]));
				$this->dal->UserName = conver::toDbString(trim($_POST["UserName"]));
				$this->dal->Email = conver::toDbString(trim($_POST["Email"]));
				$this->dal->Visible = conver::toDbString(trim($_POST["Visible"]));
				if(!$this->dal->updateRecord()){
					parent::alert("儲存時發生錯誤!");
				}else{
					$this->dalL->deleteRecord($this->id);
					$menuID = $_POST["MenuID"];
					if(is_array($menuID)){
						$this->dalL->UserID = $this->id;
						for($i=0;$i<count($menuID);$i++){
							$this->dalL->MenuID = conver::toDbString(trim($menuID[$i]));
							$this->dalL->insertRecord();
						}
					}
					parent::redirect($this->pUrl);
				}
			}else{
				parent::alert2("缺少重要參數!",$this->pUrl);
			}
		}
	}

	$page = new _userView();
	$page->load();
	$page->render();
?>