<?php
	require_once "pageBase.php";
	require_once "../dal/userDAL.php";
	require_once "../bin/web/repeater.php";
	require_once "../bin/system/utility.php";

	class _userList extends pageBase{
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('14')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->dal = new userDAL();

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			//過濾表達式
			$filter = "";

			//排序表達式
			$orderExp = "a.UserID";

			//取得資料
			$data = $this->dal->executeRecordset($filter,$orderExp,0,-1);
			$data = $this->formatData($data);
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			parent::addParameter("currentUrl",utility::getCurrentUrl());
			parent::addParameter("encodeUrl",urlencode( utility::getCurrentUrl()));
			parent::loadTemplateFile(dirname(__FILE__)."/templates/userList.html");

			//父類方法
			parent::loadData();
		}
		public function formatData($data){
			for($i=0;$i<count($data);$i++){
				if($data[$i]["Visible"] == "1")
					$data[$i]["Visible"] = "<span style=\"color:#090;\">&#10003</span>";
				else
					$data[$i]["Visible"] = "<span style=\"color:#f00;\">&#10005</span>";
				$data[$i]["encodeUrl"] = urlencode(utility::getCurrentUrl());
			}
			return $data;
		}
	}

	$page = new _userList();
	$page->load();
	$page->render();
?>