<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/system/utility.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/registryDAL.php";
	require_once "../dal/templateDAL.php";
	require_once "../dal/template_categoryDAL.php";
	class _templateSet extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('30')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			$dal = new templateDAL();
			$dalC = new template_categoryDAL();
			$id = parent::getPageParameter("id","0");
			$tid = registryDAL::getRegistryValue("webTemplates");
			
			//宣告
			$filter = "a.`Visible`='1' AND b.`Visible`='1'";
			if($id != "0"){
				$filter .= " AND a.`CategoryID`='".$id."'";
			}

			//版型分類
			$dataC = $dalC->executeRecordset("a.`Visible`='1'");
			if(count($dataC) > 0){
				if($id == "0"){
					$dal->TemplateID = $tid;
					$dal->loadRecord();
					if($dal->CategoryID != '0' && $dal->CategoryID != ''){
						$id = $dal->CategoryID;
					}
				}
				if($id == "0"){
					$id = $dataC[0]["CategoryID"];
					$dataC[0]["className"] = " class='active'";
				}else{
					for($i=0;$i<count($dataC);$i++){
						if($dataC[$i]["CategoryID"] == $id){
							$dataC[$i]["className"] = " class='active'";
						}
					}
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			$data = $dal->executeRecordset($filter);
			for($i=0;$i<count($data);$i++){
				$data[$i]["Description"] = str_replace("\r\n","<br />",$data[$i]["Description"]);
				if($data[$i]["File"] == "" || !file_exists("..".$data[$i]["File"])){
					$data[$i]["fileStyle"] = " style='display:none;'";
				}
			}
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);
			
			parent::addParameter("webTemplates",registryDAL::getRegistryValue("webTemplates"));
			parent::loadTemplateFile(dirname(__FILE__)."/templates/templateSet.html"); 		
			parent::loadData();
		}
		public function saveData(){
			$templateID = conver::toDbString(trim($_POST["TemplateID"]));
			registryDAL::saveRegistry("webTemplates",$templateID);
			parent::redirect("templateSet.php");
		}
	}

	$page = new _templateSet();
	$page->load();
	$page->render(); 
?>