<?php
	require_once "pageBase.php";
	require_once "../dal/templateDAL.php";
	require_once "../bin/web/repeater.php";

	class _templateList extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('34')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			$dal = new templateDAL();
			$data = $dal->executeRecordset();
			$data = $this->formatData($data);
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/templateList.html");
			parent::loadData();
		}

		private function formatData($data){
			for($i=0;$i<count($data);$i++){
				if($data[$i]["Image"] != ""){
					$data[$i]["Image"] = "<img src=\"".$data[$i]["Image"]."\" style=\"height:50px;\">";
				}
				if($data[$i]["Visible"] == "1")
					$data[$i]["Visible"] = "<span style=\"color:#090;\">&#10003</span>";
				else
					$data[$i]["Visible"] = "<span style=\"color:#f00;\">&#10005</span>";
			}
			return $data;
		}
	}

	$page = new _templateList();
	$page->load();
	$page->render();
?>