<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/templateDAL.php";
	require_once "../dal/template_categoryDAL.php";

	class _templateEdit extends pageBase{
		private $id;
		private $dal,$dalC;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('34')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->id = parent::getPageParameter("id","0");
			$this->dal = new templateDAL();
			$this->dalC = new template_categoryDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->TemplateID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("CategoryID",$this->dal->CategoryID);
				parent::addParameter("TemplateName",$this->dal->TemplateName);
				parent::addParameter("PathName",$this->dal->PathName);
				parent::addParameter("Image",$this->dal->Image);
				parent::addParameter("File",$this->dal->File);
				parent::addParameter("Website",$this->dal->Website);
				parent::addParameter("Description",$this->dal->Description);
				parent::addParameter("Visible",$this->dal->Visible);
				parent::addParameter("OrderNO",$this->dal->OrderNO);
				parent::addParameter("editTitle","修改版型內容");
			}else{
				parent::addParameter("Visible","1");
				parent::addParameter("editTitle","新增版型");
			}

			$dataC = $this->dalC->executeRecordset("a.`Visible`='1'");
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $dataC;
			parent::addControl($listC);

			parent::addParameter("id",$this->id);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/templateEdit.html");
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->TemplateID = $this->id;
				$this->dal->loadRecord();
			}
			$this->dal->CategoryID = conver::toDbString(trim($_POST["CategoryID"]));
			$this->dal->TemplateName = conver::toDbString(trim($_POST["TemplateName"]));
			$pathName = conver::toDbString(trim($_POST["PathName"]));
			$this->dal->Image = conver::toDbString(trim($_POST["Image"]));
			$this->dal->File = conver::toDbString(trim($_POST["File"]));
			$this->dal->Website = conver::toDbString(trim($_POST["Website"]));
			$this->dal->Description = conver::toDbString(trim($_POST["Description"]));
			$this->dal->Visible = conver::toDbString(trim($_POST["Visible"]));
			$this->dal->OrderNO = is_numeric($_POST["OrderNO"])?$_POST["OrderNO"]:0;

			$saved = false;
			if($this->id != "" && $this->id != "0"){
				//判斷路徑名稱是否重複
				if($this->dal->checkPathNameExists($pathName) && $this->dal->PathName != $pathName){
					parent::alert("路徑名稱\\\"".$pathName."\\\"已經存在！");
					exit;
				}
				$this->dal->PathName = $pathName;
				$saved = $this->dal->updateRecord();
			}else{
				//判斷路徑名稱是否重複
				if($this->dal->checkPathNameExists($pathName)){
					parent::alert("路徑名稱\\\"".$pathName."\\\"已經存在！");
					exit;
				}
				$this->dal->PathName = $pathName;
				$saved = $this->dal->insertRecord();
			}
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect("templateList.php");
			}
		}
	}

	$page = new _templateEdit();
	$page->load();
	$page->render();
?>