<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/pictureDAL.php";
	require_once "../dal/registryDAL.php";
	class _small_pictureSet extends pageBase{
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('41')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->dal = new pictureDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			$smallPictureShow = registryDAL::getRegistryValue("smallPictureShow");
			$aryP = array();
			for($i=1;$i<5;$i++){
				$ary = array();
				$this->dal->PictureType = "120";
				$this->dal->TypeOrderNO = $i;
				$this->dal->loadRecord();
				$ary["NO"] = $i;
				$ary["Image"] = $this->dal->Image;
				$ary["Title"] = $this->dal->Title;
				$ary["Link"] = $this->dal->Link;
				$aryP[] = $ary;
			}
			$listP = new repeater();
			$listP->id = "listP";
			$listP->dataSource = $aryP;
			parent::addControl($listP);
			
			$arySP = explode(",",$smallPictureShow);
			$dataSP = array();
			foreach($arySP as $value){
				$dataSP[]["Value"] = $value;
			}
			$listSP = new repeater();
			$listSP->id = "listSP";
			$listSP->dataSource = $dataSP;
			parent::addControl($listSP);

			parent::loadTemplateFile(dirname(__FILE__)."/templates/small_pictureSet.html");
			parent::loadData();
		}
		public function saveData(){
			$arySP = $_POST["smallPictureShow"];
			if(isset($arySP)){
				$smallPictureShow = implode(",",$arySP);
			}else{
				$smallPictureShow = "";
			}

			$this->dal->PictureType = "120";
			for($i=1;$i<5;$i++){
				$this->dal->TypeOrderNO = $i;
				$this->dal->Image = conver::toDbString(trim($_POST["Image".$i]));
				$this->dal->Title = conver::toDbString(trim($_POST["Title".$i]));
				$this->dal->Link = conver::toDbString(trim($_POST["Link".$i]));
				$this->dal->replaceRecord();
			}
			
			registryDAL::saveRegistry("smallPictureShow",$smallPictureShow);

			parent::redirect("small_pictureSet.php");
		}
	}

	$page = new _small_pictureSet();
	$page->load();
	$page->render();
?>