<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../dal/registryDAL.php";
	class _seoSet extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('32')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}
		public function loadData(){
			$webTitle = registryDAL::getRegistryValue("webTitle");
			$webKeyword = registryDAL::getRegistryValue("webKeyword");
			$webDescription = registryDAL::getRegistryValue("webDescription");
			$webH1 = registryDAL::getRegistryValue("webH1");
			$webCopy = registryDAL::getRegistryValue("webCopy");
			$webMarquee = registryDAL::getRegistryValue("webMarquee");
			$webFooter = registryDAL::getRegistryValue("webFooter");
			parent::addParameter("webTitle",$webTitle);
			parent::addParameter("webKeyword",$webKeyword);
			parent::addParameter("webDescription",$webDescription);
			parent::addParameter("webH1",$webH1);
			parent::addParameter("webCopy",$webCopy);
			parent::addParameter("webMarquee",$webMarquee);
			parent::addParameter("webFooter",$webFooter);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/seoSet.html");
			parent::loadData();
		}
		public function saveData(){
			$webTitle = conver::toDbString($_POST["webTitle"]);
			$webKeyword = conver::toDbString($_POST["webKeyword"]);
			$webDescription = conver::toDbString($_POST["webDescription"]);
			$webH1 = conver::toDbString($_POST["webH1"]);
			$webCopy = conver::toDbString($_POST["webCopy"]);
			$webMarquee = conver::toDbString($_POST["webMarquee"]);
			$webFooter = $_POST["webFooter"];
			if(!get_magic_quotes_gpc()){
				$webFooter = addslashes($webFooter);
			}
			registryDAL::saveRegistry("webTitle",$webTitle);
			registryDAL::saveRegistry("webKeyword",$webKeyword);
			registryDAL::saveRegistry("webDescription",$webDescription);
			registryDAL::saveRegistry("webH1",$webH1);
			registryDAL::saveRegistry("webCopy",$webCopy);
			registryDAL::saveRegistry("webMarquee",$webMarquee);
			registryDAL::saveRegistry("webFooter",$webFooter);
			parent::redirect("seoSet.php");
		}
	}

	$page = new _seoSet();
	$page->load();
	$page->render();
?>