<?php
	require_once "pageBase.php";
	require_once "../dal/userDAL.php";
	require_once "../bin/system/utility.php";

	class _quick_login extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			/* 錯誤鎖定 */
			if(file_exists("loginerror.txt")){
				$errlog = file_get_contents("loginerror.txt");
				if($errlog != ""){
					$aryErr = json_decode($errlog);
				}else{
					$aryErr = array();
				}
			}else{
				$aryErr = array();
			}
			if(!empty($_SERVER['HTTP_CLIENT_IP'])){
				$myip = $_SERVER['HTTP_CLIENT_IP'];
			}else if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
				$myip = $_SERVER['HTTP_X_FORWARDED_FOR'];
			}else{
				$myip= $_SERVER['REMOTE_ADDR'];
			}
			//$myip = parent::specialtocode($myip);
			/* 錯誤鎖定 */
			/* 參數檢查 */
			//$checkCode = parent::getGet("cc");
			$checkCode = trim($_GET["cc"]);
			if(!preg_match("/^[A-Z]{10}$/", $checkCode)){
				echo "<script>".PHP_EOL;
				echo "alert('參數異常!請重新整理頁面再試一次!');".PHP_EOL;
				echo "window.close();".PHP_EOL;
				echo "</script>";
				exit;
			}
			/* 檢索快速登入資料 */
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "https://tq33.org/k_quick_login2-".$checkCode.".html");
			curl_setopt($ch, CURLOPT_HEADER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			$txtJ = curl_exec($ch);
			curl_close($ch);
			$objJ = json_decode($txtJ);
			if($objJ->error == "0"){
				$loginName = trim($objJ->login);
				$password = trim($objJ->pass);
				$websiteUrl = trim($objJ->url);
				$http_host = preg_replace("/^https?:/", "", $websiteUrl);
				$http_host = preg_replace("/^\/\//", "", $http_host);
				$http_host = preg_replace("/^www\./", "", $http_host);
				$http_host = preg_replace("/\/.*$/", "", $http_host);
				/* 檢查快速登入網域 */
				if(preg_replace("/^www\./", "", $_SERVER["HTTP_HOST"]) != $http_host){
					echo "<script>".PHP_EOL;
					echo "alert('快速登入網域與本網域不吻合!請勿非法操作!');".PHP_EOL;
					echo "window.close();".PHP_EOL;
					echo "</script>";
				}
				/* 快速登入 */
				$dalU = new userDAL();
				$dalU->LoginName = $loginName;
				$dalU->loadRecord();
				if(!isset($dalU->UserID) || $dalU->UserID == "" || $dalU->UserID == 0 || ($dalU->Flags & 1) >0 || (($dalU->UserType & userType::$admin) == 0 && ($dalU->UserType & userType::$administrator) == 0)){
					/* 錯誤鎖定 */
					$aryErr[] = array("Time" => date("Y-m-d H:i:s"), "IP" => $myip, "LoginName" => urlencode($loginName), "Password" => urlencode($password), "Checknum" => urlencode($checknum));
					$newlog = json_encode($aryErr);
					file_put_contents("loginerror.txt", $newlog);
					/* 錯誤鎖定 */
					echo "<script>".PHP_EOL;
					echo "alert('用戶不存在,請聯繫管理員!');".PHP_EOL;
					echo "window.close();".PHP_EOL;
					echo "</script>";
				}else if($password != $dalU->Password){
					/* 錯誤鎖定 */
					$aryErr[] = array("Time" => date("Y-m-d H:i:s"), "IP" => $myip, "LoginName" => urlencode($loginName), "Password" => urlencode($password), "Checknum" => urlencode($checknum));
					$newlog = json_encode($aryErr);
					file_put_contents("loginerror.txt", $newlog);
					/* 錯誤鎖定 */
					echo "<script>".PHP_EOL;
					echo "alert('密碼錯誤,請聯繫管理員!');".PHP_EOL;
					echo "window.close();".PHP_EOL;
					echo "</script>";
				}else if($dalU->Visible != "1"){
					/* 錯誤鎖定 */
					$aryErr[] = array("Time" => date("Y-m-d H:i:s"), "IP" => $myip, "LoginName" => urlencode($loginName), "Password" => urlencode($password), "Checknum" => urlencode($checknum));
					$newlog = json_encode($aryErr);
					file_put_contents("loginerror.txt", $newlog);
					/* 錯誤鎖定 */
					echo "<script>".PHP_EOL;
					echo "alert('管理帳號已被停權!');".PHP_EOL;
					echo "window.close();".PHP_EOL;
					echo "</script>";
				}else{
					/* 錯誤鎖定 */
					if(file_exists("loginerror.txt")){
						rename("loginerror.txt", "loginerror_".time().".txt");
					}
					/* 錯誤鎖定 */

					$info = new userInfo();
					$info->userID = $dalU->UserID;
					$info->loginName = $dalU->LoginName;
					$info->userName = $dalU->UserName;
					$info->userType = $dalU->UserType;

					$_SESSION[sessionKeys::$adminUserID] = $dalU->UserID;
					$_SESSION[sessionKeys::$userInfo] = $info;

					$dalU->LoginTimes = time();
					$dalU->LastLoginIp = $myip;
					$dalU->LastLoginTime = date("Y-m-d H:i:s");
					$dalU->updateRecord();

					//header("Location: /iweb/");
					header("Location: /apple/");																																			
				}
			}else{
				echo "<script>".PHP_EOL;
				echo "alert('".$objJ->msg."');".PHP_EOL;
				echo "window.close();".PHP_EOL;
				echo "</script>";
			}

			parent::load();
		}
	}

	$page = new _quick_login();
	$page->load();
	$page->render();
?>