<?php
	require_once "pageBase.php";
	require_once "../bin/system/utility.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/categoryDAL.php";
	require_once "../dal/productDAL.php";

	class _productList extends pageBase{
		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('18')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->loadData();
			parent::load();
		}
		public function loadData(){
			//宣告和參數
			$dal = new productDAL();
			$dalC = new categoryDAL();
			$cid = parent::getPageParameter("cid","0");
			$kw = parent::getPageParameter("kw","");
			$pz = parent::getPageParameter("pz","40");
			$p = parent::getPageParameter("p","1");

			parent::addParameter("cid",$cid);
			parent::addParameter("kw",$kw);
			parent::addParameter("pz",$pz);
			parent::addParameter("p",$p);

			//搜尋條件、排序順序
			$filter = "(a.`ProductName` LIKE '%".$kw."%' OR a.`ProductNO` LIKE '%".$kw."%')";
			if($cid != "0"){
				$filter .= " AND (a.`CategoryID`='".$cid."' OR c.`CategoryID`='".$cid."')";
			}
			$orderExp = "c.`OrderNO`,b.`OrderNO`,a.`OrderNO`,a.`CreatedTime` DESC";

			//頁數參數
			$start = ($p - 1) * $pz;
			$rows = $dal->countRecordset($filter);

			//產品列表
			$data = $dal->executeRecordset($filter,$orderExp,$start,$pz);
			$data = $this->formatData($data);
			$list = new repeater();
			$list->id = "list";
			$list->dataSource = $data;
			parent::addControl($list);

			//頁導航
			if($rows > 0){
				$nm1 = $rows % $pz;
				$nm2 = ($rows - $nm1) / $pz;
				if($nm1 > 0)
					$nm2++;
				$nm3 = $p % 10;
				$nm4 = ($p - $nm3) / 10;
				if($nm3 == 0)
					$nm4--;
				$pagtxt = '<a data-action="goPage" data-id="';
				if($p == 1){
					$pagtxt .= "1";
				}else{
					$pagtxt .= ($p - 1);
				}
				$pagtxt .= '" href="javascript:void(0);">&lt; 上一頁</a>';
				for($i=1;$i<11;$i++){
					if($nm4 * 10 + $i == $p){
						$pagtxt .= '<span class="number_hit">'.$p.'</span>';
					}else{
						$pagtxt .= '<a data-action="goPage" data-id="'.($nm4 * 10 + $i).'" href="javascript:void(0);">'.($nm4 * 10 + $i).'</a>';
					}
					if($nm4 * 10 + $i == $nm2){
						$i = 12;
					}
				}
				$pagtxt .= '<a data-action="goPage" data-id="';
				if($p == $nm2){
					$pagtxt .= $nm2;
				}else{
					$pagtxt .= ($p + 1);
				}
				$pagtxt .= '" href="javascript:void(0);">下一頁 &gt;</a>';
			}else{
				$pagtxt = '沒有資料';
			}
			parent::addParameter("pagtxt",$pagtxt);

			//產品分類下拉
			$aryC = array();
			$dataC1 = $dalC->executeRecordset("a.`ParentID`='0' AND a.`Visible`='1'");
			for($i=0;$i<count($dataC1);$i++){
				$dataC1[$i]["opStyle"] = ' style="color:#f00;"';
				$aryC[] = $dataC1[$i];
				$dataC2 = $dalC->executeRecordset("a.`ParentID`='".$dataC1[$i]["CategoryID"]."' AND a.`Visible`='1'");
				for($j=0;$j<count($dataC2);$j++){
					$dataC2[$j]["opStyle"] = ' style="color:#00f;"';
					$aryC[] = $dataC2[$j];
				}
			}
			$listC = new repeater();
			$listC->id = "listC";
			$listC->dataSource = $aryC;
			parent::addControl($listC);

			parent::addParameter("currentUrl",utility::getCurrentUrl());
			parent::addParameter("encodeUrl",urlencode(utility::getCurrentUrl()));
			parent::loadTemplateFile(dirname(__FILE__)."/templates/productList.html");
			parent::loadData();
		}
		public function formatData($data){
			for($i=0;$i<count($data);$i++){
				if($data[$i]["IsIndex"] == "1")
					$data[$i]["IsIndex"] = "<span style=\"color:#090;\">&#10003</span>";
				else
					$data[$i]["IsIndex"] = "<span style=\"color:#f00;\">&#10005</span>";

				if($data[$i]["Visible"] == "1")
					$data[$i]["Visible"] = "<span style=\"color:#090;\">&#10003</span>";
				else
					$data[$i]["Visible"] = "<span style=\"color:#f00;\">&#10005</span>";

				$data[$i]["AverageStar"] = round($data[$i]["AverageStar"]);
				$data[$i]["averageStarIcon"] = "";
				for($j=0;$j<$data[$i]["AverageStar"];$j++){
					$data[$i]["averageStarIcon"] .= "<i class='fa fa-star light'></i>";
				}
				$data[$i]["averageStar2"] = 5 - (int)$data[$i]["AverageStar"];
				for($k=0;$k<$data[$i]["averageStar2"];$k++){
					$data[$i]["averageStarIcon"] .= "<i class='fa fa-star'></i>";
				}
				if($data[$i]["AverageStar"] <= 0){
					$data[$i]["AverageStar"] = "0";
				}

				$data[$i]["htLink"] = $this->htLink4;
				$data[$i]["encodeUrl"] = urlencode(utility::getCurrentUrl());
			}
			return $data;
		}
	}

	$page = new _productList();
	$page->load();
	$page->render();
?>