<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/categoryDAL.php";
	require_once "../dal/productDAL.php";
	require_once "../dal/registryDAL.php";
	require_once "../dal/commentDAL.php";

	class _productEdit extends pageBase{
		private $id,$pUrl;
		private $dal,$dalC,$dalM;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('18')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->id = parent::getPageParameter("id","0");
			$this->pUrl = urldecode(parent::getPageParameter("pUrl","productList.php"));

			$this->dal = new productDAL();
			$this->dalC = new categoryDAL();
			$this->dalM = new commentDAL();

			if(!parent::isPostBack())
				$this->loadData();
			else
				$this->saveData();

			parent::load();
		}

		public function loadData(){
			//分類下拉JSON
			$dataC1 = $this->dalC->executeRecordset("a.`ParentID`='0' AND a.`Visible`='1'");
			for($i=0;$i<count($dataC1);$i++){
				$aryC1 = array();
				$aryC1["ID"] = $dataC1[$i]["CategoryID"];
				$aryC1["Name"] = urlencode($dataC1[$i]["CategoryName"]);
				$aryC1["Sub"] = array();
				$dataC2 = $this->dalC->executeRecordset("a.`ParentID`='".$dataC1[$i]["CategoryID"]."' AND a.`Visible`='1'");
				for($j=0;$j<count($dataC2);$j++){
					$aryC2 = array();
					$aryC2["SubID"] = $dataC2[$j]["CategoryID"];
					$aryC2["SubName"] = urlencode($dataC2[$j]["CategoryName"]);
					$aryC1["Sub"][] = $aryC2;
				}
				$aryC[] = $aryC1;
			}
			$jsonC = urldecode(json_encode($aryC));
			parent::addParameter("jsonC",$jsonC);

			if($this->id != "" && $this->id != "0"){
				$this->dal->ProductID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("CategoryID",$this->dal->CategoryID);
				parent::addParameter("ProductName",$this->dal->ProductName);
				parent::addParameter("ProductNO",$this->dal->ProductNO);
				parent::addParameter("OldPrice",$this->dal->OldPrice);
				parent::addParameter("Price",$this->dal->Price);
				parent::addParameter("IconImage",$this->dal->IconImage);
				parent::addParameter("Image1",$this->dal->Image1);
				parent::addParameter("Image2",$this->dal->Image2);
				parent::addParameter("Image3",$this->dal->Image3);
				parent::addParameter("Image4",$this->dal->Image4);
				parent::addParameter("Introduction",$this->dal->Introduction);
				parent::addParameter("Title1",$this->dal->Title1);
				parent::addParameter("Title2",$this->dal->Title2);
				parent::addParameter("Title3",$this->dal->Title3);
				parent::addParameter("Description1",$this->dal->Description1);
				parent::addParameter("Description2",$this->dal->Description2);
				parent::addParameter("Description3",$this->dal->Description3);
				parent::addParameter("ViewCount",$this->dal->ViewCount);
				parent::addParameter("IsIndex",$this->dal->IsIndex);
				parent::addParameter("Visible",$this->dal->Visible);
				parent::addParameter("OrderNO",$this->dal->OrderNO);
				parent::addParameter("WebTitle",$this->dal->WebTitle);
				parent::addParameter("WebKeyword",$this->dal->WebKeyword);
				parent::addParameter("WebDescription",$this->dal->WebDescription);
				parent::addParameter("editTitle","修改產品資訊");
				
				//計算分數
				$averageStarIcon = "<font class='star'>";
				for($i=0;$i<$this->dal->AverageStar;$i++){
					$averageStarIcon .= "<i class='fa fa-star light'></i>";
				}
				$averageStar2 = 5 - (int)$this->dal->AverageStar;
				for($i=0;$i<$averageStar2;$i++){
					$averageStarIcon .= "<i class='fa fa-star'></i>";
				}
				$averageStarIcon .= "</font>";
				if($this->dal->AverageStar > 0){
					parent::addParameter("commentC","");
					parent::addParameter("commentText","");
					parent::addParameter("averageStar",round($this->dal->AverageStar)."分");
					parent::addParameter("totalNO",$this->dal->TotalNO);
				}else{
					parent::addParameter("commentC"," style='display:none;'");
					parent::addParameter("commentText","<p style='text-align:center;'>目前暫無評論!!</p>");
					parent::addParameter("averageStar","0");
					parent::addParameter("totalNO","0");
				}
				parent::addParameter("averageStarIcon",$averageStarIcon);
			}else{
				parent::addParameter("ViewCount","0");
				parent::addParameter("IsIndex","1");
				parent::addParameter("Visible","1");
				parent::addParameter("editTitle","新增產品");
				parent::addParameter("commentC"," style='display:none;'");
				parent::addParameter("commentText","<p style='text-align:center;'>目前暫無評論!!</p>");
				parent::addParameter("averageStar","0");
				parent::addParameter("totalNO","0");
			}
			
			//評論
			$dataM = $this->dalM->executeRecordset("a.`ProductID`='".$this->id."' AND a.`Visible`='1'","a.`CreatedTime`",0,-1);
			for($i=0;$i<count($dataM);$i++){
				$dataM[$i]["Stars"] = round($dataM[$i]["Stars"]);
				$dataM[$i]["Stars2"] = 5 - (int)$dataM[$i]["Stars"];
				$dataM[$i]["StarsIcon"] = "";
				for($j=0;$j<$dataM[$i]["Stars"];$j++){
					$dataM[$i]["StarsIcon"] .= "<i class='fa fa-star light'></i>";
				}
				for($k=0;$k<$dataM[$i]["Stars2"];$k++){
					$dataM[$i]["StarsIcon"] .= "<i class='fa fa-star'></i>";
				}
				$dataM[$i]["CreatedTime"] = date("Y-m-d",strtotime($dataM[$i]["CreatedTime"]));
			}
			$listM = new repeater();
			$listM->id = "listM";
			$listM->dataSource = $dataM;
			parent::addControl($listM);

			parent::addParameter("id",$this->id);
			parent::addParameter("pUrl",$this->pUrl);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/productEdit.html");
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->ProductID = $this->id;
				$this->dal->loadRecord();
			}else{
				$this->dal->ViewCount = "0";
				$this->dal->CreatedUserID = parent::getCurrentUserID();
			}

			$this->dal->CategoryID = conver::toDbString(trim($_POST["CategoryID"]));
			$this->dal->ProductName = conver::toDbString(trim($_POST["ProductName"]));
			$this->dal->ProductNO = conver::toDbString(trim($_POST["ProductNO"]));
			$this->dal->OldPrice = conver::toDbString(trim($_POST["OldPrice"]));
			if($this->dal->OldPrice == ""){
				$this->dal->OldPrice = "0";
			}			
			$this->dal->Price = conver::toDbString(trim($_POST["Price"]));
			if($this->dal->Price == ""){
				$this->dal->Price = "0";
			}
			$this->dal->IconImage = conver::toDbString(trim($_POST["IconImage"]));
			$this->dal->Image1 = conver::toDbString(trim($_POST["Image1"]));
			$this->dal->Image2 = conver::toDbString(trim($_POST["Image2"]));
			$this->dal->Image3 = conver::toDbString(trim($_POST["Image3"]));
			$this->dal->Image4 = conver::toDbString(trim($_POST["Image4"]));
			$this->dal->Introduction = conver::toDbString(trim($_POST["Introduction"]));
			//$this->dal->Introduction = str_replace("\r\n","",$this->dal->Introduction);
			$this->dal->Title1 = conver::toDbString(trim($_POST["Title1"]));
			$this->dal->Title2 = conver::toDbString(trim($_POST["Title2"]));
			$this->dal->Title3 = conver::toDbString(trim($_POST["Title3"]));
			$this->dal->Description1 = conver::toDbString(trim($_POST["Description1"]));
			$this->dal->Description2 = conver::toDbString(trim($_POST["Description2"]));
			$this->dal->Description3 = conver::toDbString(trim($_POST["Description3"]));
			$this->dal->IsIndex = conver::toDbString(trim($_POST["IsIndex"]));
			$this->dal->Visible = conver::toDbString(trim($_POST["Visible"]));
			$this->dal->OrderNO = is_numeric($_POST["OrderNO"])?$_POST["OrderNO"]:0;
			
			$reg = new registryDAL();
			$reglist = $reg->getRegistryValues();
			$indexTitle = $reglist["webTitle"];
			$indexDescription = $reglist["webDescription"];
			
			$this->dal->WebTitle = conver::toDbString(trim($_POST["WebTitle"]));
			$this->dal->WebTitle = str_replace("\r\n","",$this->dal->WebTitle);
			if(trim($this->dal->WebTitle) == "")
				$this->dal->WebTitle = $this->dal->ProductName."-".$indexTitle;
			$this->dal->WebKeyword = conver::toDbString(trim($_POST["WebKeyword"]));
			$this->dal->WebKeyword = str_replace("\r\n","",$this->dal->WebKeyword);
			if(trim($this->dal->WebKeyword) == ""){
				$this->dalC->CategoryID = $this->dal->CategoryID;
				$this->dalC->loadRecord();
				$this->dal->WebKeyword = $this->dal->ProductName.",".$this->dalC->CategoryName;
				if($this->dalC->ParentName != "")
					$this->dal->WebKeyword .= ",".$this->dalC->ParentName;
			}
			$this->dal->WebDescription = conver::toDbString(trim($_POST["WebDescription"]));
			$this->dal->WebDescription = str_replace("\r\n","",$this->dal->WebDescription);
			if(trim($this->dal->WebDescription) == "")
				$this->dal->WebDescription = $indexDescription;
			$this->dal->ModifiedUserID = parent::getCurrentUserID();

			$saved = false;
			if($this->id != "" && $this->id != "0"){
				$saved = $this->dal->updateRecord();
			}else{
				$saved = $this->dal->insertRecord();
			}
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect($this->pUrl);
			}
		}
	}

	$page = new _productEdit();
	$page->load();
	$page->render();
?>