<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../dal/bookDAL.php";
	require_once "../dal/photoDAL.php";

	class _photoMulti extends pageBase{
		private $bookID,$pUrl2;
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('26')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->bookID = parent::getPageParameter("bookID","0");
			$this->pUrl2 = parent::getPageParameter("pUrl2","bookList.php");
			$this->dal = new photoDAL();

			if($this->bookID == "0"){
				parent::alert("資料異常!請重新整理再試一次!");
			}else{
				if(!parent::isPostBack())
					$this->loadData();
				else
					$this->saveData();
			}

			parent::load();
		}

		public function loadData(){
			$dalB = new bookDAL();
			$dalB->BookID = $this->bookID;
			$dalB->loadRecord();

			$dataO = $this->dal->executeRecordset("a.`BookID`='".$this->bookID."'","a.`OrderNO` DESC",0,1);
			if(count($dataO) == 0){
				$orderNO = "10";
			}else{
				$orderNO = "".((int)$dataO[0]["OrderNO"] + 10);
			}

			parent::addParameter("OrderNO",$orderNO);
			parent::addParameter("PhotoName",$PhotoName);
			parent::addParameter("BookName",$dalB->BookName);

			parent::addParameter("bookID",$this->bookID);
			parent::addParameter("pUrl2",$this->pUrl2);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/photoMulti.html");
			parent::loadData();
		}
		public function saveData(){
			$image = $_POST["Image"];
			$orderNO = $_POST["OrderNO"];
			$PhotoName = $_POST["PhotoName"];
			if(count($image) == count($orderNO)){
				for($i=0;$i<count($image);$i++){
					$this->dal->BookID = $this->bookID;
					$this->dal->PhotoType = "1";
					$this->dal->Image = conver::toDbString(trim($image[$i]));
					$this->dal->Visible = "1";
					$this->dal->PhotoName = conver::toDbString(trim($PhotoName[$i]));
					$this->dal->OrderNO = is_numeric($orderNO[$i]) ? $orderNO[$i] : 0;
					$this->dal->insertRecord();
				}
			}
			parent::redirect($this->pUrl2);
		}
	}

	$page = new _photoMulti();
	$page->load();
	$page->render();
?>