<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../dal/bookDAL.php";
	require_once "../dal/photoDAL.php";

	class _photoEdit extends pageBase{
		private $id,$bookID,$pUrl2;
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('26')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->id = parent::getPageParameter("id","0");
			$this->bookID = parent::getPageParameter("bookID","0");
			$this->pUrl2 = parent::getPageParameter("pUrl2","bookList.php");
			$this->dal = new photoDAL();

			if($this->id == "0" && $this->bookID == "0"){
				parent::alert("資料異常!請重新整理再試一次!");
			}else{
				if(!parent::isPostBack())
					$this->loadData();
				else
					$this->saveData();
			}

			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->PhotoID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("PhotoName",$this->dal->PhotoName);
				parent::addParameter("Introduction",$this->dal->Introduction);
				parent::addParameter("PhotoType",$this->dal->PhotoType);
				parent::addParameter("Image",$this->dal->Image);
				parent::addParameter("Movie",$this->dal->Movie);
				parent::addParameter("Visible",$this->dal->Visible);
				parent::addParameter("OrderNO",$this->dal->OrderNO);
				parent::addParameter("BookName",$this->dal->BookName);
				parent::addParameter("editTitle","修改相片/影片內容");
			}else{
				$dalB = new bookDAL();
				$dalB->BookID = $this->bookID;
				$dalB->loadRecord();

				$dataO = $this->dal->executeRecordset("a.`BookID`='".$this->bookID."'","a.`OrderNO` DESC",0,1);
				if(count($dataO) == 0){
					$orderNO = "10";
				}else{
					$orderNO = "".((int)$dataO[0]["OrderNO"] + 10);
				}

				parent::addParameter("PhotoType","1");
				parent::addParameter("Visible","1");
				parent::addParameter("OrderNO",$orderNO);
				parent::addParameter("BookName",$dalB->BookName);
				parent::addParameter("editTitle","新增相片/影片");
			}
			parent::addParameter("id",$this->id);
			parent::addParameter("bookID",$this->bookID);
			parent::addParameter("pUrl2",$this->pUrl2);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/photoEdit.html");
			parent::loadData();
		}
		public function saveData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->PhotoID = $this->id;
				$this->dal->loadRecord();
			}else{
				$this->dal->BookID = $this->bookID;
			}
			$this->dal->PhotoName = conver::toDbString(trim($_POST["PhotoName"]));
			$this->dal->Introduction = conver::toDbString(trim($_POST["Introduction"]));
			$this->dal->PhotoType = conver::toDbString(trim($_POST["PhotoType"]));
			$this->dal->Image = conver::toDbString(trim($_POST["Image"]));
			$this->dal->Movie = conver::toDbString(trim($_POST["Movie"]));
			$this->dal->Visible = conver::toDbString(trim($_POST["Visible"]));
			$this->dal->OrderNO = is_numeric($_POST["OrderNO"]) ? $_POST["OrderNO"] : 0;

			$saved = false;
			if($this->id != "" && $this->id != "0"){
				$saved = $this->dal->updateRecord();
			}else{
				$saved = $this->dal->insertRecord();
			}
			if($saved === false){
				parent::alert("儲存時發生錯誤！");
			}else{
				parent::redirect($this->pUrl2);
			}
		}
	}

	$page = new _photoEdit();
	$page->load();
	$page->render();
?>