<?php
	date_default_timezone_set("Asia/Taipei");
	session_start();
	require_once dirname(__FILE__)."/../bin/web/page.php";
	require_once dirname(__FILE__)."/../dal/htaccessDAL.php";
	require_once dirname(__FILE__)."/../dal/limitDAL.php";
	require_once dirname(__FILE__)."/../modules/userInfo.php";
	require_once dirname(__FILE__)."/../modules/userType.php";
	require_once dirname(__FILE__)."/../modules/sessionKeys.php";
	require_once dirname(__FILE__)."/header.php";
	require_once dirname(__FILE__)."/footer.php";
	require_once dirname(__FILE__)."/sidePage.php";

	/* 錯誤鎖定 */
	if(file_exists(dirname(__FILE__)."/loginerror.txt")){
		$errlog = file_get_contents(dirname(__FILE__)."/loginerror.txt");
		if($errlog != ""){
			$aryErr = json_decode($errlog);
			if(count($aryErr) > 5){
				header("HTTP/1.0 404 Not Found");
				header("Status: 404 Not Found");
				exit;
			}
		}
	}
	/* 錯誤鎖定 */
 
	class pageBase extends page{
		public $htLink1,$htLink2,$htLink3,$htLink4,$htLink5,$htLink6,$htLink7;

		public function pageBase(){
			//網頁網址設定
			$dalHT = new htaccessDAL();
			$dalHT->ID = "1";
			$dalHT->loadRecord();
			$this->htLink1 = $dalHT->HtmlName;
			$dalHT->ID = "2";
			$dalHT->loadRecord();
			$this->htLink2 = $dalHT->HtmlName;
			$dalHT->ID = "3";
			$dalHT->loadRecord();
			$this->htLink3 = $dalHT->HtmlName;
			$dalHT->ID = "4";
			$dalHT->loadRecord();
			$this->htLink4 = $dalHT->HtmlName;
			$dalHT->ID = "5";
			$dalHT->loadRecord();
			$this->htLink5 = $dalHT->HtmlName;
			$dalHT->ID = "6";
			$dalHT->loadRecord();
			$this->htLink6 = $dalHT->HtmlName;
			$dalHT->ID = "7";
			$dalHT->loadRecord();
			$this->htLink7 = $dalHT->HtmlName;

			parent::__construct();
		}

		//覆蓋父類load()方法
		public function load(){
			if(!ereg("login\.php",$_SERVER["SCRIPT_NAME"])){
				if(!isset($_SESSION[sessionKeys::$userInfo])){
					parent::redirect("/apple/login.php");
				}
			if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on") {
                header("Location: http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);   
            }
			}
			parent::load();
		}

		public function loadData(){
			$header = new _header();
			$header->userID = $this->getCurrentUserID();
			$header->load();
			parent::addParameter("header",$header->getContent());

			$footer = new _footer();
			$footer->load();
			parent::addParameter("footer",$footer->getContent());

			$sidePage = new _sidePage();
			$sidePage->userID = $this->getCurrentUserID();
			$sidePage->load();
			parent::addParameter("sidePage",$sidePage->getContent());
		}

		public function getCurrentUser(){
			if(!isset($_SESSION[sessionKeys::$userInfo])){
				return null;
			}else{
				$info = (object)$_SESSION[sessionKeys::$userInfo];
				return $info;
			}
		}

		public function getCurrentUserID(){
			if(isset($_SESSION[sessionKeys::$adminUserID]) && $_SESSION[sessionKeys::$adminUserID] != "")
				return (int)$_SESSION[sessionKeys::$adminUserID];
			return 0;
		}

		public function getPageParameter($name,$default){
			$value = "";
			if(isset($_GET[$name]) && $_GET[$name] != "")
				$value = $_GET[$name];
			else if(isset($_POST[$name]) && $_POST[$name] != "")
				$value = $_POST[$name];
			else
				$value = $default;
			return trim($value);
		}

		public function alert($msg){
			echo "";
			echo "<script language=\"javascript\">window.alert(\"".$msg."\");history.back();</script>";
		}
		public function alert2($msg,$url){
			echo "";
			echo "<script language=\"javascript\">window.alert(\"".$msg."\");location.href=\"".$url."\";</script>";
		}
		
		public function chkUserLimit($menuID){
			$dalL = new limitDAL();
			if($this->getCurrentUserID() == "1"){
				return true;
			}else{
				if($dalL->countRecordset(array(), "a.`UserID`=".$this->getCurrentUserID()." AND a.`MenuID`=".$menuID."") == 0){
					return false;
				}else{
					return true;
				}
			}
		}
	}
?>