<?php
	require_once "pageBase.php";
	require_once "../bin/system/conver.php";
	require_once "../bin/web/repeater.php";
	require_once "../dal/orderDAL.php";
	require_once "../dal/registryDAL.php";

	class _orderView extends pageBase{
		private $id,$pUrl;
		private $dal;

		//覆蓋父類load()方法
		public function load(){
			if(!parent::chkUserLimit('56')){
				parent::alert2('您沒有使用此頁面的權限!如有疑問請洽主管理者!','index.php');
				exit;
			}

			$this->dal = new orderDAL();
			$this->id = parent::getPageParameter("id","0");
			$this->pUrl = urldecode(parent::getPageParameter("pUrl","orderList.php"));

			$this->loadData();
			parent::load();
		}

		public function loadData(){
			if($this->id != "" && $this->id != "0"){
				$this->dal->OrderID = $this->id;
				$this->dal->loadRecord();
				parent::addParameter("ProductPrice",$this->dal->ProductPrice);
				parent::addParameter("TransPrice",$this->dal->TransPrice);
				parent::addParameter("OrderPrice",$this->dal->OrderPrice);
				parent::addParameter("Name",$this->dal->Name);
				parent::addParameter("Email",$this->dal->Email);
				parent::addParameter("Phone",$this->dal->Phone);
				parent::addParameter("Mobile",$this->dal->Mobile);
				parent::addParameter("Address",$this->dal->Address);
				parent::addParameter("Content",$this->dal->Content);
				parent::addParameter("CreatedIP",$this->dal->CreatedIP);
				parent::addParameter("CreatedTime",$this->dal->CreatedTime);

				$dataOP = $this->dal->OrderProduct;
				for($i=0;$i<count($dataOP);$i++){
					if(trim($dataOP[$i]["IconImage"]) != "" && file_exists("..".$dataOP[$i]["IconImage"])){
						$dataOP[$i]["imageStyle"] = "";
					}else{
						$dataOP[$i]["IconImage"] = "/images/no-pic.jpg";
						$dataOP[$i]["imageStyle"] = " style='display:none;'";
					}
					$dataOP[$i]["htLink"] = $this->htLink4;
					$dataOP[$i]["Amount"] = "".((int)$dataOP[$i]["Price"] * (int)$dataOP[$i]["Quantity"]);
				}
				$listOP = new repeater();
				$listOP->id = "listOP";
				$listOP->dataSource = $dataOP;
				parent::addControl($listOP);

				//讀取狀態變更
				$this->dal->view();
			}else{
				parent::redirect($this->pUrl);
			}

			parent::addParameter("id",$this->id);
			parent::addParameter("pUrl",$this->pUrl);
			parent::loadTemplateFile(dirname(__FILE__)."/templates/orderView.html");
			parent::loadData();
		}
	}

	$page = new _orderView();
	$page->load();
	$page->render();
?>